/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.ingredients.ItemStackIngredient;
import net.dries007.tfc.common.recipes.inventory.BarrelInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class BarrelRecipe
implements ISimpleRecipe<BarrelInventory> {
    private final ResourceLocation id;
    protected final ItemStackIngredient inputItem;
    protected final FluidStackIngredient inputFluid;
    protected final ItemStackProvider outputItem;
    protected final FluidStack outputFluid;
    protected final SoundEvent sound;

    public BarrelRecipe(ResourceLocation id, Builder builder) {
        this.id = id;
        this.inputItem = builder.inputItem;
        this.inputFluid = builder.inputFluid;
        this.outputItem = builder.outputItem;
        this.outputFluid = builder.outputFluid;
        this.sound = builder.sound;
    }

    public void assembleOutputs(BarrelInventory inventory) {
        inventory.whileMutable(() -> {
            FluidStack outputFluid;
            int remainingItemCount;
            ItemStack outputItem;
            ItemStack stack = Helpers.removeStack((IItemHandler)inventory, 2);
            FluidStack fluid = inventory.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            int multiplier = this.inputItem.count() == 0 ? fluid.getAmount() / this.inputFluid.amount() : (this.inputFluid.amount() == 0 ? stack.m_41613_() / this.inputItem.count() : Math.min(fluid.getAmount() / this.inputFluid.amount(), stack.m_41613_() / this.inputItem.count()));
            if (!this.outputFluid.isEmpty()) {
                int capacity = (Integer)TFCConfig.SERVER.barrelCapacity.get();
                if (this.outputFluid.isFluidEqual(fluid)) {
                    capacity -= fluid.getAmount();
                }
                int maxMultiplier = capacity / this.outputFluid.getAmount();
                multiplier = Math.min(multiplier, maxMultiplier);
            }
            if (!(outputItem = this.outputItem.getSingleStack(stack)).m_41619_()) {
                Helpers.consumeInStackSizeIncrements(outputItem, multiplier * outputItem.m_41613_(), inventory::insertItemWithOverflow);
            }
            if ((remainingItemCount = stack.m_41613_() - multiplier * this.inputItem.count()) > 0) {
                ItemStack remainingStack = stack.m_41777_();
                remainingStack.m_41764_(remainingItemCount);
                inventory.insertItemWithOverflow(remainingStack);
            }
            if ((outputFluid = this.outputFluid.copy()).isEmpty()) {
                int retainAmount = fluid.getAmount() - multiplier * this.inputFluid.amount();
                if (retainAmount > 0) {
                    FluidStack retainedFluid = fluid.copy();
                    retainedFluid.setAmount(retainAmount);
                    inventory.fill(retainedFluid, IFluidHandler.FluidAction.EXECUTE);
                }
            } else {
                int amount = outputFluid.getAmount() * multiplier;
                if (outputFluid.isFluidEqual(fluid)) {
                    amount += fluid.getAmount();
                }
                outputFluid.setAmount(Math.min((Integer)TFCConfig.SERVER.barrelCapacity.get(), amount));
                inventory.fill(outputFluid, IFluidHandler.FluidAction.EXECUTE);
            }
        });
    }

    public boolean matches(BarrelInventory container, @Nullable Level level) {
        return this.inputItem.test(container.getStackInSlot(2)) && this.inputFluid.test(container.getFluidInTank(0));
    }

    public ItemStack m_8043_(@Nullable RegistryAccess access) {
        return this.outputItem.getEmptyStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public ItemStackIngredient getInputItem() {
        return this.inputItem;
    }

    public ItemStackProvider getOutputItem() {
        return this.outputItem;
    }

    public FluidStackIngredient getInputFluid() {
        return this.inputFluid;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public SoundEvent getCompleteSound() {
        return this.sound;
    }

    public MutableComponent getTranslationComponent() {
        return Component.m_237115_((String)("tfc.recipe.barrel." + this.id.m_135827_() + "." + this.id.m_135815_().replace('/', '.')));
    }

    public record Builder(ItemStackIngredient inputItem, FluidStackIngredient inputFluid, ItemStackProvider outputItem, FluidStack outputFluid, SoundEvent sound) {
        public static Builder fromJson(JsonObject json) {
            FluidStackIngredient inputFluid;
            ItemStackIngredient inputItem = json.has("input_item") ? ItemStackIngredient.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"input_item")) : ItemStackIngredient.EMPTY;
            FluidStackIngredient fluidStackIngredient = inputFluid = json.has("input_fluid") ? FluidStackIngredient.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"input_fluid")) : FluidStackIngredient.EMPTY;
            if (inputItem == ItemStackIngredient.EMPTY && inputFluid == FluidStackIngredient.EMPTY) {
                throw new JsonParseException("Barrel recipe must have at least one of input_item or input_fluid");
            }
            ItemStackProvider outputItem = json.has("output_item") ? ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"output_item")) : ItemStackProvider.empty();
            FluidStack outputFluid = json.has("output_fluid") ? JsonHelpers.getFluidStack(JsonHelpers.m_13930_((JsonObject)json, (String)"output_fluid")) : FluidStack.EMPTY;
            SoundEvent sound = json.has("sound") ? (SoundEvent)JsonHelpers.getRegistryEntry(json, "sound", BuiltInRegistries.f_256894_) : SoundEvents.f_11772_;
            return new Builder(inputItem, inputFluid, outputItem, outputFluid, sound);
        }

        public static Builder fromNetwork(FriendlyByteBuf buffer) {
            ItemStackIngredient inputItem = ItemStackIngredient.fromNetwork(buffer);
            ItemStackProvider outputItem = ItemStackProvider.fromNetwork(buffer);
            Builder builder = Builder.fromNetworkFluidsOnly(buffer);
            return new Builder(inputItem, builder.inputFluid, outputItem, builder.outputFluid, builder.sound);
        }

        public static void toNetwork(BarrelRecipe recipe, FriendlyByteBuf buffer) {
            recipe.inputItem.toNetwork(buffer);
            recipe.outputItem.toNetwork(buffer);
            Builder.toNetworkFluidsOnly(recipe, buffer);
        }

        public static Builder fromNetworkFluidsOnly(FriendlyByteBuf buffer) {
            FluidStackIngredient inputFluid = FluidStackIngredient.fromNetwork(buffer);
            FluidStack outputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            SoundEvent sound = (SoundEvent)BuiltInRegistries.f_256894_.m_200957_(buffer.m_130242_());
            return new Builder(ItemStackIngredient.EMPTY, inputFluid, ItemStackProvider.empty(), outputFluid, sound);
        }

        public static void toNetworkFluidsOnly(BarrelRecipe recipe, FriendlyByteBuf buffer) {
            recipe.inputFluid.toNetwork(buffer);
            recipe.outputFluid.writeToPacket(buffer);
            buffer.m_130130_(BuiltInRegistries.f_256894_.m_7447_((Object)recipe.sound));
        }
    }
}

