/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.AlloyInventory;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AlloyRecipe
implements ISimpleRecipe<AlloyInventory> {
    private final ResourceLocation id;
    private final Map<DataManager.Reference<Metal>, Range> metals;
    private final DataManager.Reference<Metal> result;

    public static Optional<AlloyRecipe> get(RecipeManager recipes, AlloyInventory inventory) {
        return recipes.m_44015_((RecipeType)TFCRecipeTypes.ALLOY.get(), (Container)inventory, null);
    }

    public AlloyRecipe(ResourceLocation id, Map<DataManager.Reference<Metal>, Range> metals, DataManager.Reference<Metal> result) {
        this.id = id;
        this.metals = metals;
        this.result = result;
    }

    public Map<DataManager.Reference<Metal>, Range> getRanges() {
        return this.metals;
    }

    public Metal getResult() {
        return this.result.get();
    }

    public boolean matches(AlloyInventory wrapper, @Nullable Level level) {
        return wrapper.alloy().matches(this);
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.ALLOY.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.ALLOY.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<AlloyRecipe> {
        public AlloyRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            DataManager.Reference<Metal> result = JsonHelpers.getReference(json, "result", Metal.MANAGER);
            JsonArray contents = JsonHelpers.m_13933_((JsonObject)json, (String)"contents");
            IdentityHashMap<DataManager.Reference<Metal>, Range> metals = new IdentityHashMap<DataManager.Reference<Metal>, Range>();
            for (JsonElement element : contents) {
                JsonObject content = JsonHelpers.m_13918_((JsonElement)element, (String)"entry in 'contents'");
                DataManager.Reference<Metal> metal = JsonHelpers.getReference(content, "metal", Metal.MANAGER);
                double min = JsonHelpers.m_144784_((JsonObject)content, (String)"min");
                double max = JsonHelpers.m_144784_((JsonObject)content, (String)"max");
                if (metals.containsKey(metal)) {
                    throw new JsonParseException("Duplicate entry for metal: " + metal.id());
                }
                metals.put(metal, new Range(min, max));
            }
            return new AlloyRecipe(recipeId, metals, result);
        }

        @Nullable
        public AlloyRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            IdentityHashMap<DataManager.Reference<Metal>, Range> metals = new IdentityHashMap<DataManager.Reference<Metal>, Range>();
            for (int i = 0; i < size; ++i) {
                DataManager.Reference<Metal> metal = Metal.MANAGER.getReference(buffer.m_130281_());
                double min = buffer.readDouble();
                double max = buffer.readDouble();
                metals.put(metal, new Range(min, max));
            }
            DataManager.Reference<Metal> result = Metal.MANAGER.getReference(buffer.m_130281_());
            return new AlloyRecipe(recipeId, metals, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlloyRecipe recipe) {
            buffer.m_130130_(recipe.metals.size());
            recipe.metals.forEach((metal, range) -> {
                buffer.m_130085_(metal.id());
                buffer.writeDouble(range.min());
                buffer.writeDouble(range.max());
            });
            buffer.m_130085_(recipe.result.get().getId());
        }
    }

    public record Range(double min, double max) {
        public boolean isIn(double value, double epsilon) {
            return this.min - epsilon <= value && value <= this.max + epsilon;
        }
    }
}

