/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class AdvancedShapedRecipe
extends ShapedRecipe {
    private final ItemStackProvider providerResult;
    private final int inputSlot;

    public AdvancedShapedRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> recipeItems, ItemStackProvider result, int inputSlot) {
        super(id, group, CraftingBookCategory.MISC, width, height, recipeItems, ItemStack.f_41583_);
        this.providerResult = result;
        this.inputSlot = inputSlot;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.providerResult.getEmptyStack();
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryAccess) {
        RecipeHelpers.setCraftingInput(inventory);
        int matchSlot = RecipeHelpers.translateMatch(this, this.inputSlot, inventory);
        ItemStack inputStack = matchSlot != -1 ? inventory.m_8020_(matchSlot).m_41777_() : ItemStack.f_41583_;
        ItemStack result = this.providerResult.getSingleStack(inputStack);
        RecipeHelpers.clearCraftingInput();
        return result;
    }

    public boolean m_5598_() {
        return this.providerResult.dependsOnInput();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.ADVANCED_SHAPED_CRAFTING.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<AdvancedShapedRecipe> {
        public AdvancedShapedRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> keys = RecipeHelpers.keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = RecipeHelpers.shrink(RecipeHelpers.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList<Ingredient> recipeItems = RecipeHelpers.dissolvePattern(pattern, keys, width, height);
            ItemStackProvider providerResult = ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"result"));
            int inputRow = JsonHelpers.m_13927_((JsonObject)json, (String)"input_row");
            int inputCol = JsonHelpers.m_13927_((JsonObject)json, (String)"input_column");
            if (inputRow < 0 || inputRow >= height) {
                throw new JsonParseException("input_row must be in the range [0, height)");
            }
            if (inputCol < 0 || inputCol >= width) {
                throw new JsonParseException("input_column must be in the range [0, width)");
            }
            int inputSlot = RecipeHelpers.dissolveRowColumn(inputRow, inputCol, width);
            return new AdvancedShapedRecipe(recipeId, group, width, height, recipeItems, providerResult, inputSlot);
        }

        public AdvancedShapedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            String group = buffer.m_130277_();
            NonNullList recipeItems = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < recipeItems.size(); ++k) {
                recipeItems.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStackProvider provider = ItemStackProvider.fromNetwork(buffer);
            int inputSlot = buffer.m_130242_();
            return new AdvancedShapedRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)recipeItems, provider, inputSlot);
        }

        public void toNetwork(FriendlyByteBuf buffer, AdvancedShapedRecipe recipe) {
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            buffer.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            recipe.providerResult.toNetwork(buffer);
            buffer.m_130130_(recipe.inputSlot);
        }
    }
}

