/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import java.util.function.IntSupplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.DelegateHeatHandler;
import net.dries007.tfc.common.capabilities.MoldLike;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.HeatHandler;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.container.TFCContainerProviders;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.Tooltips;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoldItem
extends Item {
    private final IntSupplier capacity;
    private final TagKey<Fluid> fluidTag;

    private static IntSupplier mapItemTypeToConfigValue(Metal.ItemType type) {
        ForgeConfigSpec.IntValue intValue = switch (type) {
            case Metal.ItemType.INGOT -> TFCConfig.SERVER.moldIngotCapacity;
            case Metal.ItemType.PICKAXE_HEAD -> TFCConfig.SERVER.moldPickaxeHeadCapacity;
            case Metal.ItemType.PROPICK_HEAD -> TFCConfig.SERVER.moldPropickHeadCapacity;
            case Metal.ItemType.AXE_HEAD -> TFCConfig.SERVER.moldAxeHeadCapacity;
            case Metal.ItemType.SHOVEL_HEAD -> TFCConfig.SERVER.moldShovelHeadCapacity;
            case Metal.ItemType.HOE_HEAD -> TFCConfig.SERVER.moldHoeHeadCapacity;
            case Metal.ItemType.CHISEL_HEAD -> TFCConfig.SERVER.moldChiselHeadCapacity;
            case Metal.ItemType.HAMMER_HEAD -> TFCConfig.SERVER.moldHammerHeadCapacity;
            case Metal.ItemType.SAW_BLADE -> TFCConfig.SERVER.moldSawBladeCapacity;
            case Metal.ItemType.JAVELIN_HEAD -> TFCConfig.SERVER.moldJavelinHeadCapacity;
            case Metal.ItemType.SWORD_BLADE -> TFCConfig.SERVER.moldSwordBladeCapacity;
            case Metal.ItemType.MACE_HEAD -> TFCConfig.SERVER.moldMaceHeadCapacity;
            case Metal.ItemType.KNIFE_BLADE -> TFCConfig.SERVER.moldKnifeBladeCapacity;
            case Metal.ItemType.SCYTHE_BLADE -> TFCConfig.SERVER.moldScytheBladeCapacity;
            default -> throw new AssertionError((Object)("No config value for type: " + type.name()));
        };
        return () -> (Integer)Helpers.getValueOrDefault(intValue);
    }

    public MoldItem(Metal.ItemType type, Item.Properties properties) {
        this(MoldItem.mapItemTypeToConfigValue(type), type == Metal.ItemType.INGOT ? TFCTags.Fluids.USABLE_IN_INGOT_MOLD : TFCTags.Fluids.USABLE_IN_TOOL_HEAD_MOLD, properties);
        assert (type.hasMold());
    }

    public MoldItem(ForgeConfigSpec.IntValue capacity, TagKey<Fluid> fluidTag, Item.Properties properties) {
        this(() -> (Integer)Helpers.getValueOrDefault(capacity), fluidTag, properties);
    }

    public MoldItem(IntSupplier capacity, TagKey<Fluid> fluidTag, Item.Properties properties) {
        super(properties);
        this.capacity = capacity;
        this.fluidTag = fluidTag;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        MoldLike mold = MoldLike.get(stack);
        if (mold != null) {
            if (player.m_6144_()) {
                CastingRecipe recipe = CastingRecipe.get(mold);
                if (recipe != null) {
                    if (mold.isMolten()) {
                        player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.small_vessel.alloy_molten"), true);
                        return InteractionResultHolder.m_19096_((Object)stack);
                    }
                    ItemStack result = recipe.assemble(mold, level.m_9598_());
                    mold.drainIgnoringTemperature(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result);
                    if (player.m_217043_().m_188501_() < recipe.getBreakChance()) {
                        stack.m_41774_(1);
                        level.m_5594_(null, player.m_20183_(), (SoundEvent)TFCSounds.CERAMIC_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
            } else {
                if (mold.isMolten()) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        TFCContainerProviders.MOLD_LIKE_ALLOY.openScreen(serverPlayer, hand);
                    }
                } else if (!mold.getFluidInTank(0).isEmpty()) {
                    player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.small_vessel.alloy_solid"), true);
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean m_142305_(ItemStack stack, ItemStack carried, Slot slot, ClickAction action, Player player, SlotAccess carriedSlot) {
        CastingRecipe recipe;
        MoldLike mold;
        if (action == ClickAction.SECONDARY && !player.m_7500_() && slot.m_150651_(player) && (mold = MoldLike.get(stack)) != null && !mold.isMolten() && (recipe = CastingRecipe.get(mold)) != null) {
            boolean stackable;
            ItemStack result = recipe.assemble(mold, player.m_9236_().m_9598_());
            boolean noCarry = carried.m_41619_();
            boolean bl = stackable = ItemHandlerHelper.canItemStacksStack((ItemStack)result, (ItemStack)carried) && result.m_41613_() + carried.m_41613_() <= carried.m_41741_();
            if (!noCarry && !stackable) {
                return false;
            }
            mold.drainIgnoringTemperature(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            if (noCarry) {
                carriedSlot.m_142104_(result);
            } else {
                carried.m_41769_(result.m_41613_());
            }
            if (player.m_217043_().m_188501_() < recipe.getBreakChance()) {
                stack.m_41774_(1);
                player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)TFCSounds.CERAMIC_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            player.f_36096_.m_6199_(slot.f_40218_);
            return true;
        }
        return false;
    }

    public TagKey<Fluid> getFluidTag() {
        return this.fluidTag;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new MoldCapability(stack, this.capacity.getAsInt(), this.fluidTag);
    }

    public int getMaxStackSize(ItemStack stack) {
        IFluidHandlerItem handler = Helpers.getCapability((ICapabilityProvider)stack.m_255036_(1), Capabilities.FLUID_ITEM);
        if (handler != null && handler.getFluidInTank(0).isEmpty()) {
            return super.getMaxStackSize(stack);
        }
        return 1;
    }

    static class MoldCapability
    implements MoldLike,
    ICapabilityProvider,
    INBTSerializable<CompoundTag>,
    DelegateHeatHandler,
    DelegateFluidHandler {
        private final ItemStack stack;
        private final LazyOptional<MoldCapability> capability;
        private final HeatHandler heat;
        private final FluidTank tank;
        private final int capacity;
        private boolean initialized = false;

        MoldCapability(ItemStack stack, int capacity, TagKey<Fluid> fluidTag) {
            this.stack = stack;
            this.capability = LazyOptional.of(() -> this);
            this.heat = new HeatHandler(1.0f, 0.0f, 0.0f);
            this.tank = new FluidTank(capacity, fluid -> Metal.get(fluid.getFluid()) != null && Helpers.isFluid(fluid.getFluid(), fluidTag));
            this.capacity = capacity;
        }

        @Override
        public void addTooltipInfo(ItemStack stack, List<Component> text) {
            Metal metal;
            this.heat.addTooltipInfo(stack, text);
            FluidStack fluid = this.tank.getFluid();
            if (!fluid.isEmpty() && (metal = Metal.get(fluid.getFluid())) != null) {
                text.add((Component)Component.m_237115_((String)"tfc.tooltip.small_vessel.contents").m_130940_(ChatFormatting.DARK_GREEN));
                text.add((Component)Tooltips.fluidUnitsAndCapacityOf(fluid, this.capacity).m_7220_((Component)Tooltips.moltenOrSolid(this.isMolten())));
            }
        }

        @NotNull
        public ItemStack getContainer() {
            return this.stack;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (this.stack.m_41613_() != 1) {
                return LazyOptional.empty();
            }
            if (cap == HeatCapability.NETWORK_CAPABILITY) {
                return this.capability.cast();
            }
            if (cap == Capabilities.FLUID || cap == Capabilities.FLUID_ITEM || cap == HeatCapability.CAPABILITY) {
                this.load();
                return this.capability.cast();
            }
            return LazyOptional.empty();
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int amount = this.tank.fill(resource, action);
            if (amount > 0) {
                this.updateAndSave();
            }
            return amount;
        }

        @Override
        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == this.tank.getFluid().getFluid()) {
                FluidStack result = this.drain(resource.getAmount(), action);
                if (!result.isEmpty()) {
                    this.updateAndSave();
                }
                return result;
            }
            return FluidStack.EMPTY;
        }

        @Override
        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.isMolten() ? this.drainIgnoringTemperature(maxDrain, action) : FluidStack.EMPTY;
        }

        @Override
        public FluidStack drainIgnoringTemperature(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack result = this.tank.drain(maxDrain, action);
            if (!result.isEmpty()) {
                this.updateAndSave();
            }
            return result;
        }

        @Override
        public IFluidHandler getFluidHandler() {
            return this.tank;
        }

        @Override
        public IHeat getHeatHandler() {
            return this.heat;
        }

        @Override
        public boolean isMolten() {
            Metal metal = this.getContainedMetal();
            if (metal != null) {
                return this.getTemperature() >= metal.getMeltTemperature();
            }
            return false;
        }

        @Override
        public CompoundTag serializeNBT() {
            return this.heat.serializeNBT();
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.heat.deserializeNBT(nbt);
        }

        @Nullable
        private Metal getContainedMetal() {
            return Metal.get(this.tank.getFluid().getFluid());
        }

        private void load() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            @Nullable CompoundTag tag = this.stack.m_41737_("tank");
            if (tag != null) {
                this.tank.readFromNBT(tag);
            }
            this.updateHeatCapacity();
        }

        private void updateHeatCapacity() {
            FluidStack fluid = this.tank.getFluid();
            Metal metal = Metal.get(fluid.getFluid());
            float value = 1.2f;
            if (!fluid.isEmpty() && metal != null) {
                value += metal.getHeatCapacity(fluid.getAmount());
            }
            this.heat.setHeatCapacity(value);
        }

        private void updateAndSave() {
            this.updateHeatCapacity();
            if (this.tank.isEmpty()) {
                this.stack.m_41749_("tank");
            } else {
                this.stack.m_41700_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            }
        }
    }
}

