/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import javax.annotation.Nullable;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.ai.TFCGroundPathNavigation;
import net.dries007.tfc.common.entities.livestock.CommonAnimalData;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.animals.AnimalConfig;
import net.dries007.tfc.config.animals.MammalConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class TFCRabbit
extends Rabbit
implements MammalProperties {
    private static final EntityDataAccessor<Boolean> GENDER = SynchedEntityData.m_135353_(TFCRabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> BIRTHDAY = SynchedEntityData.m_135353_(TFCRabbit.class, EntityHelpers.LONG_SERIALIZER);
    private static final EntityDataAccessor<Float> FAMILIARITY = SynchedEntityData.m_135353_(TFCRabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> USES = SynchedEntityData.m_135353_(TFCRabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FERTILIZED = SynchedEntityData.m_135353_(TFCRabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> OLD_DAY = SynchedEntityData.m_135353_(TFCRabbit.class, EntityHelpers.LONG_SERIALIZER);
    private static final EntityDataAccessor<Integer> GENETIC_SIZE = SynchedEntityData.m_135353_(TFCRabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Long> LAST_FED = SynchedEntityData.m_135353_(TFCRabbit.class, EntityHelpers.LONG_SERIALIZER);
    private static final CommonAnimalData ANIMAL_DATA = new CommonAnimalData(GENDER, BIRTHDAY, FAMILIARITY, USES, FERTILIZED, OLD_DAY, GENETIC_SIZE, LAST_FED);
    private static final EntityDataAccessor<Long> PREGNANT_TIME = SynchedEntityData.m_135353_(TFCRabbit.class, EntityHelpers.LONG_SERIALIZER);
    private long lastFDecay;
    private long matingTime;
    @Nullable
    private CompoundTag genes;
    private TFCAnimalProperties.Age lastAge = TFCAnimalProperties.Age.CHILD;
    private final AnimalConfig config;
    private final MammalConfig mammalConfig;
    private int moreCarrotTicks;

    public static AttributeSupplier.Builder m_29717_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public TFCRabbit(EntityType<? extends Rabbit> type, Level level, MammalConfig config) {
        super(type, level);
        this.config = config.inner();
        this.mammalConfig = config;
        this.matingTime = Calendars.get((LevelReader)level).getTicks();
        this.lastFDecay = Calendars.get((LevelReader)level).getTotalDays();
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.moreCarrotTicks > 0) {
            this.moreCarrotTicks -= this.f_19796_.m_188503_(3);
            if (this.moreCarrotTicks < 0) {
                this.moreCarrotTicks = 0;
            }
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        EntityHelpers.removeGoalOfPriority(this.f_21345_, 3);
        EntityHelpers.removeGoalOfPriority(this.f_21345_, 4);
        EntityHelpers.removeGoalOfPriority(this.f_21345_, 5);
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(this.getFoodTag()), false));
        this.f_21345_.m_25352_(4, new TFCAvoidEntityGoal<PathfinderMob>((PathfinderMob)this, PathfinderMob.class, 8.0f, 2.2, 2.2, TFCTags.Entities.HUNTS_LAND_PREY));
        this.f_21345_.m_25352_(5, (Goal)new RaidGardenGoal(this));
    }

    protected float m_6118_() {
        return 0.42f * this.m_20098_() + this.m_285755_();
    }

    protected void m_6135_() {
        super.m_6135_();
        if (this.m_20184_().f_82479_ == 0.0 || this.m_20184_().f_82481_ == 0.0) {
            Vec3 wanted = new Vec3(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_());
            Vec3 delta = wanted.m_82546_(this.m_20182_()).m_82541_().m_82490_(0.1);
            this.m_20256_(this.m_20184_().m_82549_(delta));
        }
    }

    @Nullable
    public TFCRabbit getBreedOffspring(ServerLevel level, AgeableMob other) {
        TFCRabbit rabbit;
        AgeableMob mob = MammalProperties.super.m_142606_(level, other);
        return mob instanceof TFCRabbit ? (rabbit = (TFCRabbit)mob) : null;
    }

    @Override
    public void createGenes(CompoundTag tag, TFCAnimalProperties male) {
        MammalProperties.super.createGenes(tag, male);
        tag.m_128359_("variant1", this.m_28554_().m_7912_());
        if (male instanceof TFCRabbit) {
            TFCRabbit rabbit = (TFCRabbit)male;
            tag.m_128359_("variant2", rabbit.m_28554_().m_7912_());
        }
    }

    @Override
    public void applyGenes(CompoundTag tag, MammalProperties baby) {
        MammalProperties.super.applyGenes(tag, baby);
        if (baby instanceof TFCRabbit) {
            TFCRabbit rabbit = (TFCRabbit)baby;
            if (tag.m_128425_("variant2", 3) && this.f_19796_.m_188503_(10) != 0) {
                rabbit.m_28464_(Rabbit.Variant.m_262367_((int)(this.f_19796_.m_188499_() ? tag.m_128451_("variant1") : tag.m_128451_("variant2"))));
            } else {
                Level level = this.m_9236_();
                if (level instanceof ServerLevelAccessor) {
                    ServerLevelAccessor server = (ServerLevelAccessor)level;
                    rabbit.m_28464_(this.getRandomRabbitType(server, this.m_20183_()));
                }
            }
        }
    }

    @Override
    public TagKey<Item> getFoodTag() {
        return TFCTags.Items.RABBIT_FOOD;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        TFCRabbit other = (TFCRabbit)otherAnimal;
        return this.getGender() != other.getGender() && this.isReadyToMate() && other.isReadyToMate();
    }

    @Override
    public TFCAnimalProperties.Age getLastAge() {
        return this.lastAge;
    }

    @Override
    public void setLastAge(TFCAnimalProperties.Age lastAge) {
        this.lastAge = lastAge;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, tag);
        if (reason != MobSpawnType.BREEDING) {
            this.initCommonAnimalData(level, difficulty, reason);
            this.m_28464_(this.getRandomRabbitType(level, this.m_20183_()));
        }
        this.setPregnantTime(-1L);
        return spawnData;
    }

    @Override
    public MammalConfig getMammalConfig() {
        return this.mammalConfig;
    }

    @Override
    public long getPregnantTime() {
        return (Long)this.f_19804_.m_135370_(PREGNANT_TIME);
    }

    @Override
    public void setPregnantTime(long day) {
        this.f_19804_.m_135381_(PREGNANT_TIME, (Object)day);
    }

    @Override
    public void setGenes(@Nullable CompoundTag tag) {
        this.genes = tag;
    }

    @Override
    @Nullable
    public CompoundTag getGenes() {
        return this.genes;
    }

    @Override
    public AnimalConfig animalConfig() {
        return this.config;
    }

    @Override
    public CommonAnimalData animalData() {
        return ANIMAL_DATA;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerCommonData();
        this.f_19804_.m_135372_(PREGNANT_TIME, (Object)-1L);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.saveCommonAnimalData(nbt);
        nbt.m_128405_("TFCMoreCarrotTicks", this.moreCarrotTicks);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.readCommonAnimalData(nbt);
        this.moreCarrotTicks = nbt.m_128451_("TFCMoreCarrotTicks");
    }

    public boolean m_6162_() {
        return this.getAgeType() == TFCAnimalProperties.Age.CHILD;
    }

    public void m_146762_(int age) {
        super.m_146762_(0);
    }

    public int m_146764_() {
        return this.m_6162_() ? -24000 : 0;
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (BIRTHDAY.equals(data)) {
            this.m_6210_();
        }
    }

    @Override
    public long getLastFamiliarityDecay() {
        return this.lastFDecay;
    }

    @Override
    public void setLastFamiliarityDecay(long days) {
        this.lastFDecay = days;
    }

    @Override
    public void setMated(long ticks) {
        this.matingTime = ticks;
    }

    @Override
    public long getMated() {
        return this.matingTime;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_46467_() % 20L == 0L) {
            if (!this.getEntity().m_9236_().m_5776_() && this.getGender() == TFCAnimalProperties.Gender.MALE && this.isReadyToMate()) {
                EntityHelpers.findFemaleMate(this);
            }
            this.tickAnimalData();
        }
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return MammalProperties.super.m_6898_(stack);
    }

    public Component m_5677_() {
        return this.getGenderedTypeName();
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos.m_7495_()).m_204336_(TFCTags.Blocks.BUSH_PLANTABLE_ON) ? 10.0f : level.m_220419_(pos);
    }

    public PathNavigation m_6037_(Level level) {
        return new TFCGroundPathNavigation((Mob)this, level);
    }

    public boolean m_5830_() {
        return !this.m_9236_().f_46443_ && super.m_5830_();
    }

    protected void m_6138_() {
        if (!this.m_9236_().f_46443_) {
            super.m_6138_();
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult result = MammalProperties.super.m_6071_(player, hand);
        return result == InteractionResult.PASS ? super.m_6071_(player, hand) : result;
    }

    private Rabbit.Variant getRandomRabbitType(ServerLevelAccessor level, BlockPos pos) {
        int i = this.f_19796_.m_188503_(100);
        ChunkData data = EntityHelpers.getChunkDataForSpawning(level, pos);
        float rain = data.getRainfall(pos);
        float temp = data.getAverageTemp(pos);
        if (temp < 0.0f) {
            return i < 80 ? Rabbit.Variant.WHITE : Rabbit.Variant.WHITE_SPLOTCHED;
        }
        if (rain < 125.0f) {
            return Rabbit.Variant.GOLD;
        }
        return i < 50 ? Rabbit.Variant.BROWN : (i < 90 ? Rabbit.Variant.SALT : Rabbit.Variant.BLACK);
    }

    public boolean m_29724_() {
        return this.moreCarrotTicks == 0;
    }

    public static class RaidGardenGoal
    extends MoveToBlockGoal {
        private final TFCRabbit rabbit;
        private boolean wantsToRaid;
        private boolean canRaid;

        public RaidGardenGoal(TFCRabbit rabbit) {
            super((PathfinderMob)rabbit, (double)0.7f, 16);
            this.rabbit = rabbit;
        }

        public boolean m_8036_() {
            if (this.f_25600_ <= 0) {
                if (!ForgeEventFactory.getMobGriefingEvent((Level)this.rabbit.m_9236_(), (Entity)this.rabbit)) {
                    return false;
                }
                this.canRaid = false;
                this.wantsToRaid = this.rabbit.m_29724_();
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return this.canRaid && super.m_8045_();
        }

        public void m_8037_() {
            super.m_8037_();
            this.rabbit.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.rabbit.m_8132_());
            if (this.m_25625_()) {
                Level level = this.rabbit.m_9236_();
                BlockPos abovePos = this.f_25602_.m_7494_();
                BlockState aboveState = level.m_8055_(abovePos);
                Block aboveBlock = aboveState.m_60734_();
                if (this.canRaid && Helpers.isBlock(aboveBlock, TFCTags.Blocks.RABBIT_RAIDABLE)) {
                    level.m_7731_(abovePos, Blocks.f_50016_.m_49966_(), 2);
                    level.m_46953_(abovePos, true, (Entity)this.rabbit);
                    this.rabbit.moreCarrotTicks = 40;
                }
                this.canRaid = false;
                this.f_25600_ = 10;
            }
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            if (Helpers.isBlock(state, TFCTags.Blocks.FARMLAND) && this.wantsToRaid && !this.canRaid && Helpers.isBlock(state = level.m_8055_(pos.m_7494_()), TFCTags.Blocks.RABBIT_RAIDABLE)) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }
}

