/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.horse;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.common.entities.ai.TFCGroundPathNavigation;
import net.dries007.tfc.common.entities.livestock.CommonAnimalData;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.horse.HorseProperties;
import net.dries007.tfc.common.entities.livestock.horse.TFCChestedHorse;
import net.dries007.tfc.common.entities.livestock.horse.TFCDonkey;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.animals.AnimalConfig;
import net.dries007.tfc.config.animals.MammalConfig;
import net.dries007.tfc.mixin.accessor.HorseAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class TFCHorse
extends Horse
implements HorseProperties {
    private static final EntityDataAccessor<Boolean> GENDER = SynchedEntityData.m_135353_(TFCHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> BIRTHDAY = SynchedEntityData.m_135353_(TFCHorse.class, EntityHelpers.LONG_SERIALIZER);
    private static final EntityDataAccessor<Float> FAMILIARITY = SynchedEntityData.m_135353_(TFCHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> USES = SynchedEntityData.m_135353_(TFCHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FERTILIZED = SynchedEntityData.m_135353_(TFCHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> OLD_DAY = SynchedEntityData.m_135353_(TFCHorse.class, EntityHelpers.LONG_SERIALIZER);
    private static final EntityDataAccessor<Integer> GENETIC_SIZE = SynchedEntityData.m_135353_(TFCHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Long> LAST_FED = SynchedEntityData.m_135353_(TFCHorse.class, EntityHelpers.LONG_SERIALIZER);
    private static final CommonAnimalData ANIMAL_DATA = new CommonAnimalData(GENDER, BIRTHDAY, FAMILIARITY, USES, FERTILIZED, OLD_DAY, GENETIC_SIZE, LAST_FED);
    private static final EntityDataAccessor<Long> PREGNANT_TIME = SynchedEntityData.m_135353_(TFCHorse.class, EntityHelpers.LONG_SERIALIZER);
    private long lastFDecay;
    private long matingTime;
    @Nullable
    private CompoundTag genes;
    private TFCAnimalProperties.Age lastAge = TFCAnimalProperties.Age.CHILD;
    private final Supplier<? extends SoundEvent> ambient;
    private final Supplier<? extends SoundEvent> hurt;
    private final Supplier<? extends SoundEvent> death;
    private final Supplier<? extends SoundEvent> step;
    private final Supplier<? extends SoundEvent> eat;
    private final Supplier<? extends SoundEvent> angry;
    private final AnimalConfig config;
    private final MammalConfig mammalConfig;

    public TFCHorse(EntityType<? extends TFCHorse> type, Level level) {
        this(type, level, TFCSounds.HORSE, () -> SoundEvents.f_11976_, () -> SoundEvents.f_11972_, TFCConfig.SERVER.horseConfig);
    }

    public TFCHorse(EntityType<? extends TFCHorse> type, Level level, TFCSounds.EntitySound sounds, Supplier<? extends SoundEvent> eatSound, Supplier<? extends SoundEvent> angrySound, MammalConfig config) {
        super(type, level);
        this.matingTime = Calendars.get((LevelReader)level).getTicks();
        this.lastFDecay = Calendars.get((LevelReader)level).getTotalDays();
        this.ambient = sounds.ambient();
        this.hurt = sounds.hurt();
        this.death = sounds.death();
        this.step = sounds.step();
        this.eat = eatSound;
        this.angry = angrySound;
        this.config = config.inner();
        this.mammalConfig = config;
    }

    public double m_6048_() {
        return super.m_6048_() * (double)this.getAgeScale();
    }

    @Override
    public void createGenes(CompoundTag tag, TFCAnimalProperties maleProperties) {
        HorseProperties.super.createGenes(tag, maleProperties);
        AbstractHorse male = (AbstractHorse)maleProperties;
        boolean isMule = maleProperties instanceof TFCDonkey;
        tag.m_128379_("isMule", isMule);
        if (!isMule && male instanceof TFCHorse) {
            TFCHorse maleHorse = (TFCHorse)male;
            tag.m_128405_("markings1", maleHorse.m_30724_().m_30869_());
            tag.m_128405_("markings2", this.m_30724_().m_30869_());
            tag.m_128405_("variant1", maleHorse.m_28554_().m_30985_());
            tag.m_128405_("variant2", this.m_28554_().m_30985_());
        }
    }

    @Override
    public void applyGenes(CompoundTag tag, MammalProperties babyProperties) {
        HorseProperties.super.applyGenes(tag, babyProperties);
        if (babyProperties instanceof TFCHorse) {
            TFCHorse baby = (TFCHorse)babyProperties;
            if (tag.m_128441_("markings1")) {
                int i = this.f_19796_.m_188503_(9);
                Variant variant = i < 4 ? Variant.m_30986_((int)tag.m_128451_("variant1")) : (i < 8 ? Variant.m_30986_((int)tag.m_128451_("variant2")) : (Variant)Util.m_214670_((Object[])Variant.values(), (RandomSource)this.f_19796_));
                int j = this.f_19796_.m_188503_(5);
                Markings markings = j < 2 ? Markings.m_30870_((int)tag.m_128451_("markings1")) : (j < 4 ? Markings.m_30870_((int)tag.m_128451_("markings2")) : (Markings)Util.m_214670_((Object[])Markings.values(), (RandomSource)this.f_19796_));
                ((HorseAccessor)((Object)baby)).invoke$setVariantAndTypeMarkings(variant, markings);
            }
        }
    }

    @Override
    public TagKey<Item> getFoodTag() {
        return TFCTags.Items.HORSE_FOOD;
    }

    protected void m_8099_() {
        super.m_8099_();
        EntityHelpers.removeGoalOfPriority(this.f_21345_, 3);
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(this.getFoodTag()), false));
        this.f_21345_.m_25352_(5, new TFCAvoidEntityGoal<PathfinderMob>((PathfinderMob)this, PathfinderMob.class, 8.0f, 1.6f, 1.4f, TFCTags.Entities.HUNTS_LAND_PREY));
    }

    @Override
    public EntityType<?> getEntityTypeForBaby() {
        CompoundTag genes = this.getGenes();
        return genes != null && genes.m_128441_("isMule") && genes.m_128471_("isMule") ? (EntityType)TFCEntities.MULE.get() : (EntityType)TFCEntities.HORSE.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7848_(Animal otherAnimal) {
        if (!(otherAnimal instanceof TFCAnimalProperties)) return false;
        TFCAnimalProperties other = (TFCAnimalProperties)otherAnimal;
        if (this.getGender() == other.getGender()) return false;
        if (!this.isReadyToMate()) return false;
        if (!other.isReadyToMate()) return false;
        if (!this.checkExtraBreedConditions(other)) return false;
        return true;
    }

    @Override
    public boolean checkExtraBreedConditions(TFCAnimalProperties otherAnimal) {
        if (HorseProperties.super.checkExtraBreedConditions(otherAnimal) && (otherAnimal instanceof TFCDonkey || otherAnimal instanceof Horse)) {
            AbstractHorse otherHorse = (AbstractHorse)otherAnimal;
            return TFCChestedHorse.vanillaParentingCheck((AbstractHorse)this) && TFCChestedHorse.vanillaParentingCheck(otherHorse);
        }
        return false;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult result = HorseProperties.super.m_6071_(player, hand);
        if (result == InteractionResult.PASS) {
            ItemStack stack = player.m_21120_(hand);
            if (!this.m_6162_()) {
                if (this.m_30614_() && player.m_36341_()) {
                    this.m_213583_(player);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                if (this.m_20160_()) {
                    return InteractionResult.PASS;
                }
            }
            if (!stack.m_41619_()) {
                boolean canBeSaddled;
                InteractionResult res = stack.m_41647_(player, (LivingEntity)this, hand);
                if (res.m_19077_()) {
                    return res;
                }
                if (!this.m_30614_()) {
                    this.m_7564_();
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                boolean bl = canBeSaddled = !this.m_6162_() && !this.m_6254_() && stack.m_150930_(Items.f_42450_);
                if (this.m_6010_(stack) || canBeSaddled) {
                    this.m_213583_(player);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            }
            if (this.m_6162_()) {
                return InteractionResult.PASS;
            }
            if (this.m_30614_() && this.m_21805_() == null) {
                this.m_30637_(player);
            }
            this.m_6835_(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return result;
    }

    public boolean m_30614_() {
        return this.getFamiliarity() > 0.15f;
    }

    protected SoundEvent m_7872_() {
        super.m_7872_();
        return this.eat.get();
    }

    protected SoundEvent m_7871_() {
        super.m_7871_();
        return this.angry.get();
    }

    protected float m_6041_() {
        return Helpers.isBlock(this.m_9236_().m_8055_(this.m_20183_()), TFCTags.Blocks.PLANTS) ? 1.0f : super.m_6041_();
    }

    @Override
    public TFCAnimalProperties.Age getLastAge() {
        return this.lastAge;
    }

    @Override
    public void setLastAge(TFCAnimalProperties.Age lastAge) {
        this.lastAge = lastAge;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, tag);
        if (reason != MobSpawnType.BREEDING) {
            this.initCommonAnimalData(level, difficulty, reason);
        }
        this.setPregnantTime(-1L);
        return spawnData;
    }

    @Override
    public MammalConfig getMammalConfig() {
        return this.mammalConfig;
    }

    @Override
    public long getPregnantTime() {
        return (Long)this.f_19804_.m_135370_(PREGNANT_TIME);
    }

    @Override
    public void setPregnantTime(long day) {
        this.f_19804_.m_135381_(PREGNANT_TIME, (Object)day);
    }

    @Override
    public void setGenes(@Nullable CompoundTag tag) {
        this.genes = tag;
    }

    @Override
    @Nullable
    public CompoundTag getGenes() {
        return this.genes;
    }

    @Override
    public AnimalConfig animalConfig() {
        return this.config;
    }

    @Override
    public CommonAnimalData animalData() {
        return ANIMAL_DATA;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerCommonData();
        this.f_19804_.m_135372_(PREGNANT_TIME, (Object)-1L);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.saveCommonAnimalData(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.readCommonAnimalData(nbt);
    }

    public boolean m_6162_() {
        return this.getAgeType() == TFCAnimalProperties.Age.CHILD;
    }

    public void m_146762_(int age) {
        super.m_146762_(0);
    }

    public int m_146764_() {
        return this.m_6162_() ? -24000 : 0;
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob other) {
        return HorseProperties.super.m_142606_(level, other);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (BIRTHDAY.equals(data)) {
            this.m_6210_();
        }
    }

    @Override
    public long getLastFamiliarityDecay() {
        return this.lastFDecay;
    }

    @Override
    public void setLastFamiliarityDecay(long days) {
        this.lastFDecay = days;
    }

    @Override
    public void setMated(long ticks) {
        this.matingTime = ticks;
    }

    @Override
    public long getMated() {
        return this.matingTime;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_46467_() % 20L == 0L) {
            this.tickAnimalData();
        }
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return HorseProperties.super.m_6898_(stack);
    }

    public Component m_5677_() {
        return this.getGenderedTypeName();
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return this.ambient.get();
    }

    protected SoundEvent m_7975_(DamageSource src) {
        super.m_7975_(src);
        return this.hurt.get();
    }

    protected SoundEvent m_5592_() {
        super.m_5592_();
        return this.death.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        super.m_7355_(pos, block);
        this.m_5496_(this.step.get(), 0.15f, 1.0f);
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos.m_7495_()).m_204336_(TFCTags.Blocks.BUSH_PLANTABLE_ON) ? 10.0f : level.m_220419_(pos);
    }

    public PathNavigation m_6037_(Level level) {
        return new TFCGroundPathNavigation((Mob)this, level);
    }

    public boolean m_5830_() {
        return !this.m_9236_().f_46443_ && super.m_5830_();
    }

    protected void m_6138_() {
        if (!this.m_9236_().f_46443_) {
            super.m_6138_();
        }
    }
}

