/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.Temptable;
import net.dries007.tfc.common.entities.ai.TFCGroundPathNavigation;
import net.dries007.tfc.common.entities.ai.livestock.LivestockAi;
import net.dries007.tfc.common.entities.ai.prey.PreyAi;
import net.dries007.tfc.common.entities.livestock.CommonAnimalData;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.animals.AnimalConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TFCAnimal
extends Animal
implements TFCAnimalProperties,
Temptable {
    private static final EntityDataAccessor<Boolean> GENDER = SynchedEntityData.m_135353_(TFCAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> BIRTHDAY = SynchedEntityData.m_135353_(TFCAnimal.class, EntityHelpers.LONG_SERIALIZER);
    private static final EntityDataAccessor<Float> FAMILIARITY = SynchedEntityData.m_135353_(TFCAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> USES = SynchedEntityData.m_135353_(TFCAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FERTILIZED = SynchedEntityData.m_135353_(TFCAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Long> OLD_DAY = SynchedEntityData.m_135353_(TFCAnimal.class, EntityHelpers.LONG_SERIALIZER);
    private static final EntityDataAccessor<Integer> GENETIC_SIZE = SynchedEntityData.m_135353_(TFCAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Long> LAST_FED = SynchedEntityData.m_135353_(TFCAnimal.class, EntityHelpers.LONG_SERIALIZER);
    private static final CommonAnimalData ANIMAL_DATA = new CommonAnimalData(GENDER, BIRTHDAY, FAMILIARITY, USES, FERTILIZED, OLD_DAY, GENETIC_SIZE, LAST_FED);
    private TFCAnimalProperties.Age lastAge = TFCAnimalProperties.Age.CHILD;
    private long lastFDecay;
    private long matingTime;
    private final Supplier<? extends SoundEvent> ambient;
    private final Supplier<? extends SoundEvent> hurt;
    private final Supplier<? extends SoundEvent> death;
    private final Supplier<? extends SoundEvent> step;
    private final AnimalConfig config;

    public TFCAnimal(EntityType<? extends Animal> type, Level level, TFCSounds.EntitySound sounds, AnimalConfig config) {
        super(type, level);
        this.m_21573_().m_7008_(true);
        this.m_274367_(1.0f);
        this.matingTime = Calendars.get((LevelReader)level).getTicks();
        this.lastFDecay = Calendars.get((LevelReader)level).getTotalDays();
        this.ambient = sounds.ambient();
        this.hurt = sounds.hurt();
        this.death = sounds.death();
        this.step = sounds.step();
        this.config = config;
    }

    protected Brain.Provider<? extends TFCAnimal> m_5490_() {
        return Brain.m_21923_(LivestockAi.MEMORY_TYPES, LivestockAi.SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return LivestockAi.makeBrain((Brain<? extends TFCAnimal>)this.m_5490_().m_22073_(dynamic));
    }

    public boolean m_6469_(DamageSource src, float amount) {
        Entity entity;
        boolean hurt = super.m_6469_(src, amount);
        if (this.m_9236_().f_46443_) {
            return hurt;
        }
        if (hurt && (entity = src.m_7639_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PreyAi.wasHurtBy((LivingEntity)this, living);
        }
        return hurt;
    }

    public Brain<? extends TFCAnimal> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        super.m_8024_();
        this.tickBrain();
    }

    public void tickBrain() {
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        LivestockAi.updateActivity(this);
    }

    @Override
    public CommonAnimalData animalData() {
        return ANIMAL_DATA;
    }

    @Override
    public AnimalConfig animalConfig() {
        return this.config;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerCommonData();
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.saveCommonAnimalData(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.readCommonAnimalData(nbt);
    }

    public boolean m_6162_() {
        return this.getAgeType() == TFCAnimalProperties.Age.CHILD;
    }

    public void m_146762_(int age) {
        super.m_146762_(0);
    }

    public int m_146764_() {
        return this.m_6162_() ? -24000 : 0;
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob other) {
        return TFCAnimalProperties.super.m_142606_(level, other);
    }

    @Override
    public TFCAnimalProperties.Age getLastAge() {
        return this.lastAge;
    }

    @Override
    public void setLastAge(TFCAnimalProperties.Age lastAge) {
        this.lastAge = lastAge;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        if (reason != MobSpawnType.BREEDING) {
            this.initCommonAnimalData(level, difficulty, reason);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, tag);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (BIRTHDAY.equals(data)) {
            this.m_6210_();
        }
    }

    @Override
    public long getLastFamiliarityDecay() {
        return this.lastFDecay;
    }

    @Override
    public void setLastFamiliarityDecay(long days) {
        this.lastFDecay = days;
    }

    @Override
    public void setMated(long ticks) {
        this.matingTime = ticks;
    }

    @Override
    public long getMated() {
        return this.matingTime;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_46467_() % 20L == 0L) {
            this.tickAnimalData();
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult result = TFCAnimalProperties.super.m_6071_(player, hand);
        return result == InteractionResult.PASS ? super.m_6071_(player, hand) : result;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal.getClass() != this.getClass()) {
            return false;
        }
        TFCAnimal other = (TFCAnimal)otherAnimal;
        return this.getGender() != other.getGender() && this.isReadyToMate() && other.isReadyToMate();
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return TFCAnimalProperties.super.m_6898_(stack);
    }

    public Component m_5677_() {
        return this.getGenderedTypeName();
    }

    protected SoundEvent m_7515_() {
        return this.ambient.get();
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return this.hurt.get();
    }

    protected SoundEvent m_5592_() {
        return this.death.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(this.step.get(), 0.15f, 1.0f);
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return Helpers.isBlock(level.m_8055_(pos.m_7495_()), TFCTags.Blocks.BUSH_PLANTABLE_ON) ? 10.0f : level.m_220419_(pos);
    }

    public PathNavigation m_6037_(Level level) {
        return new TFCGroundPathNavigation((Mob)this, level);
    }

    public boolean m_5830_() {
        return !this.m_9236_().f_46443_ && super.m_5830_();
    }

    protected void m_6138_() {
        if (!this.m_9236_().f_46443_) {
            super.m_6138_();
        }
    }
}

