/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.dries007.tfc.common.TFCEffects;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.aquatic.AquaticMob;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TFCSquid
extends Squid
implements AquaticMob {
    public static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(TFCSquid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int MAX_SIZE = 127;
    public static final int MIN_SIZE = 1;

    public TFCSquid(EntityType<? extends Squid> type, Level level) {
        super(type, level);
    }

    @Override
    public boolean canSpawnIn(Fluid fluid) {
        return Helpers.isFluid(fluid, TFCTags.Fluids.ANY_INFINITE_WATER);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RandomMovementGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FleeGoal(this));
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)1);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("size", this.getSize() - 1);
    }

    public void m_7378_(CompoundTag tag) {
        this.setSize(tag.m_128451_("size") + 1, false);
        super.m_7378_(tag);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (ID_SIZE.equals(data)) {
            this.m_6210_();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            LivingEntity livingEntity;
            if (!this.m_9236_().f_46443_ && (livingEntity = this.m_21188_()) instanceof Player) {
                Player player = (Player)livingEntity;
                if (this.f_19796_.m_188503_(3) == 0 && player.m_20280_((Entity)this) < 64.0) {
                    player.m_7292_(new MobEffectInstance(this.getInkEffect(), 100));
                }
            }
            return true;
        }
        return false;
    }

    public MobEffect getInkEffect() {
        return (MobEffect)TFCEffects.INK.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData spawn = super.m_6518_(level, difficulty, spawnType, data, tag);
        Pair<Integer, Integer> pair = this.getSizeRangeForSpawning();
        this.setSize(Mth.m_216271_((RandomSource)this.f_19796_, (int)((Integer)pair.getFirst()), (int)((Integer)pair.getSecond())), true);
        if (spawnType == MobSpawnType.NATURAL || spawnType == MobSpawnType.CHUNK_GENERATION) {
            while (level.m_186437_((Entity)this, this.m_20191_())) {
                this.setSize((int)((double)this.getSize() * 0.8), true);
                if (this.getSize() >= (Integer)pair.getFirst()) continue;
                this.m_146870_();
                return spawn;
            }
        }
        return spawn;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(this.getVisualScale());
    }

    public float getVisualScale() {
        return 0.05f * (float)this.getSize();
    }

    public Pair<Integer, Integer> getSizeRangeForSpawning() {
        return Pair.of((Object)22, (Object)65);
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    public void setSize(int size, boolean heal) {
        size = Mth.m_14045_((int)size, (int)1, (int)127);
        this.m_20090_();
        this.m_6210_();
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((double)size);
        if (heal) {
            this.m_21153_(this.m_21233_());
        }
        this.f_19804_.m_135381_(ID_SIZE, (Object)size);
    }

    public static class RandomMovementGoal
    extends Goal {
        private final TFCSquid squid;

        public RandomMovementGoal(TFCSquid squid) {
            this.squid = squid;
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            int ticks = this.squid.m_21216_();
            if (ticks > 100) {
                this.squid.m_29958_(0.0f, 0.0f, 0.0f);
            } else if (this.squid.m_217043_().m_188503_(RandomMovementGoal.m_186073_((int)50)) == 0 || !this.squid.f_19798_ || !this.squid.m_29981_()) {
                float f = this.squid.m_217043_().m_188501_() * ((float)Math.PI * 2);
                float f1 = Mth.m_14089_((float)f) * 0.2f;
                float f2 = -0.1f + this.squid.m_217043_().m_188501_() * 0.2f;
                float f3 = Mth.m_14031_((float)f) * 0.2f;
                this.squid.m_29958_(f1, f2, f3);
            }
        }
    }

    public static class FleeGoal
    extends Goal {
        private static final float SQUID_FLEE_SPEED = 3.0f;
        private static final float SQUID_FLEE_MIN_DISTANCE = 5.0f;
        private static final float SQUID_FLEE_MAX_DISTANCE = 10.0f;
        private int fleeTicks;
        private final TFCSquid squid;

        public FleeGoal(TFCSquid squid) {
            this.squid = squid;
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.squid.m_21188_();
            if (this.squid.m_20069_() && livingentity != null) {
                return this.squid.m_20280_((Entity)livingentity) < 100.0;
            }
            return false;
        }

        public void m_8056_() {
            this.fleeTicks = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            ++this.fleeTicks;
            LivingEntity livingentity = this.squid.m_21188_();
            if (livingentity != null) {
                Vec3 vec3 = new Vec3(this.squid.m_20185_() - livingentity.m_20185_(), this.squid.m_20186_() - livingentity.m_20186_(), this.squid.m_20189_() - livingentity.m_20189_());
                BlockState blockstate = this.squid.m_9236_().m_8055_(BlockPos.m_274561_((double)(this.squid.m_20185_() + vec3.f_82479_), (double)(this.squid.m_20186_() + vec3.f_82480_), (double)(this.squid.m_20189_() + vec3.f_82481_)));
                FluidState fluidstate = this.squid.m_9236_().m_6425_(BlockPos.m_274561_((double)(this.squid.m_20185_() + vec3.f_82479_), (double)(this.squid.m_20186_() + vec3.f_82480_), (double)(this.squid.m_20189_() + vec3.f_82481_)));
                if (fluidstate.m_205070_(TFCTags.Fluids.ANY_WATER) || blockstate.m_60795_()) {
                    double d0 = vec3.m_82553_();
                    if (d0 > 0.0) {
                        vec3.m_82541_();
                        double d1 = 3.0;
                        if (d0 > 5.0) {
                            d1 -= (d0 - 5.0) / 5.0;
                        }
                        if (d1 > 0.0) {
                            vec3 = vec3.m_82490_(d1);
                        }
                    }
                    if (blockstate.m_60795_()) {
                        vec3 = vec3.m_82492_(0.0, vec3.f_82480_, 0.0);
                    }
                    this.squid.m_29958_((float)vec3.f_82479_ / 20.0f, (float)vec3.f_82480_ / 20.0f, (float)vec3.f_82481_ / 20.0f);
                }
                if (this.fleeTicks % 10 == 5) {
                    this.squid.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.squid.m_20185_(), this.squid.m_20186_(), this.squid.m_20189_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

