/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.dries007.tfc.common.entities.prey.RammingPrey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PrepareRamNearestTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class PrepareRamNearestTargetTFC<E extends PathfinderMob>
extends Behavior<E> {
    public static final int TIME_OUT_DURATION = 160;
    private final ToIntFunction<E> getCooldownOnFail;
    private final int minRamDistance;
    private final int maxRamDistance;
    private final float walkSpeed;
    private final TargetingConditions ramTargeting;
    private final int ramPrepareTime;
    private final Function<E, SoundEvent> getPrepareRamSound;
    private Optional<Long> reachedRamPositionTimestamp = Optional.empty();
    private Optional<PrepareRamNearestTarget.RamCandidate> ramCandidate = Optional.empty();

    public PrepareRamNearestTargetTFC(ToIntFunction<E> coolDownOnFail, int minRamDistance, int maxRamDistance, float walkSpeed, TargetingConditions ramTargeting, int ramPrepareTime, Function<E, SoundEvent> prepareRamSound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_148202_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148203_, (Object)MemoryStatus.VALUE_ABSENT), 160);
        this.getCooldownOnFail = coolDownOnFail;
        this.minRamDistance = minRamDistance;
        this.maxRamDistance = maxRamDistance;
        this.walkSpeed = walkSpeed;
        this.ramTargeting = ramTargeting;
        this.ramPrepareTime = ramPrepareTime;
        this.getPrepareRamSound = prepareRamSound;
    }

    protected void start(ServerLevel level, PathfinderMob rammingPrey, long time) {
        Brain brain = rammingPrey.m_6274_();
        brain.m_21952_(MemoryModuleType.f_148205_).flatMap(nearestVisibleLivingEntities -> nearestVisibleLivingEntities.m_186116_(nearestVisisbleEntity -> this.ramTargeting.m_26885_((LivingEntity)rammingPrey, nearestVisisbleEntity))).ifPresent(target -> this.chooseRamPosition(rammingPrey, (LivingEntity)target));
    }

    protected void stop(ServerLevel level, E rammingPrey, long time) {
        Brain brain = rammingPrey.m_6274_();
        if (!brain.m_21874_(MemoryModuleType.f_148203_)) {
            level.m_7605_(rammingPrey, (byte)59);
            brain.m_21879_(MemoryModuleType.f_148202_, (Object)this.getCooldownOnFail.applyAsInt(rammingPrey));
        }
    }

    protected boolean canStillUse(ServerLevel level, PathfinderMob rammingPrey, long time) {
        return this.ramCandidate.isPresent() && this.ramCandidate.get().m_147799_().m_6084_();
    }

    protected void tick(ServerLevel level, E rammingPrey, long time) {
        if (!this.ramCandidate.isEmpty()) {
            boolean flag;
            rammingPrey.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.ramCandidate.get().m_147797_(), this.walkSpeed, 0));
            rammingPrey.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)this.ramCandidate.get().m_147799_(), true));
            boolean bl = flag = !this.ramCandidate.get().m_147799_().m_20183_().equals((Object)this.ramCandidate.get().m_147798_());
            if (flag) {
                if (PredatorAi.hasNearbyAttacker(rammingPrey)) {
                    level.m_7605_(rammingPrey, (byte)58);
                } else {
                    level.m_7605_(rammingPrey, (byte)59);
                }
                rammingPrey.m_21573_().m_26573_();
                this.chooseRamPosition((PathfinderMob)rammingPrey, this.ramCandidate.get().m_147799_());
            } else {
                BlockPos blockpos = rammingPrey.m_20183_();
                if (blockpos.equals((Object)this.ramCandidate.get().m_147797_())) {
                    level.m_7605_(rammingPrey, (byte)58);
                    if (this.reachedRamPositionTimestamp.isEmpty()) {
                        this.reachedRamPositionTimestamp = Optional.of(time);
                    }
                    if (time - this.reachedRamPositionTimestamp.get() >= (long)this.ramPrepareTime) {
                        if (rammingPrey instanceof RammingPrey) {
                            ((RammingPrey)rammingPrey).setAttackDamageMultiplier(this.calcRamDamageMultiplier(blockpos, this.ramCandidate.get().m_147798_()));
                        }
                        rammingPrey.m_6274_().m_21879_(MemoryModuleType.f_148203_, (Object)this.getEdgeOfBlock(blockpos, this.ramCandidate.get().m_147798_()));
                        level.m_6269_((Player)null, rammingPrey, this.getPrepareRamSound.apply(rammingPrey), SoundSource.NEUTRAL, 1.0f, rammingPrey.m_6100_());
                        this.ramCandidate = Optional.empty();
                        this.reachedRamPositionTimestamp = Optional.empty();
                    }
                }
            }
        }
    }

    private float calcRamDamageMultiplier(BlockPos startPos, BlockPos finishPos) {
        float dist = (float)startPos.m_123331_((Vec3i)finishPos);
        int maxRamDistance = 9;
        return Mth.m_14036_((float)(1.2f * dist / 9.0f), (float)0.25f, (float)2.0f);
    }

    private Vec3 getEdgeOfBlock(BlockPos pos1, BlockPos pos2) {
        double d0 = 0.5;
        double d1 = 0.5 * (double)Mth.m_14205_((double)(pos2.m_123341_() - pos1.m_123341_()));
        double d2 = 0.5 * (double)Mth.m_14205_((double)(pos2.m_123343_() - pos1.m_123343_()));
        return Vec3.m_82539_((Vec3i)pos2).m_82520_(d1, 0.0, d2);
    }

    private Optional<BlockPos> calculateRammingStartPosition(PathfinderMob rammingPrey, LivingEntity target) {
        BlockPos blockpos = target.m_20183_();
        if (!this.isWalkableBlock(rammingPrey, blockpos)) {
            return Optional.empty();
        }
        ArrayList list = Lists.newArrayList();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockpos.m_122032_();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            blockpos$mutableblockpos.m_122190_((Vec3i)blockpos);
            for (int i = 0; i < this.maxRamDistance; ++i) {
                if (this.isWalkableBlock(rammingPrey, (BlockPos)blockpos$mutableblockpos.m_122173_(direction))) continue;
                blockpos$mutableblockpos.m_122173_(direction.m_122424_());
                break;
            }
            if (blockpos$mutableblockpos.m_123333_((Vec3i)blockpos) < this.minRamDistance) continue;
            list.add(blockpos$mutableblockpos.m_7949_());
        }
        PathNavigation pathnavigation = rammingPrey.m_21573_();
        return list.stream().sorted(Comparator.comparingDouble(arg_0 -> ((BlockPos)rammingPrey.m_20183_()).m_123331_(arg_0))).filter(blockPos -> {
            Path path = pathnavigation.m_7864_(blockPos, 0);
            return path != null && path.m_77403_();
        }).findFirst();
    }

    private boolean isWalkableBlock(PathfinderMob rammingPrey, BlockPos pos) {
        return rammingPrey.m_21573_().m_6342_(pos) && rammingPrey.m_21439_(WalkNodeEvaluator.m_77604_((BlockGetter)rammingPrey.m_9236_(), (BlockPos.MutableBlockPos)pos.m_122032_())) == 0.0f;
    }

    private void chooseRamPosition(PathfinderMob rammingPrey, LivingEntity target) {
        this.ramCandidate = this.calculateRammingStartPosition(rammingPrey, target).map(blockPos -> {
            if (PredatorAi.hasNearbyAttacker((LivingEntity)rammingPrey)) {
                return new PrepareRamNearestTarget.RamCandidate(rammingPrey.m_20183_(), target.m_20183_(), target);
            }
            this.reachedRamPositionTimestamp = Optional.empty();
            return new PrepareRamNearestTarget.RamCandidate(blockPos, target.m_20183_(), target);
        });
    }
}

