/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.dries007.tfc.common.entities.ai.TFCBrain;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.dries007.tfc.common.entities.ai.predator.PackPredatorAi;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.dries007.tfc.common.entities.predator.Predator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.phys.Vec3;

public final class PredatorBehaviors {
    public static OneShot<Predator> becomePassiveIf(Predicate<Predator> predicate, int ticks) {
        return BehaviorBuilder.m_257845_(predicate, (OneShot)BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257492_(MemoryModuleType.f_26372_), (App)instance.m_258080_(MemoryModuleType.f_26357_)).apply((Applicative)instance, (attackMemory, passiveMemory) -> (level, predator, time) -> {
            attackMemory.m_257971_();
            passiveMemory.m_257465_((Object)true, (long)ticks);
            return true;
        })));
    }

    public static BehaviorControl<Mob> stopAttackingIfTooFarFromHome() {
        return PredatorBehaviors.stopAttackingIf((predator, target) -> PredatorAi.getDistanceFromHomeSqr((LivingEntity)predator) > 6400.0, (predator, target) -> {
            if (target.m_21224_()) {
                Brain brain = predator.m_6274_();
                brain.m_21882_(MemoryModuleType.f_26340_, (Object)true, 12000L);
                if (brain.m_21874_(MemoryModuleType.f_26382_)) {
                    brain.m_21936_(MemoryModuleType.f_26382_);
                }
            }
        });
    }

    public static <E extends Mob> BehaviorControl<E> stopAttackingIf(BiPredicate<E, LivingEntity> canStopAttacking, BiConsumer<Mob, LivingEntity> onStopAttacking) {
        return BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257495_(MemoryModuleType.f_26372_), (App)instance.m_257492_(MemoryModuleType.f_26326_)).apply((Applicative)instance, (attackTarget, cantReachWalkTargetSince) -> (level, attackerMob, gameTime) -> {
            LivingEntity attackedMob = (LivingEntity)instance.m_258051_(attackTarget);
            if (!attackerMob.m_6779_(attackedMob) || PredatorBehaviors.isTiredOfTryingToReachTarget(attackerMob, instance.m_257828_(cantReachWalkTargetSince)) || !attackedMob.m_6084_() || attackedMob.m_9236_() != attackerMob.m_9236_() || canStopAttacking.test(attackerMob, attackedMob)) {
                onStopAttacking.accept((Mob)attackerMob, attackedMob);
                attackTarget.m_257971_();
            }
            return true;
        }));
    }

    public static OneShot<Predator> startSleeping() {
        return BehaviorBuilder.m_257845_(entity -> PredatorAi.getDistanceFromHomeSqr((LivingEntity)entity) < 25.0 && !entity.m_5803_() && !entity.m_20072_(), (OneShot)BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_258080_(MemoryModuleType.f_26372_), (App)instance.m_258080_((MemoryModuleType)TFCBrain.WAKEUP_TICKS.get()), (App)instance.m_257492_(MemoryModuleType.f_26370_), (App)instance.m_257492_(MemoryModuleType.f_26371_)).apply((Applicative)instance, (attack, tick, walk, look) -> (level, predator, time) -> {
            walk.m_257971_();
            look.m_257971_();
            predator.setSleeping(true);
            return true;
        })));
    }

    public static OneShot<Predator> tickScheduleAndWake() {
        return BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_258080_(MemoryModuleType.f_26372_)).apply((Applicative)instance, attack -> (level, predator, time) -> {
            Optional before = predator.m_6274_().m_21968_();
            predator.m_6274_().m_21862_(level.m_46468_(), level.m_46467_());
            Optional after = predator.m_6274_().m_21968_();
            if (before.isPresent() && after.isPresent() && before.get() == Activity.f_37982_ && after.get() != Activity.f_37982_) {
                predator.setSleeping(false);
                return true;
            }
            return false;
        }));
    }

    public static OneShot<Predator> wakeFromDisturbance() {
        return BehaviorBuilder.m_257845_(entity -> (PredatorAi.getDistanceFromHomeSqr((LivingEntity)entity) > 25.0 || entity.m_20072_() || !entity.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)entity, entity.m_20191_()).isEmpty()) && entity.m_5803_(), (OneShot)BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_258080_(MemoryModuleType.f_26372_)).apply((Applicative)instance, attack -> (level, predator, time) -> {
            predator.setSleeping(false);
            predator.m_6274_().m_21879_((MemoryModuleType)TFCBrain.WAKEUP_TICKS.get(), (Object)100);
            return true;
        })));
    }

    public static OneShot<Predator> findNewHome() {
        return BehaviorBuilder.m_257845_(predator -> PredatorAi.getDistanceFromHomeSqr((LivingEntity)predator) > 10000.0 || PredatorAi.getDistanceFromHomeSqr((LivingEntity)predator) < 9.0 && predator.m_20072_(), (OneShot)BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257495_(MemoryModuleType.f_26359_), (App)instance.m_257492_(MemoryModuleType.f_26370_)).apply((Applicative)instance, (homeMemory, walkMemory) -> (level, predator, time) -> {
            Vec3 found = LandRandomPos.m_148488_((PathfinderMob)predator, (int)10, (int)5);
            if (found != null) {
                homeMemory.m_257512_((Object)GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)BlockPos.m_274446_((Position)found)));
                walkMemory.m_257512_((Object)new WalkTarget(found, 1.0f, 16));
                return true;
            }
            return false;
        })));
    }

    public static OneShot<Predator> listenToAlpha() {
        return BehaviorBuilder.m_257845_(PackPredatorAi::isNotAlpha, (OneShot)BehaviorBuilder.m_258034_(instance -> instance.group((App)instance.m_257492_(MemoryModuleType.f_26370_), (App)instance.m_257492_(MemoryModuleType.f_26359_), (App)instance.m_258080_(MemoryModuleType.f_26372_)).apply((Applicative)instance, (walk, home, attackTarget) -> (level, predator, time) -> {
            PackPredator alpha = PackPredatorAi.getAlpha(predator);
            Brain alphaBrain = alpha.m_6274_();
            alphaBrain.m_21952_(MemoryModuleType.f_26359_).ifPresent(arg_0 -> ((MemoryAccessor)home).m_257512_(arg_0));
            if (!alpha.equals(predator)) {
                walk.m_257512_((Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)alpha, false), 1.1f, 6));
            }
            return true;
        })));
    }

    private static boolean isTiredOfTryingToReachTarget(LivingEntity entity, Optional<Long> timeSinceInvalid) {
        return timeSinceInvalid.isPresent() && entity.m_9236_().m_46467_() - timeSinceInvalid.get() > 200L;
    }
}

