/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.predator;

import com.mojang.serialization.Dynamic;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.Temptable;
import net.dries007.tfc.common.entities.ai.predator.PackPredatorAi;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.pet.Dog;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class PackPredator
extends Predator
implements Temptable {
    public static final EntityDataAccessor<Integer> DATA_RESPECT = SynchedEntityData.m_135353_(PackPredator.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> DATA_FAMILIARITY = SynchedEntityData.m_135353_(PackPredator.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean howled;
    private long nextFeedTime = Long.MIN_VALUE;
    private final boolean tamable;

    public static PackPredator createWolf(EntityType<? extends Predator> type, Level level) {
        return new PackPredator(type, level, false, TFCSounds.TFC_WOLF, true);
    }

    public static PackPredator createHyena(EntityType<? extends Predator> type, Level level) {
        return new PackPredator(type, level, false, TFCSounds.HYENA, false);
    }

    public static PackPredator createDirewolf(EntityType<? extends Predator> type, Level level) {
        return new PackPredator(type, level, false, TFCSounds.DOG, false);
    }

    public PackPredator(EntityType<? extends Predator> type, Level level, boolean diurnal, TFCSounds.EntitySound sounds, boolean tamable) {
        super(type, level, diurnal, sounds);
        this.tamable = tamable;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData group = super.m_6518_(level, difficulty, type, data, tag);
        this.setRespect(this.f_19796_.m_188503_(10));
        return group;
    }

    public int getRespect() {
        return (Integer)this.f_19804_.m_135370_(DATA_RESPECT);
    }

    public void setRespect(int amount) {
        this.f_19804_.m_135381_(DATA_RESPECT, (Object)amount);
    }

    public void addRespect(int amount) {
        this.setRespect(this.getRespect() + amount);
    }

    public float getFamiliarity() {
        return ((Float)this.f_19804_.m_135370_(DATA_FAMILIARITY)).floatValue();
    }

    public void setFamiliarity(float amount) {
        this.f_19804_.m_135381_(DATA_FAMILIARITY, (Object)Float.valueOf(Mth.m_14036_((float)amount, (float)0.0f, (float)1.0f)));
    }

    public void addFamiliarity(float amount) {
        this.setFamiliarity(this.getFamiliarity() + amount);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_RESPECT, (Object)0);
        this.f_19804_.m_135372_(DATA_FAMILIARITY, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("respect", this.getRespect());
        tag.m_128350_("familiarity", this.getFamiliarity());
        tag.m_128356_("nextFeed", this.nextFeedTime);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setRespect(EntityHelpers.getIntOrDefault(tag, "respect", 0));
        this.setFamiliarity(EntityHelpers.getFloatOrDefault(tag, "familiarity", 0.0f));
        this.nextFeedTime = EntityHelpers.getLongOrDefault(tag, "nextFeed", Long.MIN_VALUE);
    }

    @Override
    protected Brain.Provider<? extends Predator> m_5490_() {
        return Brain.m_21923_(PackPredatorAi.MEMORY_TYPES, PackPredatorAi.SENSOR_TYPES);
    }

    @Override
    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return PackPredatorAi.makeBrain((Brain<? extends Predator>)this.m_5490_().m_22073_(dynamic), this);
    }

    @Override
    public boolean m_7327_(Entity target) {
        if (super.doHurtTarget(target, 10)) {
            if (!target.m_6084_()) {
                this.addRespect(this.m_217043_().m_188503_(3));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity livingEntity;
        Entity entity;
        if (!this.m_9236_().f_46443_ && (entity = source.m_7640_()) instanceof LivingEntity && EntitySelector.f_20406_.test(livingEntity = (LivingEntity)entity)) {
            PackPredatorAi.alertOthers(this, livingEntity);
        } else if (!this.m_9236_().f_46443_ && this.m_5803_()) {
            PackPredatorAi.alertOthers(this, null);
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        long time = this.m_9236_().m_46468_() % 24000L;
        if (!this.howled && time > 18000L && time < 19000L && this.f_19796_.m_188503_(10) == 0) {
            this.m_5496_(SoundEvents.f_12620_, this.m_6121_() * 1.2f, this.m_6100_());
            this.howled = true;
        }
        if (time > 19000L) {
            this.howled = false;
        }
    }

    public boolean isTamable() {
        return this.tamable;
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return !FoodCapability.isRotten(stack) && this.isTamable() && Helpers.isItem(stack, TFCTags.Items.DOG_FOOD);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (this.m_6898_(held)) {
            long ticks;
            if (!this.m_9236_().f_46443_ && (ticks = Calendars.SERVER.getTicks()) > this.nextFeedTime) {
                this.addFamiliarity(0.1f);
                this.nextFeedTime = ticks + 24000L;
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                }
                this.m_5496_(this.m_7866_(held), this.m_6121_(), this.m_6100_());
                if (this.getFamiliarity() > 0.99f) {
                    Level level;
                    boolean wasBaby = this.m_6162_();
                    Dog dog = (Dog)this.m_21406_((EntityType)TFCEntities.DOG.get(), false);
                    if (dog != null && (level = this.m_9236_()) instanceof ServerLevelAccessor) {
                        ServerLevelAccessor server = (ServerLevelAccessor)level;
                        dog.m_6518_(server, this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.CONVERSION, null, null);
                        dog.setGender(this.isMale() ? TFCAnimalProperties.Gender.MALE : TFCAnimalProperties.Gender.FEMALE);
                        if (!wasBaby) {
                            dog.setBirthDay(Calendars.get((LevelReader)this.m_9236_()).getTotalDays() - 120L);
                        }
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }
}

