/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.entities.ai.livestock.DelegatingTemptingSensor;
import net.dries007.tfc.common.entities.ai.livestock.NearestNestBoxSensor;
import net.dries007.tfc.common.entities.ai.predator.PackLeaderSensor;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.schedule.ScheduleBuilder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class TFCBrain {
    public static final DeferredRegister<Activity> ACTIVITIES = DeferredRegister.create((ResourceKey)Registries.f_257025_, (String)"tfc");
    public static final DeferredRegister<MemoryModuleType<?>> MEMORY_TYPES = DeferredRegister.create((ResourceKey)Registries.f_257023_, (String)"tfc");
    public static final DeferredRegister<Schedule> SCHEDULES = DeferredRegister.create((ResourceKey)Registries.f_256723_, (String)"tfc");
    public static final DeferredRegister<SensorType<?>> SENSOR_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256937_, (String)"tfc");
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256805_, (String)"tfc");
    public static final RegistryObject<Activity> HUNT = TFCBrain.registerActivity("hunt");
    public static final RegistryObject<Activity> IDLE_AT_HOME = TFCBrain.registerActivity("idle_at_home");
    public static final RegistryObject<Activity> FOLLOW = TFCBrain.registerActivity("follow");
    public static final RegistryObject<Activity> SIT = TFCBrain.registerActivity("sit");
    public static final RegistryObject<MemoryModuleType<BlockPos>> NEST_BOX_MEMORY = TFCBrain.registerMemory("nest");
    public static final RegistryObject<MemoryModuleType<GlobalPos>> SLEEP_POS = TFCBrain.registerMemory("sleep_pos", GlobalPos.f_122633_);
    public static final RegistryObject<MemoryModuleType<GlobalPos>> SMELLY_POS = TFCBrain.registerMemory("smelly_pos", GlobalPos.f_122633_);
    public static final RegistryObject<MemoryModuleType<Long>> SIT_TIME = TFCBrain.registerMemory("sit_time", Codec.LONG);
    public static final RegistryObject<MemoryModuleType<PackPredator>> ALPHA = TFCBrain.registerMemory("alpha");
    public static final RegistryObject<MemoryModuleType<Integer>> WAKEUP_TICKS = TFCBrain.registerMemory("wakeup_ticks", Codec.INT);
    public static final RegistryObject<Schedule> DIURNAL = TFCBrain.registerSchedule("diurnal");
    public static final RegistryObject<Schedule> NOCTURNAL = TFCBrain.registerSchedule("nocturnal");
    public static final RegistryObject<SensorType<DelegatingTemptingSensor>> TEMPTATION_SENSOR = TFCBrain.registerSensorType("tempt", DelegatingTemptingSensor::new);
    public static final RegistryObject<SensorType<NearestNestBoxSensor>> NEST_BOX_SENSOR = TFCBrain.registerSensorType("nearest_nest_box", NearestNestBoxSensor::new);
    public static final RegistryObject<SensorType<PackLeaderSensor>> PACK_LEADER_SENSOR = TFCBrain.registerSensorType("pack_leader", PackLeaderSensor::new);
    public static final RegistryObject<PoiType> NEST_BOX_POI = TFCBrain.registerPoi("nest_box", () -> new PoiType(TFCBrain.getBlockStates((Block)TFCBlocks.NEST_BOX.get()), 1, 1));

    private static Set<BlockState> getBlockStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_());
    }

    public static RegistryObject<PoiType> registerPoi(String name, Supplier<PoiType> supplier) {
        return POI_TYPES.register(name, supplier);
    }

    public static <T extends Sensor<?>> RegistryObject<SensorType<T>> registerSensorType(String name, Supplier<T> supplier) {
        return SENSOR_TYPES.register(name, () -> new SensorType(supplier));
    }

    public static RegistryObject<Activity> registerActivity(String name) {
        return ACTIVITIES.register(name, () -> new Activity(name));
    }

    public static <T> RegistryObject<MemoryModuleType<T>> registerMemory(String name) {
        return MEMORY_TYPES.register(name, () -> new MemoryModuleType(Optional.empty()));
    }

    public static <T> RegistryObject<MemoryModuleType<T>> registerMemory(String name, Codec<T> codec) {
        return MEMORY_TYPES.register(name, () -> new MemoryModuleType(Optional.of(codec)));
    }

    public static RegistryObject<Schedule> registerSchedule(String name) {
        return SCHEDULES.register(name, Schedule::new);
    }

    public static void initializeScheduleContents() {
        new ScheduleBuilder((Schedule)DIURNAL.get()).m_38040_(0, (Activity)HUNT.get()).m_38040_(11000, Activity.f_37982_).m_38039_();
        new ScheduleBuilder((Schedule)NOCTURNAL.get()).m_38040_(0, Activity.f_37982_).m_38040_(11000, (Activity)HUNT.get()).m_38039_();
    }
}

