/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.dries007.tfc.common.container.CallbackSlot;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.util.KnappingPattern;
import net.dries007.tfc.util.KnappingType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class KnappingContainer
extends ItemStackContainer
implements ButtonHandlerContainer,
ISlotCallback {
    public static final int SLOT_OUTPUT = 0;
    private final KnappingType knappingType;
    private final KnappingPattern pattern;
    private final ItemStack originalStack;
    private final Query query;
    private boolean requiresReset;
    private boolean hasBeenModified;
    private boolean hasConsumedIngredient;

    public static KnappingContainer create(ItemStack stack, KnappingType type, InteractionHand hand, int slot, Inventory playerInventory, int windowId) {
        return (KnappingContainer)new KnappingContainer((MenuType)TFCContainerTypes.KNAPPING.get(), type, windowId, playerInventory, stack, hand, slot).init(playerInventory, 20);
    }

    public KnappingContainer(MenuType<?> containerType, KnappingType knappingType, int windowId, Inventory playerInv, ItemStack stack, InteractionHand hand, int slot) {
        super(containerType, windowId, playerInv, stack, hand, slot);
        this.knappingType = knappingType;
        this.query = new Query(this);
        this.pattern = new KnappingPattern();
        this.hasBeenModified = false;
        this.hasConsumedIngredient = false;
        this.originalStack = stack.m_41777_();
        this.setRequiresReset(false);
    }

    public KnappingType getKnappingType() {
        return this.knappingType;
    }

    @Override
    public void onButtonPress(int buttonID, @Nullable CompoundTag extraNBT) {
        this.pattern.set(buttonID, false);
        if (!this.hasBeenModified) {
            if (!this.player.m_7500_() && !this.knappingType.consumeAfterComplete()) {
                this.stack.m_41774_(this.knappingType.amountToConsume());
            }
            this.hasBeenModified = true;
        }
        Slot slot = (Slot)this.f_38839_.get(0);
        Level level = this.player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            slot.m_5852_(level2.m_7465_().m_44015_((RecipeType)TFCRecipeTypes.KNAPPING.get(), (Container)this.query, (Level)level2).map(recipe -> recipe.m_5874_(this.query, level2.m_9598_())).orElse(ItemStack.f_41583_));
        }
    }

    @Override
    public boolean m_6875_(Player player) {
        return !this.getTargetStack().m_41619_() || this.hasBeenModified && !this.knappingType.consumeAfterComplete();
    }

    public void m_6877_(Player player) {
        Slot slot = (Slot)this.f_38839_.get(0);
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_() && !player.m_9236_().m_5776_()) {
            player.m_150109_().m_150079_(stack);
            this.consumeIngredientStackAfterComplete();
        }
        super.m_6877_(player);
    }

    public KnappingPattern getPattern() {
        return this.pattern;
    }

    public ItemStack getOriginalStack() {
        return this.originalStack;
    }

    @Override
    public void onSlotTake(Player player, int slot, ItemStack stack) {
        this.resetPattern();
    }

    public boolean requiresReset() {
        return this.requiresReset;
    }

    public void setRequiresReset(boolean requiresReset) {
        this.requiresReset = requiresReset;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    protected boolean moveStack(ItemStack stack, int slotIndex) {
        return switch (this.typeOf(slotIndex)) {
            default -> throw new IncompatibleClassChangeError();
            case Container.IndexType.CONTAINER -> {
                if (!this.m_38903_(stack, this.containerSlots, this.containerSlots + 36, true)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.HOTBAR -> {
                if (!this.m_38903_(stack, this.containerSlots, this.containerSlots + 27, false)) {
                    yield true;
                }
                yield false;
            }
            case Container.IndexType.MAIN_INVENTORY -> !this.m_38903_(stack, this.containerSlots + 27, this.containerSlots + 36, false);
        };
    }

    @Override
    protected void addContainerSlots() {
        this.m_38897_((Slot)new CallbackSlot(this, (IItemHandler)new ItemStackHandler(1), 0, 128, 46));
    }

    private void resetPattern() {
        this.pattern.setAll(false);
        this.setRequiresReset(true);
        this.consumeIngredientStackAfterComplete();
    }

    protected void consumeIngredientStackAfterComplete() {
        if (this.knappingType.consumeAfterComplete() && !this.hasConsumedIngredient) {
            this.stack.m_41774_(this.knappingType.amountToConsume());
            this.hasConsumedIngredient = true;
        }
    }

    public record Query(KnappingContainer container) implements EmptyInventory
    {
    }
}

