/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.container;

import java.util.function.Consumer;
import net.dries007.tfc.common.container.ItemStackContainer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemStackContainerProvider {
    private final ItemStackContainer.Factory<? extends ItemStackContainer> factory;
    @Nullable
    private final Component name;

    public static Consumer<FriendlyByteBuf> write(InteractionHand hand) {
        return buffer -> buffer.writeBoolean(hand == InteractionHand.MAIN_HAND);
    }

    public static Info read(FriendlyByteBuf buffer, Inventory playerInventory) {
        ItemStack stack;
        InteractionHand hand;
        byte slot = buffer.readByte();
        InteractionHand interactionHand = hand = slot == -1 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        if (slot == -1) {
            stack = playerInventory.f_35978_.m_21206_();
        } else {
            int prevSelected = playerInventory.f_35977_;
            playerInventory.f_35977_ = slot;
            stack = playerInventory.m_36056_();
            playerInventory.f_35977_ = prevSelected;
        }
        return new Info(stack, hand, slot);
    }

    public ItemStackContainerProvider(ItemStackContainer.Factory<? extends ItemStackContainer> factory) {
        this(factory, null);
    }

    public ItemStackContainerProvider(ItemStackContainer.Factory<? extends ItemStackContainer> factory, @Nullable Component name) {
        this.factory = factory;
        this.name = name;
    }

    public void openScreen(ServerPlayer player, InteractionHand hand) {
        this.openScreen(player, hand, buffer -> {});
    }

    public void openScreen(ServerPlayer player, InteractionHand hand, Consumer<FriendlyByteBuf> additionalData) {
        ItemStack stack = player.m_21120_(hand);
        int encodedSlot = hand == InteractionHand.OFF_HAND ? -1 : player.m_150109_().f_35977_;
        SimpleMenuProvider provider = new SimpleMenuProvider((windowId, playerInventory, playerIn) -> this.factory.create(stack, hand, encodedSlot, playerInventory, windowId), this.name == null ? stack.m_41786_() : this.name);
        Helpers.openScreen(player, (MenuProvider)provider, buffer -> {
            additionalData.accept((FriendlyByteBuf)buffer);
            buffer.writeByte(encodedSlot);
        });
    }

    public record Info(ItemStack stack, InteractionHand hand, int slot) {
    }
}

