/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public final class TimeCommand {
    private static final String DAYTIME = "tfc.commands.time.query.daytime";
    private static final String GAME_TIME = "tfc.commands.time.query.game_time";
    private static final String DAY = "tfc.commands.time.query.day";
    private static final String PLAYER_TICKS = "tfc.commands.time.query.player_ticks";
    private static final String CALENDAR_TICKS = "tfc.commands.time.query.calendar_ticks";

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"time").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"monthlength").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TimeCommand.setMonthLength(IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))).then(Commands.m_82127_((String)"day").executes(context -> TimeCommand.setTime(((CommandSourceStack)context.getSource()).m_81377_(), 1000)))).then(Commands.m_82127_((String)"noon").executes(context -> TimeCommand.setTime(((CommandSourceStack)context.getSource()).m_81377_(), 6000)))).then(Commands.m_82127_((String)"night").executes(context -> TimeCommand.setTime(((CommandSourceStack)context.getSource()).m_81377_(), 13000)))).then(Commands.m_82127_((String)"midnight").executes(context -> TimeCommand.setTime(((CommandSourceStack)context.getSource()).m_81377_(), 18000))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(Commands.m_82127_((String)"years").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TimeCommand.addTime((long)IntegerArgumentType.getInteger((CommandContext)context, (String)"value") * Calendars.SERVER.getCalendarTicksInYear()))))).then(Commands.m_82127_((String)"months").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TimeCommand.addTime((long)IntegerArgumentType.getInteger((CommandContext)context, (String)"value") * Calendars.SERVER.getCalendarTicksInMonth()))))).then(Commands.m_82127_((String)"days").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TimeCommand.addTime((long)IntegerArgumentType.getInteger((CommandContext)context, (String)"value") * 24000L))))).then(Commands.m_82127_((String)"ticks").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> TimeCommand.addTime(IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"query").then(Commands.m_82127_((String)"daytime").executes(context -> TimeCommand.sendQueryResults((CommandSourceStack)context.getSource(), DAYTIME, Calendars.SERVER.getCalendarDayTime())))).then(Commands.m_82127_((String)"gametime").executes(context -> TimeCommand.sendQueryResults((CommandSourceStack)context.getSource(), GAME_TIME, ((CommandSourceStack)context.getSource()).m_81372_().m_46467_())))).then(Commands.m_82127_((String)"day").executes(context -> TimeCommand.sendQueryResults((CommandSourceStack)context.getSource(), DAY, Calendars.SERVER.getTotalDays())))).then(Commands.m_82127_((String)"ticks").executes(context -> TimeCommand.sendQueryResults((CommandSourceStack)context.getSource(), PLAYER_TICKS, Calendars.SERVER.getTicks())))).then(Commands.m_82127_((String)"calendarticks").executes(context -> TimeCommand.sendQueryResults((CommandSourceStack)context.getSource(), CALENDAR_TICKS, Calendars.SERVER.getCalendarTicks()))));
    }

    private static int setMonthLength(int months) {
        Calendars.SERVER.setMonthLength(months);
        return 1;
    }

    private static int setTime(MinecraftServer server, int dayTime) {
        for (ServerLevel world : server.m_129785_()) {
            long dayTimeJump = (long)dayTime - world.m_46468_() % 24000L;
            if (dayTimeJump < 0L) {
                dayTimeJump += 24000L;
            }
            world.m_8615_(world.m_46468_() + dayTimeJump);
        }
        Calendars.SERVER.setTimeFromDayTime(dayTime);
        return 1;
    }

    private static int addTime(long ticksToAdd) {
        Calendars.SERVER.setTimeFromCalendarTime(Calendars.SERVER.getCalendarTicks() + ticksToAdd);
        return 1;
    }

    private static int sendQueryResults(CommandSourceStack source, String translationKey, long value) {
        source.m_288197_(() -> Component.m_237110_((String)translationKey, (Object[])new Object[]{(int)value}), false);
        return 1;
    }
}

