/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.forge;

import net.dries007.tfc.common.capabilities.forge.ForgeRule;
import net.dries007.tfc.common.capabilities.forge.ForgeStep;
import net.dries007.tfc.common.capabilities.forge.ForgeSteps;
import net.dries007.tfc.common.capabilities.forge.ForgingCapability;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Forging
implements ICapabilityProvider {
    private static final String KEY = "tfc:forging";
    private final LazyOptional<Forging> capability = LazyOptional.of(() -> this);
    private final ItemStack stack;
    private final ForgeSteps steps;
    private int work;
    private int target;
    @Nullable
    private AnvilRecipe recipe;
    @Nullable
    private ResourceLocation uninitializedRecipe;

    public Forging(ItemStack stack) {
        this.stack = stack;
        this.work = 0;
        this.recipe = null;
        this.steps = new ForgeSteps();
        this.load();
    }

    public int getWork() {
        return this.work;
    }

    public int getWorkTarget() {
        return this.target == -1 ? 0 : this.target;
    }

    @Nullable
    public AnvilRecipe getRecipe(Level level) {
        if (this.uninitializedRecipe != null) {
            this.recipe = Helpers.getRecipes(level, TFCRecipeTypes.ANVIL).get(this.uninitializedRecipe);
            this.uninitializedRecipe = null;
        }
        return this.recipe;
    }

    public void setRecipe(@Nullable AnvilRecipe recipe, AnvilRecipe.Inventory inventory) {
        this.setRecipe(recipe, recipe == null ? -1 : recipe.computeTarget(inventory));
    }

    public void setRecipe(@Nullable AnvilRecipe recipe, int target) {
        this.recipe = recipe;
        this.target = target;
        this.save();
    }

    public ForgeSteps getSteps() {
        return this.steps;
    }

    public boolean matches(ForgeRule[] rules) {
        for (ForgeRule rule : rules) {
            if (this.matches(rule)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(ForgeRule rule) {
        return rule.matches(this.steps);
    }

    public void addStep(@Nullable ForgeStep step) {
        this.steps.addStep(step);
        if (step != null) {
            this.work += step.step();
        }
        this.save();
    }

    public void addStep(@Nullable ForgeStep step, int amount) {
        this.steps.addStep(step);
        this.work += amount;
        this.save();
    }

    public void clearRecipeIfNotWorked() {
        if (!this.steps.any()) {
            this.recipe = null;
            this.uninitializedRecipe = null;
        }
        this.save();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgingCapability.CAPABILITY) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    private void load() {
        CompoundTag tag = this.stack.m_41737_(KEY);
        if (tag != null) {
            this.work = tag.m_128451_("work");
            this.target = tag.m_128451_("target");
            this.steps.read(tag);
            this.uninitializedRecipe = tag.m_128425_("recipe", 8) ? Helpers.resourceLocation(tag.m_128461_("recipe")) : null;
            this.recipe = null;
        }
    }

    private void save() {
        if (!this.steps.any() && this.recipe == null && this.uninitializedRecipe == null) {
            this.stack.m_41749_(KEY);
        } else {
            CompoundTag tag = this.stack.m_41698_(KEY);
            tag.m_128405_("work", this.work);
            tag.m_128405_("target", this.target);
            this.steps.write(tag);
            if (this.recipe != null) {
                tag.m_128359_("recipe", this.recipe.m_6423_().toString());
            } else if (this.uninitializedRecipe != null) {
                tag.m_128359_("recipe", this.uninitializedRecipe.toString());
            }
        }
    }
}

