/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.forge;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public enum ForgeStep {
    HIT_LIGHT(-3, 53, 50, 128, 224),
    HIT_MEDIUM(-6, 71, 50, 160, 224),
    HIT_HARD(-9, 53, 68, 192, 224),
    DRAW(-15, 71, 68, 224, 224),
    PUNCH(2, 89, 50, 0, 224),
    BEND(7, 107, 50, 32, 224),
    UPSET(13, 89, 68, 64, 224),
    SHRINK(16, 107, 68, 96, 224);

    public static final int LIMIT = 150;
    public static final ForgeStep[] VALUES;
    private static final int[] PATHS;
    private final int step;
    private final int buttonX;
    private final int buttonY;
    private final int iconX;
    private final int iconY;

    @Nullable
    public static ForgeStep valueOf(int id) {
        return id >= 0 && id < VALUES.length ? VALUES[id] : null;
    }

    public static int getOptimalStepsToTarget(int target) {
        return target < 0 || target >= PATHS.length ? Integer.MAX_VALUE : PATHS[target];
    }

    private ForgeStep(int step, int buttonX, int buttonY, int iconX, int iconY) {
        this.step = step;
        this.buttonX = buttonX;
        this.buttonY = buttonY;
        this.iconX = iconX;
        this.iconY = iconY;
    }

    public int step() {
        return this.step;
    }

    public int buttonX() {
        return this.buttonX;
    }

    public int buttonY() {
        return this.buttonY;
    }

    public int iconX() {
        return this.iconX;
    }

    public int iconY() {
        return this.iconY;
    }

    static {
        VALUES = ForgeStep.values();
        PATHS = new int[150];
        Arrays.fill(PATHS, -1);
        ForgeStep.PATHS[0] = 0;
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        IntArrayList buffer = new IntArrayList(8);
        int reached = 1;
        queue.enqueue(0);
        int steps = 1;
        while (reached < 150) {
            while (!queue.isEmpty()) {
                int value = queue.dequeueInt();
                for (ForgeStep step : VALUES) {
                    int nextValue = value + step.step;
                    if (nextValue < 0 || nextValue >= 150 || PATHS[nextValue] != -1) continue;
                    ForgeStep.PATHS[nextValue] = steps;
                    buffer.add(nextValue);
                    ++reached;
                }
            }
            buffer.forEach(arg_0 -> ((IntPriorityQueue)queue).enqueue(arg_0));
            buffer.clear();
            ++steps;
        }
    }
}

