/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.food;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.capabilities.food.DynamicBowlHandler;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.FoodHandler;
import net.dries007.tfc.util.ItemDefinition;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class FoodDefinition
extends ItemDefinition {
    private final FoodData data;
    private final HandlerType handlerType;

    public static FoodHandler getHandler(FoodDefinition definition, ItemStack stack) {
        return switch (definition.handlerType) {
            default -> throw new IncompatibleClassChangeError();
            case HandlerType.STATIC -> new FoodHandler(definition.getData());
            case HandlerType.DYNAMIC -> new FoodHandler.Dynamic();
            case HandlerType.DYNAMIC_BOWL -> new DynamicBowlHandler(stack);
        };
    }

    public FoodDefinition(ResourceLocation id, JsonObject json) {
        super(id, json);
        if (json.has("type")) {
            this.handlerType = JsonHelpers.getEnum(json.get("type"), HandlerType.class);
            this.data = FoodData.EMPTY;
        } else {
            this.handlerType = HandlerType.STATIC;
            this.data = FoodData.read(json);
        }
    }

    public FoodDefinition(ResourceLocation id, FriendlyByteBuf buffer) {
        super(id, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        this.data = FoodData.decode(buffer);
        this.handlerType = (HandlerType)buffer.m_130066_(HandlerType.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        this.data.encode(buffer);
        buffer.m_130068_((Enum)this.handlerType);
    }

    public FoodData getData() {
        return this.data;
    }

    public HandlerType getHandlerType() {
        return this.handlerType;
    }

    public static enum HandlerType {
        STATIC,
        DYNAMIC,
        DYNAMIC_BOWL;

    }
}

