/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.food;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.common.capabilities.food.FoodDefinition;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.food.INetworkFood;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.ItemDefinition;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public final class FoodCapability {
    public static final Capability<IFood> CAPABILITY = Helpers.capability(new CapabilityToken<IFood>(){});
    public static final Capability<INetworkFood> NETWORK_CAPABILITY = Helpers.capability(new CapabilityToken<INetworkFood>(){});
    public static final ResourceLocation KEY = Helpers.identifier("food");
    public static final DataManager<FoodDefinition> MANAGER = new DataManager<FoodDefinition>(Helpers.identifier("food_items"), "food", FoodDefinition::new, FoodDefinition::new, FoodDefinition::encode, Packet::new);
    public static final IndirectHashCollection<Item, FoodDefinition> CACHE = IndirectHashCollection.create(ItemDefinition::getValidItems, MANAGER::getValues);

    @Nullable
    public static IFood get(ItemStack stack) {
        return Helpers.getCapability((ICapabilityProvider)stack, CAPABILITY);
    }

    public static boolean has(ItemStack stack) {
        return stack.getCapability(CAPABILITY).isPresent();
    }

    @Nullable
    public static FoodDefinition getDefinition(ItemStack stack) {
        for (FoodDefinition def : CACHE.getAll(stack.m_41720_())) {
            if (!def.matches(stack)) continue;
            return def;
        }
        return null;
    }

    public static void applyTrait(IFood food, FoodTrait trait) {
        if (!food.hasTrait(trait)) {
            if (!food.isRotten()) {
                food.setCreationDate(FoodCapability.calculateNewCreationDate(food.getCreationDate(), 1.0f / trait.getDecayModifier()));
            }
            food.getTraits().add(trait);
        }
    }

    public static ItemStack applyTrait(ItemStack stack, FoodTrait trait) {
        @Nullable IFood food = FoodCapability.get(stack);
        if (food != null) {
            FoodCapability.applyTrait(food, trait);
        }
        return stack;
    }

    public static void removeTrait(IFood food, FoodTrait trait) {
        if (food.hasTrait(trait)) {
            if (!food.isRotten()) {
                food.setCreationDate(FoodCapability.calculateNewCreationDate(food.getCreationDate(), trait.getDecayModifier()));
            }
            food.getTraits().remove(trait);
        }
    }

    public static ItemStack removeTrait(ItemStack stack, FoodTrait trait) {
        @Nullable IFood food = FoodCapability.get(stack);
        if (food != null) {
            FoodCapability.removeTrait(food, trait);
        }
        return stack;
    }

    public static boolean hasTrait(ItemStack stack, FoodTrait trait) {
        @Nullable IFood food = FoodCapability.get(stack);
        return food != null && food.hasTrait(trait);
    }

    public static boolean isRotten(ItemStack stack) {
        @Nullable IFood food = FoodCapability.get(stack);
        return food != null && food.isRotten();
    }

    public static void addTooltipInfo(ItemStack stack, List<Component> text) {
        @Nullable IFood food = FoodCapability.get(stack);
        if (food != null) {
            food.addTooltipInfo(stack, text);
        }
    }

    public static ItemStack setCreationDate(ItemStack stack, long date) {
        @Nullable IFood food = FoodCapability.get(stack);
        if (food != null) {
            food.setCreationDate(date);
        }
        return stack;
    }

    public static ItemStack setRotten(ItemStack stack) {
        return FoodCapability.setCreationDate(stack, Long.MIN_VALUE);
    }

    public static void setNeverExpires(ItemStack stack) {
        FoodCapability.setCreationDate(stack, -2L);
    }

    public static ItemStack updateFoodDecayOnCreate(ItemStack stack) {
        return FoodCapability.setCreationDate(stack, FoodCapability.getRoundedCreationDate());
    }

    public static ItemStack updateFoodFromPrevious(ItemStack oldStack, ItemStack newStack) {
        @Nullable IFood oldFood = FoodCapability.get(oldStack);
        @Nullable IFood newFood = FoodCapability.get(newStack);
        if (oldFood != null && newFood != null) {
            newFood.getTraits().addAll(oldFood.getTraits());
            float decayDelta = newFood.getDecayDateModifier() / oldFood.getDecayDateModifier();
            newFood.setCreationDate(FoodCapability.calculateNewRoundedCreationDate(oldFood.getCreationDate(), decayDelta));
        }
        return newStack;
    }

    public static ItemStack updateFoodFromAllPrevious(Collection<ItemStack> oldStacks, ItemStack newStack) {
        @Nullable IFood newFood = FoodCapability.get(newStack);
        if (newFood != null) {
            if (oldStacks.isEmpty()) {
                return newStack;
            }
            float decayDateModifier = 0.0f;
            long oldCreationDate = Long.MAX_VALUE;
            int oldFoodCount = 0;
            for (ItemStack oldStack : oldStacks) {
                IFood oldFood = FoodCapability.get(oldStack);
                if (oldFood == null) continue;
                decayDateModifier += oldFood.getDecayDateModifier();
                oldCreationDate = Math.min(oldCreationDate, oldFood.getCreationDate());
                ++oldFoodCount;
            }
            if (oldFoodCount > 0) {
                float decayDelta = (float)oldFoodCount * newFood.getDecayDateModifier() / decayDateModifier;
                newFood.setCreationDate(FoodCapability.calculateNewCreationDate(oldCreationDate, decayDelta));
            }
        }
        return newStack;
    }

    public static ItemStack setStackNonDecaying(ItemStack stack) {
        @Nullable IFood food = FoodCapability.get(stack);
        if (food != null) {
            food.setNonDecaying();
        }
        return stack;
    }

    public static Supplier<ItemStack> createNonDecayingStack(ItemStack stack) {
        return () -> FoodCapability.setStackNonDecaying(stack);
    }

    public static void markRecipeOutputsAsNonDecaying(RegistryAccess registryAccess, RecipeManager manager) {
        for (Recipe recipe : manager.m_44051_()) {
            @Nullable ItemStack stack = recipe.m_8043_(registryAccess);
            if (stack != null) {
                FoodCapability.setStackNonDecaying(stack);
                continue;
            }
            TerraFirmaCraft.LOGGER.warn("Other mod issue: recipe with a null getResultItem(), in recipe {} of class {}", (Object)recipe.m_6423_(), (Object)recipe.getClass().getName());
        }
    }

    public static ItemStack mergeItemStacks(ItemStack stackToMergeInto, ItemStack stackToMerge) {
        if (stackToMerge.m_41619_()) {
            return stackToMergeInto;
        }
        if (stackToMergeInto.m_41619_()) {
            ItemStack merged = stackToMerge.m_41777_();
            stackToMerge.m_41764_(0);
            return merged;
        }
        if (FoodCapability.areStacksStackableExceptCreationDate(stackToMergeInto, stackToMerge)) {
            @Nullable IFood mergeIntoFood = FoodCapability.get(stackToMergeInto);
            @Nullable IFood mergeFood = FoodCapability.get(stackToMerge);
            if (mergeIntoFood != null && mergeFood != null) {
                mergeIntoFood.setCreationDate(Math.min(mergeIntoFood.getCreationDate(), mergeFood.getCreationDate()));
            }
            int mergeAmount = Math.min(stackToMerge.m_41613_(), stackToMergeInto.m_41741_() - stackToMergeInto.m_41613_());
            stackToMerge.m_41774_(mergeAmount);
            stackToMergeInto.m_41769_(mergeAmount);
        }
        return stackToMergeInto;
    }

    public static boolean areStacksStackableExceptCreationDate(ItemStack stack1, ItemStack stack2) {
        ItemStack stack1Copy = stack1.m_41777_();
        ItemStack stack2Copy = stack2.m_41777_();
        long date = Calendars.get().getTicks();
        FoodCapability.setCreationDate(stack1Copy, date);
        FoodCapability.setCreationDate(stack2Copy, date);
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack1Copy, (ItemStack)stack2Copy);
    }

    public static long getRoundedCreationDate() {
        return FoodCapability.getRoundedCreationDate(Calendars.get().getTicks());
    }

    public static long getRoundedCreationDate(long tick) {
        int window = (Integer)Helpers.getValueOrDefault(TFCConfig.SERVER.foodDecayStackWindow) * 1000;
        return ((tick - 1L) / (long)window + 1L) * (long)window;
    }

    private static long calculateNewRoundedCreationDate(long ci, float p) {
        return FoodCapability.getRoundedCreationDate(FoodCapability.calculateNewCreationDate(ci, p));
    }

    private static long calculateNewCreationDate(long ci, float p) {
        return (long)((1.0f - p) * (float)Calendars.get().getTicks() + p * (float)ci);
    }

    public static class Packet
    extends DataManagerSyncPacket<FoodDefinition> {
    }
}

