/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities.egg;

import java.util.List;
import java.util.Optional;
import net.dries007.tfc.common.capabilities.egg.EggCapability;
import net.dries007.tfc.common.capabilities.egg.IEgg;
import net.dries007.tfc.common.capabilities.food.DelegateFoodHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.FoodHandler;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EggHandler
implements IEgg,
DelegateFoodHandler,
ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<EggHandler> capability;
    private final ItemStack stack;
    private final FoodHandler foodHandler;
    private boolean fertilized;
    private long hatchDay;
    @Nullable
    private CompoundTag entityTag;
    private boolean initialized;

    public EggHandler(ItemStack itemStack) {
        this.stack = itemStack;
        this.fertilized = false;
        this.hatchDay = 0L;
        this.entityTag = null;
        this.foodHandler = new FoodHandler(FoodData.decayOnly(2.0f));
        this.capability = LazyOptional.of(() -> this);
    }

    @Override
    public long getHatchDay() {
        return this.hatchDay;
    }

    @Override
    public Optional<Entity> getEntity(Level level) {
        return this.entityTag != null ? EntityType.m_20642_((CompoundTag)this.entityTag, (Level)level) : Optional.empty();
    }

    @Override
    public boolean isFertilized() {
        return this.fertilized;
    }

    @Override
    public void setFertilized(@NotNull Entity entity, long hatchDay) {
        this.fertilized = true;
        this.entityTag = entity.serializeNBT();
        this.hatchDay = hatchDay;
        this.save();
    }

    @Override
    public void removeFertilization() {
        this.entityTag = null;
        this.fertilized = false;
        this.hatchDay = 0L;
        this.stack.m_41749_("entity");
        this.stack.m_41749_("fertilized");
        this.stack.m_41749_("hatch");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == FoodCapability.NETWORK_CAPABILITY) {
            return this.capability.cast();
        }
        if (cap == EggCapability.CAPABILITY || cap == FoodCapability.CAPABILITY) {
            this.load();
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public IFood getFoodHandler() {
        return this.foodHandler;
    }

    @Override
    public void addTooltipInfo(ItemStack stack, List<Component> text) {
        if (!this.isFertilized()) {
            DelegateFoodHandler.super.addTooltipInfo(stack, text);
        }
    }

    @Override
    public long getRottenDate() {
        if (this.isFertilized()) {
            return Long.MAX_VALUE;
        }
        return DelegateFoodHandler.super.getRottenDate();
    }

    private void load() {
        if (!this.initialized) {
            this.initialized = true;
            CompoundTag tag = this.stack.m_41784_();
            if (tag.m_128425_("entity", 10)) {
                this.entityTag = tag.m_128469_("entity");
                this.fertilized = tag.m_128471_("fertilized");
                this.hatchDay = tag.m_128454_("hatch");
            } else {
                this.fertilized = false;
                this.entityTag = null;
                this.hatchDay = 0L;
            }
        }
    }

    private void save() {
        CompoundTag tag = this.stack.m_41784_();
        if (this.entityTag != null) {
            tag.m_128365_("entity", (Tag)this.entityTag);
            tag.m_128379_("fertilized", this.fertilized);
            tag.m_128356_("hatch", this.hatchDay);
        }
    }
}

