/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rotation;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class HandWheelBlock
extends DeviceBlock {
    public static final BooleanProperty HAS_WHEEL = TFCBlockStateProperties.HAS_WHEEL;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape[] SHAPE = Helpers.computeHorizontalShapes(dir -> Helpers.rotateShape(dir, 0.0, 0.0, 0.0, 16.0, 16.0, 4.0));
    private static final VoxelShape[] SHAPE_WITH_WHEEL = Helpers.computeHorizontalShapes(dir -> Shapes.m_83110_((VoxelShape)Helpers.rotateShape(dir, 0.0, 0.0, 0.0, 16.0, 16.0, 4.0), (VoxelShape)Helpers.rotateShape(dir, 3.0, 3.0, 3.0, 13.0, 13.0, 13.0)));

    public HandWheelBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HAS_WHEEL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RotatingBlockEntity) {
            RotatingBlockEntity entity = (RotatingBlockEntity)blockEntity;
            entity.destroyIfInvalid((Level)level, pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.HAND_WHEEL.get()).map(wheel -> {
            ItemStack held = player.m_21120_(hand);
            if (Helpers.isItem(held, TFCTags.Items.HAND_WHEEL)) {
                return wheel.getCapability(Capabilities.ITEM).map(cap -> {
                    ItemStack current = cap.getStackInSlot(0);
                    if (current.m_41619_() && cap.isItemValid(0, held)) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)cap.insertItem(0, held.m_41620_(1), false));
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    if (!current.m_41619_() && player.m_6144_() && held.m_41619_()) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)cap.extractItem(0, 1, false));
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    return InteractionResult.PASS;
                }).orElse(InteractionResult.PASS);
            }
            if (!player.m_6144_()) {
                wheel.rotate();
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int idx = ((Direction)state.m_61143_((Property)FACING)).m_122416_();
        return (Boolean)state.m_61143_((Property)HAS_WHEEL) != false ? SHAPE_WITH_WHEEL[idx] : SHAPE[idx];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{HAS_WHEEL, FACING}));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

