/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rotation;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.ConnectedAxleBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class GearBoxBlock
extends DeviceBlock
implements DirectionPropertyBlock,
ConnectedAxleBlock {
    private final Supplier<? extends AxleBlock> axle;

    public GearBoxBlock(ExtendedProperties properties, Supplier<? extends AxleBlock> axle) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
        this.axle = axle;
        this.m_49959_(DirectionPropertyBlock.setAllDirections((BlockState)this.m_49965_().m_61090_(), false));
    }

    @Override
    public AxleBlock getAxle() {
        return this.axle.get();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (Helpers.isItem(player.m_21120_(hand), TFCTags.Items.HAMMERS)) {
            BooleanProperty property = DirectionPropertyBlock.getProperty(result.m_82434_());
            boolean prev = (Boolean)state.m_61143_((Property)property);
            if (prev || this.canEnable(state, property)) {
                level.m_46597_(pos, (BlockState)state.m_61122_((Property)property));
                level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.GEAR_BOX.get()).ifPresent(box -> box.updateDirection(result.m_82434_(), !prev));
                Helpers.playPlaceSound((LevelAccessor)level, pos, state);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            Helpers.playSound(level, pos, SoundEvents.f_12018_);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private boolean canEnable(BlockState state, BooleanProperty direction) {
        return (Boolean)(state = (BlockState)state.m_61124_((Property)direction, (Comparable)Boolean.valueOf(true))).m_61143_((Property)NORTH) == false && (Boolean)state.m_61143_((Property)SOUTH) == false || (Boolean)state.m_61143_((Property)EAST) == false && (Boolean)state.m_61143_((Property)WEST) == false || (Boolean)state.m_61143_((Property)UP) == false && (Boolean)state.m_61143_((Property)DOWN) == false;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RotatingBlockEntity) {
            RotatingBlockEntity entity = (RotatingBlockEntity)blockEntity;
            entity.destroyIfInvalid((Level)level, pos);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return DirectionPropertyBlock.rotate(state, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return DirectionPropertyBlock.mirror(state, mirror);
    }
}

