/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.util.registry.RegistryRock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public enum Ore {
    NATIVE_COPPER(true),
    NATIVE_GOLD(true),
    HEMATITE(true),
    NATIVE_SILVER(true),
    CASSITERITE(true),
    BISMUTHINITE(true),
    GARNIERITE(true),
    MALACHITE(true),
    MAGNETITE(true),
    LIMONITE(true),
    SPHALERITE(true),
    TETRAHEDRITE(true),
    BITUMINOUS_COAL(false),
    LIGNITE(false),
    GYPSUM(false),
    GRAPHITE(false),
    SULFUR(false),
    CINNABAR(false),
    CRYOLITE(false),
    SALTPETER(false),
    SYLVITE(false),
    BORAX(false),
    HALITE(false),
    AMETHYST(false),
    DIAMOND(false),
    EMERALD(false),
    LAPIS_LAZULI(false),
    OPAL(false),
    PYRITE(false),
    RUBY(false),
    SAPPHIRE(false),
    TOPAZ(false);

    private final boolean graded;

    private Ore(boolean graded) {
        this.graded = graded;
    }

    public boolean isGraded() {
        return this.graded;
    }

    public Block create(RegistryRock rock) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60918_(SoundType.f_56742_).m_60913_(rock.category().hardness(6.5f), 10.0f).m_60999_();
        if (this == LIGNITE || this == BITUMINOUS_COAL) {
            return new ExtendedBlock(ExtendedProperties.of(properties).flammable(5, 120));
        }
        return new Block(properties);
    }

    public static enum Grade {
        POOR,
        NORMAL,
        RICH;

        private static final Grade[] VALUES;

        public static Grade valueOf(int i) {
            return i < 0 || i >= VALUES.length ? NORMAL : VALUES[i];
        }

        static {
            VALUES = Grade.values();
        }
    }
}

