/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rock;

import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AqueductBlock
extends HorizontalDirectionalBlock
implements IFluidLoggable {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final FluidProperty FLUID = TFCBlockStateProperties.ALL_WATER;
    private static final VoxelShape[] SHAPES = new VoxelShape[16];
    private static final int SHORT_TICK_DELAY = 5;
    private static final int LONG_TICK_DELAY = 20;

    private static boolean isValidSource(BlockState state) {
        return !state.m_60795_() && (state.m_60819_().m_76170_() || state.m_60819_().m_61138_((Property)FlowingFluid.f_75948_) && (Integer)state.m_60819_().m_61143_((Property)FlowingFluid.f_75948_) == 8);
    }

    private static BlockState updateOpenSides(LevelAccessor level, BlockPos pos, BlockState state) {
        int openSides = 0;
        Direction openDirection = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState adjacentState = level.m_8055_(adjacentPos);
            boolean adjacentAqueduct = adjacentState.m_60734_() instanceof AqueductBlock;
            if (adjacentAqueduct) {
                ++openSides;
                openDirection = direction;
            }
            state = (BlockState)state.m_61124_((Property)DirectionPropertyBlock.getProperty(direction), (Comparable)Boolean.valueOf(adjacentAqueduct));
        }
        if (openSides == 1) {
            state = (BlockState)state.m_61124_((Property)DirectionPropertyBlock.getProperty(openDirection.m_122424_()), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private static void tickAllAdjacentAqueducts(LevelAccessor level, BlockPos pos, int tickDelay, @Nullable Direction excludedDirection) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos;
            BlockState adjacentState;
            if (direction == excludedDirection || !((adjacentState = level.m_8055_(adjacentPos = pos.m_121945_(direction))).m_60734_() instanceof AqueductBlock)) continue;
            level.m_186460_(adjacentPos, adjacentState.m_60734_(), tickDelay);
        }
    }

    public AqueductBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.f_76191_)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return AqueductBlock.updateOpenSides((LevelAccessor)context.m_43725_(), context.m_8083_(), this.m_49966_());
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.m_186460_(pos, (Block)this, 20);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() != this && ((FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty())).getFluid() != Fluids.f_76191_ && newState.m_60819_().m_76152_().m_6212_(((FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty())).getFluid())) {
            BlockState blockState;
            Fluid fluid = newState.m_60819_().m_76152_();
            if (fluid instanceof FlowingFluid) {
                FlowingFluid fluid2 = (FlowingFluid)fluid;
                blockState = fluid2.m_75953_(1, false).m_76188_();
            } else {
                blockState = Blocks.f_50016_.m_49966_();
            }
            BlockState newFluidState = blockState;
            level.m_7731_(pos, newFluidState, 2);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Boolean)state.m_61143_((Property)NORTH) != false ? 1 << Direction.NORTH.m_122416_() : 0) | ((Boolean)state.m_61143_((Property)EAST) != false ? 1 << Direction.EAST.m_122416_() : 0) | ((Boolean)state.m_61143_((Property)SOUTH) != false ? 1 << Direction.SOUTH.m_122416_() : 0) | ((Boolean)state.m_61143_((Property)WEST) != false ? 1 << Direction.WEST.m_122416_() : 0)];
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState adjacentState, LevelAccessor level, BlockPos pos, BlockPos adjacentPos) {
        FluidHelpers.tickFluid(level, pos, state);
        BlockState newState = AqueductBlock.updateOpenSides(level, pos, state);
        if (state != newState || (((FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty())).getFluid() == Fluids.f_76191_ ? direction.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL && (Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty(direction)) != false : direction == state.m_61143_((Property)f_54117_))) {
            level.m_186460_(pos, (Block)this, 20);
        }
        return newState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, f_54117_, this.getFluidProperty()});
    }

    @Override
    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        boolean result = IFluidLoggable.super.m_7361_(level, pos, state, fluidStateIn);
        if (result) {
            level.m_186460_(pos, (Block)this, 5);
        }
        return result;
    }

    @Override
    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (((FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty())).getFluid() != Fluids.f_76191_) {
            level.m_186460_(pos, (Block)this, 20);
        }
        return IFluidLoggable.super.m_142598_(level, pos, state);
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidLoggedState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Direction sourceDirection = (Direction)state.m_61143_((Property)f_54117_);
        FluidProperty.FluidKey sourceFluid = (FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty());
        if (sourceFluid.getFluid() != Fluids.f_76191_) {
            boolean valid = false;
            if (((Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty(sourceDirection))).booleanValue()) {
                BlockState sourceState = level.m_8055_(pos.m_121945_(sourceDirection));
                if (sourceState.m_60734_() instanceof AqueductBlock) {
                    valid = sourceState.m_61143_((Property)this.getFluidProperty()) == sourceFluid && sourceState.m_61143_((Property)f_54117_) != sourceDirection.m_122424_();
                } else if (AqueductBlock.isValidSource(sourceState) && sourceState.m_60819_().m_76152_().m_6212_(sourceFluid.getFluid())) {
                    valid = true;
                }
            }
            if (!valid) {
                state = (BlockState)state.m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.f_76191_));
                AqueductBlock.tickAllAdjacentAqueducts((LevelAccessor)level, pos, 5, sourceDirection);
                level.m_46597_(pos, state);
            }
        } else {
            boolean filled = false;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Fluid adjacentFluid;
                if (!((Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty(direction))).booleanValue()) continue;
                BlockPos adjacentPos = pos.m_121945_(direction);
                BlockState adjacentState = level.m_8055_(adjacentPos);
                Fluid fluid = adjacentState.m_60819_().m_76152_();
                if (fluid instanceof FlowingFluid) {
                    FlowingFluid flow = (FlowingFluid)fluid;
                    v0 = flow.m_5613_();
                } else {
                    v0 = adjacentFluid = adjacentState.m_60819_().m_76152_();
                }
                if (adjacentState.m_60734_() instanceof AqueductBlock) {
                    if (!((Boolean)adjacentState.m_61143_((Property)DirectionPropertyBlock.getProperty(direction.m_122424_()))).booleanValue() || adjacentState.m_61143_((Property)f_54117_) == direction.m_122424_() || ((FluidProperty.FluidKey)adjacentState.m_61143_((Property)this.getFluidProperty())).getFluid() == Fluids.f_76191_) continue;
                    state = (BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)this.getFluidProperty(), (Comparable)((FluidProperty.FluidKey)adjacentState.m_61143_((Property)this.getFluidProperty())));
                    filled = true;
                    break;
                }
                if (!AqueductBlock.isValidSource(adjacentState) || !this.getFluidProperty().canContain(adjacentFluid)) continue;
                state = (BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(adjacentFluid));
                filled = true;
                break;
            }
            if (filled) {
                level.m_46597_(pos, state);
                level.m_186469_(pos, state.m_60819_().m_76152_(), state.m_60819_().m_76152_().m_6718_((LevelReader)level));
                AqueductBlock.tickAllAdjacentAqueducts((LevelAccessor)level, pos, 20, (Direction)state.m_61143_((Property)f_54117_));
            }
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return DirectionPropertyBlock.rotate(super.m_6843_(state, rot), rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)DirectionPropertyBlock.mirror(state, mirror).m_61124_((Property)f_54117_, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)f_54117_)));
    }

    static {
        VoxelShape north = AqueductBlock.m_49796_((double)4.0, (double)10.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0);
        VoxelShape east = AqueductBlock.m_49796_((double)12.0, (double)10.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
        VoxelShape south = AqueductBlock.m_49796_((double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0);
        VoxelShape west = AqueductBlock.m_49796_((double)0.0, (double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0);
        VoxelShape[] directions = new VoxelShape[]{south, west, north, east};
        VoxelShape base = Shapes.m_83124_((VoxelShape)AqueductBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape[])new VoxelShape[]{AqueductBlock.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0), AqueductBlock.m_49796_((double)12.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), AqueductBlock.m_49796_((double)0.0, (double)10.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0), AqueductBlock.m_49796_((double)12.0, (double)10.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0)});
        for (int i = 0; i < SHAPES.length; ++i) {
            VoxelShape shape = base;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if ((i >> direction.m_122416_() & 1) != 0) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)directions[direction.m_122416_()]);
            }
            AqueductBlock.SHAPES[i] = shape;
        }
    }
}

