/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.StationaryBerryBushBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class WaterloggedBerryBushBlock
extends StationaryBerryBushBlock
implements IFluidLoggable {
    public static final FluidProperty FLUID = TFCBlockStateProperties.FRESH_WATER;

    public WaterloggedBerryBushBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] lifecycle, Supplier<ClimateRange> climateRange) {
        super(properties, productItem, lifecycle, climateRange);
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        BlockPos sourcePos = pos.m_7495_();
        ClimateRange range = (ClimateRange)this.climateRange.get();
        if (((FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty())).getFluid() == Fluids.f_76191_) {
            text.add((Component)Component.m_237115_((String)"tfc.tooltip.berry_bush.not_underwater"));
        }
        text.add(FarmlandBlock.getTemperatureTooltip(level, sourcePos, range, false));
    }

    @Override
    protected int getHydration(LevelAccessor level, BlockPos pos, BlockState state) {
        return ((FluidProperty.FluidKey)state.m_61143_((Property)FLUID)).getFluid() != Fluids.f_76191_ ? 100 : 0;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{this.getFluidProperty()}));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return state.m_60710_((LevelReader)level, currentPos) ? super.m_7417_(state, facing, facingState, level, currentPos, facingPos) : state.m_60819_().m_76188_();
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        state = FluidHelpers.fillWithFluid(state, context.m_43725_().m_6425_(context.m_8083_()).m_76152_());
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidLoggedState(state);
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    @Override
    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return super.m_6266_(state, level, pos) || Helpers.isBlock(level.m_8055_(pos.m_7495_()), TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON);
    }

    @Override
    protected BlockState getNewState(Level level, BlockPos pos) {
        return (BlockState)super.getNewState(level, pos).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(level.m_6425_(pos).m_76152_()));
    }

    @Override
    protected boolean canPlaceNewBushAt(Level level, BlockPos pos, BlockState placementState) {
        return placementState.m_60710_((LevelReader)level, pos) && FluidHelpers.isAirOrEmptyFluid(level.m_8055_(pos)) && this.getFluidProperty().canContain(level.m_6425_(pos).m_76152_());
    }
}

