/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.Plant;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeLeavesBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FruitTreeSaplingBlock
extends BushBlock
implements IForgeBlockExtension,
EntityBlockExtension,
HoeOverlayBlock {
    private static final IntegerProperty SAPLINGS = TFCBlockStateProperties.SAPLINGS;
    protected final Supplier<? extends Block> block;
    protected final Supplier<Integer> treeGrowthDays;
    private final ExtendedProperties properties;
    private final Supplier<ClimateRange> climateRange;
    private final Lifecycle[] stages;

    public static boolean maySplice(Level level, BlockPos pos, BlockState state) {
        BlockState below = level.m_8055_(pos.m_7495_());
        if (state.m_61138_((Property)SAPLINGS)) {
            int saplings = (Integer)state.m_61143_((Property)SAPLINGS);
            return Helpers.isBlock(below, TFCTags.Blocks.FRUIT_TREE_BRANCH) ? saplings < 3 : saplings < 4;
        }
        return Helpers.isBlock(below, TFCTags.Blocks.FRUIT_TREE_BRANCH) && state.m_60795_();
    }

    public FruitTreeSaplingBlock(ExtendedProperties properties, Supplier<? extends Block> block, int treeGrowthDays, Supplier<ClimateRange> climateRange, Lifecycle[] stages) {
        this(properties, block, () -> treeGrowthDays, climateRange, stages);
    }

    public FruitTreeSaplingBlock(ExtendedProperties properties, Supplier<? extends Block> block, Supplier<Integer> treeGrowthDays, Supplier<ClimateRange> climateRange, Lifecycle[] stages) {
        super(properties.properties());
        this.properties = properties;
        this.block = block;
        this.treeGrowthDays = treeGrowthDays;
        this.climateRange = climateRange;
        this.stages = stages;
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        ClimateRange range = this.climateRange.get();
        text.add(FarmlandBlock.getHydrationTooltip((LevelAccessor)level, pos, range, false, FruitTreeLeavesBlock.getHydration(level, pos)));
        text.add(FarmlandBlock.getAverageTemperatureTooltip(level, pos, range, false));
        if (!this.stages[Calendars.SERVER.getCalendarMonthOfYear().ordinal()].active()) {
            text.add((Component)Component.m_237115_((String)"tfc.tooltip.fruit_tree.sapling_wrong_month"));
        } else {
            text.add((Component)Component.m_237115_((String)"tfc.tooltip.fruit_tree.growing"));
        }
        if (FruitTreeSaplingBlock.maySplice(level, pos, state)) {
            text.add((Component)Component.m_237115_((String)"tfc.tooltip.fruit_tree.sapling_splice"));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int saplings = (Integer)state.m_61143_((Property)SAPLINGS);
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack off = player.m_21120_(InteractionHand.OFF_HAND);
        if (this.m_49966_().m_60734_().m_5456_() == held.m_41720_() && Helpers.isItem(off, TFCTags.Items.KNIVES) && FruitTreeSaplingBlock.maySplice(level, pos, state)) {
            held.m_41774_(1);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SAPLINGS, (Comparable)Integer.valueOf(saplings + 1)));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SeasonalPlantBlock.PLANT_SHAPE;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        TickCounterBlockEntity counter;
        BlockEntity blockEntity;
        if (this.stages[Calendars.SERVER.getCalendarMonthOfYear().ordinal()].active() && (blockEntity = level.m_7702_(pos)) instanceof TickCounterBlockEntity && (double)(counter = (TickCounterBlockEntity)blockEntity).getTicksSinceUpdate() > (double)(24000 * this.getTreeGrowthDays()) * (Double)TFCConfig.SERVER.globalFruitSaplingGrowthModifier.get()) {
            int hydration = FruitTreeLeavesBlock.getHydration((Level)level, pos);
            float temp = Climate.getAverageTemperature((Level)level, pos);
            if (!this.climateRange.get().checkBoth(hydration, temp, false)) {
                level.m_46597_(pos, ((Block)TFCBlocks.PLANTS.get(Plant.DEAD_BUSH).get()).m_49966_());
            } else {
                this.createTree((Level)level, pos, state, random);
            }
        }
    }

    public void createTree(Level level, BlockPos pos, BlockState state, RandomSource random) {
        int internalSapling;
        boolean onBranch = Helpers.isBlock(level.m_8055_(pos.m_7495_()), TFCTags.Blocks.FRUIT_TREE_BRANCH);
        int n = internalSapling = onBranch ? 3 : (Integer)state.m_61143_((Property)SAPLINGS);
        if (internalSapling == 1 && random.m_188499_()) {
            ++internalSapling;
        }
        level.m_46597_(pos, (BlockState)((BlockState)((BlockState)this.block.get().m_49966_().m_61124_((Property)PipeBlock.f_55153_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TFCBlockStateProperties.SAPLINGS, (Comparable)Integer.valueOf(internalSapling))).m_61124_((Property)TFCBlockStateProperties.STAGE_3, (Comparable)Integer.valueOf(onBranch ? 1 : 0)));
        TickCounterBlockEntity.reset(level, pos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos downPos = pos.m_7495_();
        BlockState downState = level.m_8055_(downPos);
        if (Helpers.isBlock(downState, TFCTags.Blocks.FRUIT_TREE_BRANCH)) {
            if ((Integer)downState.m_61143_((Property)FruitTreeBranchBlock.STAGE) > 1) {
                return false;
            }
            for (Direction d : Direction.Plane.HORIZONTAL) {
                if (!((Boolean)downState.m_61143_((Property)PipeBlock.f_55154_.get(d))).booleanValue()) continue;
                return true;
            }
            return false;
        }
        return super.m_7898_(state, level, pos) || Helpers.isBlock(downState, TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TickCounterBlockEntity.reset(level, pos);
        super.m_6402_(level, pos, state, placer, stack);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{SAPLINGS}));
    }

    public int getTreeGrowthDays() {
        return this.treeGrowthDays.get();
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }
}

