/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.PipePlantBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeLeavesBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeSaplingBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FruitTreeBranchBlock
extends PipePlantBlock
implements HoeOverlayBlock {
    public static final IntegerProperty STAGE = TFCBlockStateProperties.STAGE_3;
    private final Supplier<ClimateRange> climateRange;

    public FruitTreeBranchBlock(ExtendedProperties properties, Supplier<ClimateRange> climateRange) {
        super(0.25f, properties);
        this.climateRange = climateRange;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55148_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55150_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55151_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55153_, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        ClimateRange range = this.climateRange.get();
        text.add(FarmlandBlock.getHydrationTooltip((LevelAccessor)level, pos, range, false, FruitTreeLeavesBlock.getHydration(level, pos)));
        text.add(FarmlandBlock.getAverageTemperatureTooltip(level, pos, range, false));
        if (FruitTreeSaplingBlock.maySplice(level, pos.m_7494_(), level.m_8055_(pos.m_7494_()))) {
            text.add((Component)Component.m_237115_((String)"tfc.tooltip.fruit_tree.sapling_splice"));
        }
        this.addExtraInfo(text);
    }

    public void addExtraInfo(List<Component> text) {
        text.add((Component)Component.m_237115_((String)"tfc.tooltip.fruit_tree.done_growing"));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{STAGE}));
    }

    @Override
    protected boolean testDown(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.FRUIT_TREE_BRANCH) || Helpers.isBlock(state, TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    @Override
    protected boolean testUp(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.FRUIT_TREE_BRANCH) || Helpers.isBlock(state, TFCTags.Blocks.FRUIT_TREE_SAPLING);
    }

    @Override
    protected boolean testHorizontal(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.FRUIT_TREE_BRANCH);
    }

    @Override
    protected boolean canGrowLongSideways() {
        return true;
    }
}

