/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.awt.Color;
import java.util.Locale;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.BananaPlantBlock;
import net.dries007.tfc.common.blocks.plant.fruit.BananaSaplingBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeLeavesBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeSaplingBlock;
import net.dries007.tfc.common.blocks.plant.fruit.GrowingFruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingCaneBlock;
import net.dries007.tfc.common.blocks.plant.fruit.StationaryBerryBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.WaterloggedBerryBushBlock;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public final class FruitBlocks {
    private static final Lifecycle[] CRANBERRY_STAGES = new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT};
    private static final Lifecycle[] BANANA_STAGES = new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT};

    public static WaterloggedBerryBushBlock createCranberry() {
        return new WaterloggedBerryBushBlock(ExtendedProperties.of(MapColor.f_283915_).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.f_56757_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)Food.CRANBERRY), CRANBERRY_STAGES, ClimateRanges.CRANBERRY_BUSH);
    }

    public static Block createBananaSapling() {
        return new BananaSaplingBlock(ExtendedProperties.of(MapColor.f_283915_).noCollission().randomTicks().strength(0.0f).sound(SoundType.f_56740_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER).flammableLikeLeaves(), BANANA_STAGES, (Supplier<? extends Block>)TFCBlocks.BANANA_PLANT, (Supplier<Integer>)TFCConfig.SERVER.bananaSaplingGrowthDays);
    }

    public static Block createPottedBananaSapling() {
        return new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, TFCBlocks.BANANA_SAPLING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50229_));
    }

    public static Block createBananaPlant() {
        return new BananaPlantBlock(ExtendedProperties.of(MapColor.f_283915_).strength(0.5f).sound(SoundType.f_56740_).randomTicks().noOcclusion().forceSolidOn().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).serverTicks(BerryBushBlockEntity::serverTick).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)Food.BANANA), BANANA_STAGES);
    }

    public static enum Tree implements StringRepresentable
    {
        CHERRY(Food.CHERRY, 8, new Lifecycle[]{Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY}, new Color(251, 135, 255).getRGB()),
        GREEN_APPLE(Food.GREEN_APPLE, 10, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(252, 171, 255).getRGB()),
        LEMON(Food.LEMON, 8, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(215, 137, 217).getRGB()),
        OLIVE(Food.OLIVE, 12, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(206, 198, 207).getRGB()),
        ORANGE(Food.ORANGE, 7, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(251, 242, 252).getRGB()),
        PEACH(Food.PEACH, 11, new Lifecycle[]{Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY}, new Color(230, 126, 188).getRGB()),
        PLUM(Food.PLUM, 8, new Lifecycle[]{Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(165, 70, 189).getRGB()),
        RED_APPLE(Food.RED_APPLE, 10, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(252, 171, 255).getRGB());

        private final Food product;
        private final Lifecycle[] stages;
        private final String serializedName;
        private final int treeGrowthDays;
        private final int floweringLeavesColor;

        private Tree(Food product, int treeGrowthDays, Lifecycle[] stages, int floweringLeavesColor) {
            this.product = product;
            this.stages = stages;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
            this.treeGrowthDays = treeGrowthDays;
            this.floweringLeavesColor = floweringLeavesColor;
        }

        public Block createSapling() {
            return new FruitTreeSaplingBlock(ExtendedProperties.of(MapColor.f_283915_).noCollission().randomTicks().strength(0.0f).sound(SoundType.f_56740_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER).flammableLikeLeaves(), (Supplier<? extends Block>)((Supplier)TFCBlocks.FRUIT_TREE_GROWING_BRANCHES.get((Object)this)), this::daysToGrow, ClimateRanges.FRUIT_TREES.get((Object)this), this.stages);
        }

        public Block createPottedSapling() {
            return new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, (Supplier)TFCBlocks.FRUIT_TREE_SAPLINGS.get((Object)this), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50229_));
        }

        public Block createLeaves() {
            return new FruitTreeLeavesBlock(ExtendedProperties.of().mapColor(FruitTreeLeavesBlock::getMapColor).strength(0.5f).sound(SoundType.f_56740_).randomTicks().noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).serverTicks(BerryBushBlockEntity::serverTick).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)this.product), this.stages, ClimateRanges.FRUIT_TREES.get((Object)this), this.floweringLeavesColor);
        }

        public Block createBranch() {
            return new FruitTreeBranchBlock(ExtendedProperties.of(MapColor.f_283825_).sound(SoundType.f_56756_).randomTicks().strength(1.0f).pushReaction(PushReaction.DESTROY).flammableLikeLogs(), ClimateRanges.FRUIT_TREES.get((Object)this));
        }

        public Block createGrowingBranch() {
            return new GrowingFruitTreeBranchBlock(ExtendedProperties.of(MapColor.f_283825_).sound(SoundType.f_56756_).randomTicks().strength(1.0f).pushReaction(PushReaction.DESTROY).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER).flammableLikeLogs(), (Supplier)TFCBlocks.FRUIT_TREE_BRANCHES.get((Object)this), (Supplier)TFCBlocks.FRUIT_TREE_LEAVES.get((Object)this), ClimateRanges.FRUIT_TREES.get((Object)this));
        }

        public int daysToGrow() {
            return (Integer)TFCConfig.SERVER.fruitSaplingGrowthDays.get((Object)this).get();
        }

        public int defaultDaysToGrow() {
            return this.treeGrowthDays;
        }

        public String m_7912_() {
            return this.serializedName;
        }
    }

    public static enum StationaryBush {
        SNOWBERRY(Food.SNOWBERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT),
        BUNCHBERRY(Food.BUNCHBERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT),
        GOOSEBERRY(Food.GOOSEBERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT),
        CLOUDBERRY(Food.CLOUDBERRY, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT),
        STRAWBERRY(Food.STRAWBERRY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY),
        WINTERGREEN_BERRY(Food.WINTERGREEN_BERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING);

        private final Food product;
        private final Lifecycle[] stages;

        private StationaryBush(Food product, Lifecycle ... stages) {
            this.product = product;
            this.stages = stages;
        }

        public Block create() {
            return new StationaryBerryBushBlock(ExtendedProperties.of(MapColor.f_283915_).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.f_56757_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).serverTicks(BerryBushBlockEntity::serverTick).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)this.product), this.stages, ClimateRanges.STATIONARY_BUSHES.get((Object)this));
        }
    }

    public static enum SpreadingBush {
        BLACKBERRY(Food.BLACKBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, 4),
        RASPBERRY(Food.RASPBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT}, 3),
        BLUEBERRY(Food.BLUEBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, 2),
        ELDERBERRY(Food.ELDERBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, 3);

        private final Food product;
        private final Lifecycle[] stages;
        private final int maxHeight;

        private SpreadingBush(Food product, Lifecycle[] stages, int maxHeight) {
            this.product = product;
            this.stages = stages;
            this.maxHeight = maxHeight;
        }

        public Block createBush() {
            return new SpreadingBushBlock(ExtendedProperties.of(MapColor.f_283915_).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.f_56757_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).serverTicks(BerryBushBlockEntity::serverTick).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)this.product), this.stages, (Supplier)TFCBlocks.SPREADING_CANES.get((Object)this), this.maxHeight, ClimateRanges.SPREADING_BUSHES.get((Object)this));
        }

        public Block createCane() {
            return new SpreadingCaneBlock(ExtendedProperties.of(MapColor.f_283915_).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.f_56757_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).serverTicks(BerryBushBlockEntity::serverTick).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)this.product), this.stages, (Supplier)TFCBlocks.SPREADING_BUSHES.get((Object)this), this.maxHeight, ClimateRanges.SPREADING_BUSHES.get((Object)this));
        }
    }
}

