/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.ClimbingCropBlock;
import net.dries007.tfc.common.blocks.crop.DeadClimbingCropBlock;
import net.dries007.tfc.common.blocks.crop.DeadCropBlock;
import net.dries007.tfc.common.blocks.crop.DefaultCropBlock;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.FloodedCropBlock;
import net.dries007.tfc.common.blocks.crop.FloodedDeadCropBlock;
import net.dries007.tfc.common.blocks.crop.FloodedWildCropBlock;
import net.dries007.tfc.common.blocks.crop.PickableCropBlock;
import net.dries007.tfc.common.blocks.crop.SpreadingCropBlock;
import net.dries007.tfc.common.blocks.crop.WildCropBlock;
import net.dries007.tfc.common.blocks.crop.WildDoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.WildSpreadingCropBlock;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.MapColor;

public final class Crop
extends Enum<Crop>
implements StringRepresentable {
    public static final /* enum */ Crop BARLEY = new Crop(FarmlandBlockEntity.NutrientType.NITROGEN, 8);
    public static final /* enum */ Crop OAT = new Crop(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, 8);
    public static final /* enum */ Crop RYE = new Crop(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, 8);
    public static final /* enum */ Crop MAIZE = new Crop(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, 3, 3, false);
    public static final /* enum */ Crop WHEAT = new Crop(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, 8);
    public static final /* enum */ Crop RICE = new Crop(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, 8, true);
    public static final /* enum */ Crop BEET = new Crop(FarmlandBlockEntity.NutrientType.POTASSIUM, 6);
    public static final /* enum */ Crop CABBAGE = new Crop(FarmlandBlockEntity.NutrientType.NITROGEN, 6);
    public static final /* enum */ Crop CARROT = new Crop(FarmlandBlockEntity.NutrientType.POTASSIUM, 5);
    public static final /* enum */ Crop GARLIC = new Crop(FarmlandBlockEntity.NutrientType.NITROGEN, 5);
    public static final /* enum */ Crop GREEN_BEAN = new Crop(FarmlandBlockEntity.NutrientType.NITROGEN, 4, 4, true);
    public static final /* enum */ Crop POTATO = new Crop(FarmlandBlockEntity.NutrientType.POTASSIUM, 7);
    public static final /* enum */ Crop ONION = new Crop(FarmlandBlockEntity.NutrientType.NITROGEN, 7);
    public static final /* enum */ Crop SOYBEAN = new Crop(FarmlandBlockEntity.NutrientType.NITROGEN, 7);
    public static final /* enum */ Crop SQUASH = new Crop(FarmlandBlockEntity.NutrientType.POTASSIUM, 8);
    public static final /* enum */ Crop SUGARCANE = new Crop(FarmlandBlockEntity.NutrientType.POTASSIUM, 4, 4, false);
    public static final /* enum */ Crop TOMATO = new Crop(FarmlandBlockEntity.NutrientType.POTASSIUM, 4, 4, true);
    public static final /* enum */ Crop JUTE = new Crop(FarmlandBlockEntity.NutrientType.POTASSIUM, 3, 3, false);
    public static final /* enum */ Crop PAPYRUS = new Crop(FarmlandBlockEntity.NutrientType.POTASSIUM, 3, 3, false);
    public static final /* enum */ Crop PUMPKIN = new Crop(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, 8, () -> TFCBlocks.PUMPKIN);
    public static final /* enum */ Crop MELON = new Crop(FarmlandBlockEntity.NutrientType.PHOSPHOROUS, 8, () -> TFCBlocks.MELON);
    public static final /* enum */ Crop RED_BELL_PEPPER = new Crop(FarmlandBlockEntity.NutrientType.POTASSIUM, 7, () -> (Supplier)TFCItems.FOOD.get((Object)Food.GREEN_BELL_PEPPER), () -> (Supplier)TFCItems.FOOD.get((Object)Food.RED_BELL_PEPPER));
    public static final /* enum */ Crop YELLOW_BELL_PEPPER = new Crop(FarmlandBlockEntity.NutrientType.POTASSIUM, 7, () -> (Supplier)TFCItems.FOOD.get((Object)Food.GREEN_BELL_PEPPER), () -> (Supplier)TFCItems.FOOD.get((Object)Food.YELLOW_BELL_PEPPER));
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final FarmlandBlockEntity.NutrientType primaryNutrient;
    private final Supplier<Block> factory;
    private final Supplier<Block> deadFactory;
    private final Supplier<Block> wildFactory;
    private static final /* synthetic */ Crop[] $VALUES;

    public static Crop[] values() {
        return (Crop[])$VALUES.clone();
    }

    public static Crop valueOf(String name) {
        return Enum.valueOf(Crop.class, name);
    }

    private static ExtendedProperties doubleCrop() {
        return Crop.dead().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.CROP).serverTicks(CropBlockEntity::serverTickBottomPartOnly);
    }

    private static ExtendedProperties crop() {
        return Crop.dead().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.CROP).serverTicks(CropBlockEntity::serverTick);
    }

    private static ExtendedProperties dead() {
        return ExtendedProperties.of(MapColor.f_283915_).noCollission().randomTicks().strength(0.4f).sound(SoundType.f_56758_).flammable(60, 30);
    }

    private Crop(FarmlandBlockEntity.NutrientType primaryNutrient, int singleBlockStages) {
        this(primaryNutrient, self -> DefaultCropBlock.create(Crop.crop(), singleBlockStages, self), (Crop self) -> new DeadCropBlock(Crop.dead(), self.getClimateRange()), (Crop self) -> new WildCropBlock(Crop.dead().randomTicks()));
    }

    private Crop(FarmlandBlockEntity.NutrientType primaryNutrient, int spreadingSingleBlockStages, Supplier<Supplier<? extends Block>> fruit) {
        this(primaryNutrient, self -> SpreadingCropBlock.create(Crop.crop(), spreadingSingleBlockStages, self, fruit), (Crop self) -> new DeadCropBlock(Crop.dead(), self.getClimateRange()), (Crop self) -> new WildSpreadingCropBlock(Crop.dead().randomTicks(), fruit));
    }

    private Crop(FarmlandBlockEntity.NutrientType primaryNutrient, int spreadingSingleBlockStages, Supplier<Supplier<? extends Item>> fruit1, Supplier<Supplier<? extends Item>> fruit2) {
        this(primaryNutrient, self -> PickableCropBlock.create(Crop.crop(), spreadingSingleBlockStages, self, fruit1, fruit2), (Crop self) -> new DeadCropBlock(Crop.dead(), self.getClimateRange()), (Crop self) -> new WildCropBlock(Crop.dead().randomTicks()));
    }

    private Crop(FarmlandBlockEntity.NutrientType primaryNutrient, int floodedSingleBlockStages, boolean flooded) {
        this(primaryNutrient, self -> FloodedCropBlock.create(Crop.crop(), floodedSingleBlockStages, self), (Crop self) -> new FloodedDeadCropBlock(Crop.dead(), self.getClimateRange()), (Crop self) -> new FloodedWildCropBlock(Crop.dead().randomTicks()));
        assert (flooded);
    }

    private Crop(FarmlandBlockEntity.NutrientType primaryNutrient, int doubleBlockBottomStages, int doubleBlockTopStages, boolean requiresStick) {
        this(primaryNutrient, requiresStick ? self -> ClimbingCropBlock.create(Crop.doubleCrop(), doubleBlockBottomStages, doubleBlockTopStages, self) : self -> DoubleCropBlock.create(Crop.doubleCrop(), doubleBlockBottomStages, doubleBlockTopStages, self), (Crop self) -> new DeadClimbingCropBlock(Crop.dead(), self.getClimateRange()), (Crop self) -> new WildDoubleCropBlock(Crop.dead().randomTicks()));
    }

    private Crop(FarmlandBlockEntity.NutrientType primaryNutrient, Function<Crop, Block> factory, Function<Crop, Block> deadFactory, Function<Crop, Block> wildFactory) {
        this.primaryNutrient = primaryNutrient;
        this.factory = () -> (Block)factory.apply(this);
        this.deadFactory = () -> (Block)deadFactory.apply(this);
        this.wildFactory = () -> (Block)wildFactory.apply(this);
    }

    public String m_7912_() {
        return this.serializedName;
    }

    public Block create() {
        return this.factory.get();
    }

    public Block createDead() {
        return this.deadFactory.get();
    }

    public Block createWild() {
        return this.wildFactory.get();
    }

    public FarmlandBlockEntity.NutrientType getPrimaryNutrient() {
        return this.primaryNutrient;
    }

    public Supplier<ClimateRange> getClimateRange() {
        return ClimateRanges.CROPS.get((Object)this);
    }

    private static /* synthetic */ Crop[] $values() {
        return new Crop[]{BARLEY, OAT, RYE, MAIZE, WHEAT, RICE, BEET, CABBAGE, CARROT, GARLIC, GREEN_BEAN, POTATO, ONION, SOYBEAN, SQUASH, SUGARCANE, TOMATO, JUTE, PAPYRUS, PUMPKIN, MELON, RED_BELL_PEPPER, YELLOW_BELL_PEPPER};
    }

    static {
        $VALUES = Crop.$values();
    }
}

