/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCMagmaBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class TFCBubbleColumnBlock
extends BubbleColumnBlock {
    private final Supplier<? extends Fluid> fluid;

    public static void updateColumnForFluid(LevelAccessor level, BlockPos pos) {
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        BlockPos.MutableBlockPos cursor = abovePos.m_122032_();
        BlockState beforeState = aboveState;
        while (TFCBubbleColumnBlock.m_152715_(beforeState)) {
            if (!level.m_7731_((BlockPos)cursor, TFCBubbleColumnBlock.m_152717_(beforeState), 2)) {
                return;
            }
            cursor.m_122173_(Direction.UP);
            beforeState = level.m_8055_((BlockPos)cursor);
        }
    }

    public static boolean m_152715_(BlockState state) {
        return state.m_60734_() instanceof TFCBubbleColumnBlock || FluidHelpers.isAirOrEmptyFluid(state) && TFCBubbleColumnBlock.canExistIn(state.m_60819_().m_76152_());
    }

    public static boolean canExistIn(Fluid fluid) {
        return fluid == Fluids.f_76193_.m_5613_() || fluid == TFCFluids.SALT_WATER.getSource();
    }

    public static BlockState m_152717_(BlockState state) {
        return (state.m_60819_().m_76152_() == Fluids.f_76193_.m_5613_() ? (Block)TFCBlocks.FRESHWATER_BUBBLE_COLUMN.get() : (Block)TFCBlocks.SALTWATER_BUBBLE_COLUMN.get()).m_49966_();
    }

    public TFCBubbleColumnBlock(BlockBehaviour.Properties properties, Supplier<? extends Fluid> fluid) {
        super(properties);
        this.fluid = fluid;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!Helpers.isEntity(entity, TFCTags.Entities.BUBBLE_COLUMN_IMMUNE)) {
            super.m_7892_(state, level, pos, entity);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        TFCBubbleColumnBlock.updateColumnForFluid((LevelAccessor)level, pos);
    }

    public FluidState m_5888_(BlockState state) {
        return this.getFluid().m_76145_();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_((BlockState)state.m_61124_((Property)f_50956_, (Comparable)Boolean.valueOf(false)), level, pos, random);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        Fluid fluid = this.getFluid();
        level.m_186469_(pos, fluid, fluid.m_6718_((LevelReader)level));
        if (!state.m_60710_((LevelReader)level, pos) || facing == Direction.DOWN || facing == Direction.UP && !(facingState.m_60734_() instanceof TFCBubbleColumnBlock) && TFCBubbleColumnBlock.m_152715_(facingState)) {
            level.m_186460_(pos, (Block)this, 5);
        }
        return state;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        return below.m_60734_() instanceof TFCBubbleColumnBlock || below.m_60734_() instanceof TFCMagmaBlock;
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        return new ItemStack((ItemLike)this.getFluid().m_6859_());
    }

    public Fluid getFluid() {
        return this.fluid.get();
    }
}

