/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.RiverWaterBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rotation.WaterWheelBlock;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.Rotation;
import net.dries007.tfc.util.rotation.SourceNode;
import net.dries007.tfc.world.river.Flow;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class WaterWheelBlockEntity
extends TickableBlockEntity
implements RotatingBlockEntity {
    public static final float MAX_SPEED = 0.07853982f;
    public static final float LERP_SPEED = 1.9634955E-4f;
    private static final float MAX_FLOW = 10.0f;
    private final SourceNode node;
    private boolean invalid;
    private float targetSpeed;

    public static void serverTick(Level level, BlockPos pos, BlockState state, WaterWheelBlockEntity wheel) {
        wheel.checkForLastTickSync();
        WaterWheelBlockEntity.clientTick(level, pos, state, wheel);
        if (level.m_46467_() % 40L == 0L) {
            Float maybeFlowRate = WaterWheelBlockEntity.calculateFlowRateAndObstruction(level, pos, (Direction.Axis)state.m_61143_(WaterWheelBlock.AXIS));
            if (maybeFlowRate == null) {
                level.m_46961_(pos, true);
            } else {
                wheel.targetSpeed = maybeFlowRate.floatValue() * 0.07853982f / 10.0f;
                wheel.markForSync();
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, WaterWheelBlockEntity wheel) {
        float targetSpeed = wheel.targetSpeed;
        Rotation.Tickable rotation = wheel.node.rotation();
        float currentSpeed = rotation.speed();
        float nextSpeed = targetSpeed > currentSpeed ? Math.min(targetSpeed, currentSpeed + 1.9634955E-4f) : Math.max(targetSpeed, currentSpeed - 1.9634955E-4f);
        rotation.tick();
        rotation.setSpeed(nextSpeed);
    }

    @Nullable
    public static Float calculateFlowRateAndObstruction(Level level, BlockPos pos, Direction.Axis axis) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        float contributingFlow = 0.0f;
        float obstructionFlow = 0.0f;
        for (int dH = -2; dH <= 2; ++dH) {
            for (int dy = -2; dy <= 2; ++dy) {
                if (dH == 0 && dy == 0) continue;
                cursor.m_122154_((Vec3i)pos, axis == Direction.Axis.X ? 0 : dH, dy, axis == Direction.Axis.Z ? 0 : dH);
                BlockState state = level.m_8055_((BlockPos)cursor);
                if (state.m_60734_() == TFCBlocks.RIVER_WATER.get()) {
                    Flow flow = (Flow)((Object)state.m_61143_(RiverWaterBlock.FLOW));
                    float flowRate = (float)(axis == Direction.Axis.X ? -flow.getVector().f_82481_ : flow.getVector().f_82479_);
                    if (dy < 0) {
                        contributingFlow += flowRate;
                        continue;
                    }
                    obstructionFlow += Math.abs(flowRate);
                    continue;
                }
                if (state.m_60734_() == Blocks.f_49990_) {
                    obstructionFlow += dy < 0 ? 0.25f : 1.0f;
                    continue;
                }
                if (state.m_60795_() || state.m_60812_((BlockGetter)level, (BlockPos)cursor).m_83281_()) continue;
                return null;
            }
        }
        if (contributingFlow > 0.0f) {
            return Float.valueOf(-Math.max(0.0f, contributingFlow - obstructionFlow));
        }
        return Float.valueOf(-Math.min(0.0f, contributingFlow + obstructionFlow));
    }

    public WaterWheelBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.WATER_WHEEL.get(), pos, state);
    }

    public WaterWheelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        final Direction.Axis axis = (Direction.Axis)state.m_61143_(WaterWheelBlock.AXIS);
        this.targetSpeed = 0.0f;
        this.invalid = false;
        this.node = new SourceNode(pos, Node.ofAxis(axis), Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), 0.0f){

            @Override
            public String toString() {
                return "WaterWheel[pos=%s, axis=%s]".formatted(this.pos(), axis);
            }
        };
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.node.rotation().saveToTag(tag);
        tag.m_128379_("invalid", this.invalid);
        tag.m_128350_("targetSpeed", this.targetSpeed);
    }

    @Override
    protected void loadAdditional(CompoundTag tag) {
        super.loadAdditional(tag);
        this.node.rotation().loadFromTag(tag);
        this.invalid = tag.m_128471_("invalid");
        this.targetSpeed = tag.m_128457_("targetSpeed");
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD_SOURCE);
    }

    @Override
    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    @Override
    public void markAsInvalidInNetwork() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalidInNetwork() {
        return this.invalid;
    }

    @Override
    public Node getRotationNode() {
        return this.node;
    }
}

