/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.function.Consumer;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.devices.SheetPileBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class SheetPileBlockEntity
extends TFCBlockEntity {
    private final ItemStack[] stacks = new ItemStack[6];
    private final Metal[] cachedMetals = new Metal[6];
    private static final DirectionProperty FACING = SheetPileBlock.FACING;
    private static final BooleanProperty MIRROR = SheetPileBlock.MIRROR;

    private int faceToIndex(Direction face) {
        BlockState state = this.m_58900_();
        if (face.m_122434_() == Direction.Axis.Y) {
            return face.ordinal();
        }
        Mirror mirror = (Boolean)state.m_61143_((Property)MIRROR) != false ? Mirror.FRONT_BACK : Mirror.NONE;
        Rotation rot = switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.EAST -> Rotation.COUNTERCLOCKWISE_90;
            case Direction.WEST -> Rotation.CLOCKWISE_90;
            default -> Rotation.NONE;
        };
        return mirror.m_54848_(rot.m_55954_(face)).ordinal();
    }

    public SheetPileBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.SHEET_PILE.get(), pos, state);
        Arrays.fill(this.stacks, ItemStack.f_41583_);
    }

    public void addSheet(Direction direction, ItemStack stack) {
        int index = this.faceToIndex(direction);
        this.stacks[index] = stack;
        this.cachedMetals[index] = null;
        this.markForSync();
    }

    public ItemStack removeSheet(Direction direction) {
        int index = this.faceToIndex(direction);
        ItemStack stack = this.stacks[index];
        this.stacks[index] = ItemStack.f_41583_;
        this.cachedMetals[index] = null;
        this.markForSync();
        return stack;
    }

    public ItemStack getSheet(Direction direction) {
        return this.stacks[this.faceToIndex(direction)].m_41777_();
    }

    public Metal getOrCacheMetal(Direction direction) {
        int index = this.faceToIndex(direction);
        ItemStack stack = this.stacks[index];
        Metal metal = this.cachedMetals[index];
        if (metal == null) {
            metal = Metal.getFromSheet(stack);
            if (metal == null) {
                metal = Metal.unknown();
            }
            this.cachedMetals[index] = metal;
        }
        return metal;
    }

    public void setAllMetalsFromOutsideWorld(Metal metal) {
        Arrays.fill(this.cachedMetals, metal);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("stacks", (Tag)Helpers.writeItemStacksToNbt(this.stacks));
        super.m_183515_(tag);
    }

    @Override
    protected void loadAdditional(CompoundTag tag) {
        Helpers.readItemStacksFromNbt(this.stacks, tag.m_128437_("stacks", 10));
        Arrays.fill(this.cachedMetals, null);
        super.loadAdditional(tag);
    }

    public void fillTooltip(Consumer<Component> tooltip) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        for (Metal metal2 : this.cachedMetals) {
            if (metal2 == null) continue;
            map.mergeInt((Object)metal2, 1, Integer::sum);
        }
        map.forEach((metal, ct) -> tooltip.accept((Component)Component.m_237113_((String)(ct + "x ")).m_7220_((Component)metal.getDisplayName())));
    }
}

