/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Predicate;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotationSinkBlockEntity;
import net.dries007.tfc.common.blocks.devices.QuernBlock;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.QuernRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.SinkNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class QuernBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements RotationSinkBlockEntity {
    public static final int SLOT_HANDSTONE = 0;
    public static final int SLOT_INPUT = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int MANUAL_TICKS = 90;
    public static final float MANUAL_SPEED = 0.06981317f;
    private static final float MANUAL_RECIPE_PER_TICK = 1.0f;
    private static final float NETWORK_RECIPE_PER_SPEED = 14.323944f;
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.quern");
    private final SinkNode node;
    private float recipeTimer = 0.0f;
    private boolean needsStateUpdate = false;
    private float previousRotationDirection = 1.0f;
    private float previousRotationSpeed = 0.06981317f;

    public static void serverTick(Level level, BlockPos pos, BlockState state, QuernBlockEntity quern) {
        ItemStack inputStack;
        ServerLevel serverLevel = (ServerLevel)level;
        quern.checkForLastTickSync();
        if (quern.needsStateUpdate) {
            quern.updateHandstone();
        }
        boolean wasGrinding = quern.recipeTimer > 0.0f;
        QuernBlockEntity.clientTick(level, pos, state, quern);
        if (wasGrinding && !(inputStack = ((ItemStackHandler)quern.inventory).getStackInSlot(1)).m_41619_()) {
            QuernBlockEntity.sendParticle(serverLevel, pos, inputStack, 1);
        }
        if (wasGrinding && quern.recipeTimer <= 0.0f) {
            quern.finishGrinding();
            Helpers.playSound(level, pos, SoundEvents.f_11682_);
            ItemStack handstone = ((ItemStackHandler)quern.inventory).getStackInSlot(0);
            ItemStack undamagedHandstoneStack = handstone.m_41777_();
            Helpers.damageItem(handstone, 1);
            if (!quern.hasHandstone()) {
                Helpers.playSound(level, pos, SoundEvents.f_12442_);
                Helpers.playSound(level, pos, SoundEvents.f_12018_);
                QuernBlockEntity.sendParticle(serverLevel, pos, undamagedHandstoneStack, 15);
            }
            quern.setAndUpdateSlots(0);
            if (quern.isConnectedToNetwork()) {
                quern.startGrinding();
            }
        }
        if (quern.isConnectedToNetwork() && !quern.isGrinding() && level.m_46467_() % 10L == 0L) {
            quern.startGrinding();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, QuernBlockEntity quern) {
        if (quern.recipeTimer > 0.0f) {
            if (quern.node.rotation() != null) {
                quern.previousRotationDirection = quern.node.rotation().direction() == Direction.UP ? 1.0f : -1.0f;
                quern.previousRotationSpeed = quern.getRotationSpeed();
            }
            quern.recipeTimer = quern.recipeTimer - (quern.isConnectedToNetwork() ? quern.getRotationSpeed() * 14.323944f : 1.0f);
        }
    }

    private static void sendParticle(ServerLevel level, BlockPos pos, ItemStack item, int count) {
        level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, item), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5, count, (double)Helpers.triangle(level.f_46441_) / 2.0, level.f_46441_.m_188500_() / 4.0, (double)Helpers.triangle(level.f_46441_) / 2.0, (double)0.15f);
    }

    public QuernBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.QUERN.get(), pos, state, QuernBlockEntity.defaultInventory(3), NAME);
        this.node = new SinkNode(pos, Direction.UP){

            @Override
            public String toString() {
                return "Quern[pos=%s]".formatted(this.pos());
            }
        };
        if (((Boolean)Helpers.getValueOrDefault(TFCConfig.SERVER.quernEnableAutomation)).booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(1, 0), (Predicate<Direction>)Direction.Plane.HORIZONTAL).on(new PartialItemHandler(this.inventory).extract(2), Direction.DOWN);
        }
    }

    public void updateHandstone() {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        BlockState newState = Helpers.setProperty(state, QuernBlock.HAS_HANDSTONE, this.hasHandstone());
        if (this.hasHandstone() != ((Boolean)state.m_61143_((Property)QuernBlock.HAS_HANDSTONE)).booleanValue()) {
            this.f_58857_.m_46597_(this.f_58858_, newState);
        }
        this.needsStateUpdate = false;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsStateUpdate = true;
        this.markForSync();
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return slot == 0 ? 1 : 64;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return slot != 0 || Helpers.isItem(stack.m_41720_(), TFCTags.Items.HANDSTONE);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.recipeTimer = nbt.m_128457_("recipeTimer");
        super.loadAdditional(nbt);
        this.needsStateUpdate = true;
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128350_("recipeTimer", this.recipeTimer);
        super.m_183515_(nbt);
    }

    @Override
    public boolean canInteractWith(Player player) {
        return super.canInteractWith(player) && this.recipeTimer <= 0.0f && !this.isConnectedToNetwork();
    }

    public boolean isGrinding() {
        return this.recipeTimer > 0.0f;
    }

    public boolean hasHandstone() {
        return !((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_();
    }

    public boolean startGrinding() {
        ItemStackInventory wrapper;
        QuernRecipe recipe;
        assert (this.f_58857_ != null);
        ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(1);
        if (!inputStack.m_41619_() && this.hasHandstone() && (recipe = QuernRecipe.getRecipe(this.f_58857_, wrapper = new ItemStackInventory(inputStack))) != null && recipe.matches(wrapper, this.f_58857_)) {
            this.recipeTimer = 90.0f;
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)TFCSounds.QUERN_DRAG.get(), SoundSource.BLOCKS, 1.0f, 1.0f + (this.f_58857_.f_46441_.m_188501_() - this.f_58857_.f_46441_.m_188501_()) / 16.0f);
            this.markForSync();
            this.previousRotationDirection = 1.0f;
            this.previousRotationSpeed = 0.06981317f;
            return true;
        }
        return false;
    }

    @Override
    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD);
    }

    @Override
    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    @Override
    public Node getRotationNode() {
        return this.node;
    }

    public float getRotationSpeed() {
        return this.node.rotation() != null ? Mth.m_14154_((float)this.node.rotation().speed()) : (this.isGrinding() ? this.previousRotationSpeed : 0.0f);
    }

    @Override
    public float getRotationAngle(float partialTick) {
        return this.isConnectedToNetwork() ? RotationSinkBlockEntity.super.getRotationAngle(partialTick) : -this.recipeTimer * this.previousRotationSpeed * this.previousRotationDirection;
    }

    public boolean isConnectedToNetwork() {
        return this.node.rotation() != null && this.hasHandstone();
    }

    public void setHandstoneFromOutsideWorld() {
        ((ItemStackHandler)this.inventory).setStackInSlot(0, new ItemStack((ItemLike)TFCItems.HANDSTONE.get()));
    }

    private void finishGrinding() {
        ItemStackInventory wrapper;
        QuernRecipe recipe;
        assert (this.f_58857_ != null);
        ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(1);
        if (!inputStack.m_41619_() && (recipe = QuernRecipe.getRecipe(this.f_58857_, wrapper = new ItemStackInventory(inputStack))) != null && recipe.matches(wrapper, this.f_58857_)) {
            ItemStack outputStack = recipe.assemble(wrapper, this.f_58857_.m_9598_());
            if (!(outputStack = Helpers.mergeInsertStack((IItemHandler)this.inventory, 2, outputStack)).m_41619_() && !this.f_58857_.f_46443_) {
                Helpers.spawnItem(this.f_58857_, this.f_58858_, outputStack);
            }
            inputStack.m_41774_(1);
            this.markForSync();
        }
        this.recipeTimer = 0.0f;
    }
}

