/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.Arrays;
import java.util.function.Predicate;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.container.CharcoalForgeContainer;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Fuel;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.IntArrayBuilder;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CharcoalForgeBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements ICalendarTickable,
MenuProvider {
    public static final int SLOT_FUEL_MIN = 0;
    public static final int SLOT_FUEL_MAX = 4;
    public static final int SLOT_INPUT_MIN = 5;
    public static final int SLOT_INPUT_MAX = 9;
    public static final int SLOT_EXTRA_MIN = 10;
    public static final int SLOT_EXTRA_MAX = 13;
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.charcoal_forge");
    protected final ContainerData syncableData;
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[5];
    private boolean needsSlotUpdate = false;
    private float temperature = 0.0f;
    private int burnTicks = 0;
    private float burnTemperature = 0.0f;
    private int airTicks = 0;
    private long lastPlayerTick = Integer.MIN_VALUE;
    private boolean needsRecipeUpdate;

    public static void createFromCharcoalPile(Level level, BlockPos pos) {
        level.m_46597_(pos, (BlockState)((Block)TFCBlocks.CHARCOAL_FORGE.get()).m_49966_().m_61124_((Property)CharcoalForgeBlock.HEAT, (Comparable)Integer.valueOf(2)));
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.CHARCOAL_FORGE.get()).ifPresent(CharcoalForgeBlockEntity::onFirstCreation);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CharcoalForgeBlockEntity forge) {
        forge.checkForLastTickSync();
        forge.checkForCalendarUpdate();
        if (forge.needsRecipeUpdate) {
            forge.needsRecipeUpdate = false;
            forge.updateCachedRecipes();
        }
        if (level.m_46467_() % 20L == 0L) {
            AABB bounds = new AABB((double)pos.m_123341_() - 0.2, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() - 0.2, (double)pos.m_123341_() + 1.2, (double)pos.m_123342_() + 1.25, (double)pos.m_123343_() + 1.2);
            Helpers.gatherAndConsumeItems(level, bounds, (IItemHandler)forge.inventory, 0, 4);
        }
        boolean isRaining = level.m_46758_(pos);
        if ((Integer)state.m_61143_((Property)CharcoalForgeBlock.HEAT) > 0) {
            int heatLevel;
            if (isRaining && level.f_46441_.m_188501_() < 0.15f) {
                Helpers.playSound(level, pos, (SoundEvent)TFCSounds.ITEM_COOL.get());
            }
            if ((heatLevel = Mth.m_14045_((int)((int)(forge.temperature / Heat.maxVisibleTemperature() * 6.0f) + 1), (int)1, (int)7)) != (Integer)state.m_61143_((Property)CharcoalForgeBlock.HEAT)) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)CharcoalForgeBlock.HEAT, (Comparable)Integer.valueOf(heatLevel)));
                forge.markForSync();
            }
            if (forge.burnTicks > 0) {
                forge.burnTicks = forge.burnTicks - (forge.airTicks > 0 || isRaining ? 2 : 1);
            }
            if (forge.burnTicks <= 0 && !forge.consumeFuel()) {
                forge.extinguish(state);
            }
        } else if (forge.burnTemperature > 0.0f) {
            forge.extinguish(state);
        }
        if (forge.airTicks > 0) {
            --forge.airTicks;
        }
        if (forge.temperature > 0.0f || forge.burnTemperature > 0.0f) {
            forge.temperature = HeatCapability.adjustDeviceTemp(forge.temperature, forge.burnTemperature, forge.airTicks, isRaining);
            HeatCapability.provideHeatTo(level, pos.m_7494_(), forge.temperature);
            for (int slot = 5; slot <= 9; ++slot) {
                ItemStack stack = ((ItemStackHandler)forge.inventory).getStackInSlot(slot);
                @Nullable IHeat heat = HeatCapability.get(stack);
                if (heat == null) continue;
                HeatCapability.addTemp(heat, forge.temperature);
                forge.handleInputMelting(stack, slot);
            }
            forge.markForSync();
        }
        if (forge.needsSlotUpdate) {
            forge.cascadeFuelSlots();
        }
    }

    public CharcoalForgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.CHARCOAL_FORGE.get(), pos, state, CharcoalForgeBlockEntity.defaultInventory(14), NAME);
        this.syncableData = new IntArrayBuilder().add(() -> (int)this.temperature, value -> {
            this.temperature = value;
        });
        if (((Boolean)TFCConfig.SERVER.charcoalForgeEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(0, 1, 2, 3, 4), Direction.UP).on(new PartialItemHandler(this.inventory).insert(5, 6, 7, 8, 9), (Predicate<Direction>)Direction.Plane.HORIZONTAL).on(new PartialItemHandler(this.inventory).extract(5, 6, 7, 8, 9), Direction.DOWN);
        }
        Arrays.fill(this.cachedRecipes, null);
    }

    public void intakeAir(int amount) {
        this.airTicks += amount;
        if (this.airTicks > 600) {
            this.airTicks = 600;
        }
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if ((Integer)state.m_61143_((Property)CharcoalForgeBlock.HEAT) != 0) {
            HeatCapability.Remainder remainder = HeatCapability.consumeFuelForTicks(ticks, this.inventory, this.burnTicks, this.burnTemperature, 0, 4);
            this.burnTicks = remainder.burnTicks();
            this.burnTemperature = remainder.burnTemperature();
            this.needsSlotUpdate = true;
            if (remainder.ticks() > 0L) {
                this.extinguish(state);
                for (int i = 5; i <= 9; ++i) {
                    ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
                    HeatCapability.setTemperature(stack, 0.0f);
                }
            }
        }
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    public ContainerData getSyncableData() {
        return this.syncableData;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public int getAirTicks() {
        return this.airTicks;
    }

    public void onFirstCreation() {
        this.burnTicks = 200;
        this.burnTemperature = 500.0f;
        this.markForSync();
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInv, Player player) {
        return CharcoalForgeContainer.create(this, playerInv, windowID);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.temperature = nbt.m_128457_("temperature");
        this.burnTicks = nbt.m_128451_("burnTicks");
        this.airTicks = nbt.m_128451_("airTicks");
        this.burnTemperature = nbt.m_128457_("burnTemperature");
        this.lastPlayerTick = nbt.m_128454_("lastPlayerTick");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128350_("temperature", this.temperature);
        nbt.m_128405_("burnTicks", this.burnTicks);
        nbt.m_128405_("airTicks", this.airTicks);
        nbt.m_128350_("burnTemperature", this.burnTemperature);
        nbt.m_128356_("lastPlayerTick", this.lastPlayerTick);
        super.m_183515_(nbt);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsSlotUpdate = true;
        this.updateCachedRecipes();
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot <= 4) {
            return Helpers.isItem(stack.m_41720_(), TFCTags.Items.FORGE_FUEL);
        }
        if (slot <= 9) {
            return HeatCapability.maybeHas(stack);
        }
        return Helpers.mightHaveCapability(stack, Capabilities.FLUID_ITEM) && HeatCapability.maybeHas(stack);
    }

    public boolean light(BlockState state) {
        assert (this.f_58857_ != null);
        if (this.burnTicks > 0) {
            return true;
        }
        if (this.consumeFuel()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)CharcoalForgeBlock.HEAT, (Comparable)Integer.valueOf(2)));
            return true;
        }
        return false;
    }

    private boolean consumeFuel() {
        ItemStack fuelStack = ((ItemStackHandler)this.inventory).getStackInSlot(0);
        if (!fuelStack.m_41619_()) {
            ((ItemStackHandler)this.inventory).setStackInSlot(0, ItemStack.f_41583_);
            this.needsSlotUpdate = true;
            Fuel fuel = Fuel.get(fuelStack);
            if (fuel != null) {
                this.burnTicks += fuel.getDuration();
                this.burnTemperature = fuel.getTemperature();
            }
            this.markForSync();
        }
        return this.burnTicks > 0;
    }

    public void extinguish(BlockState state) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)CharcoalForgeBlock.HEAT, (Comparable)Integer.valueOf(0)));
        this.burnTicks = 0;
        this.burnTemperature = 0.0f;
        this.markForSync();
    }

    private void handleInputMelting(ItemStack stack, int startIndex) {
        assert (this.f_58857_ != null);
        HeatingRecipe recipe = this.cachedRecipes[startIndex - 5];
        @Nullable IHeat cap = HeatCapability.get(stack);
        if (cap != null && recipe != null && recipe.isValidTemperature(cap.getTemperature())) {
            assert (this.f_58857_ != null);
            ItemStackInventory inventory = new ItemStackInventory(stack);
            FluidStack fluidStack = recipe.assembleFluid(inventory);
            ItemStack outputStack = recipe.assemble(inventory, this.f_58857_.m_9598_());
            float itemTemperature = cap.getTemperature();
            for (int slot = 10; slot <= 13 && !(fluidStack = Helpers.mergeOutputFluidIntoSlot(this.inventory, fluidStack, itemTemperature, slot)).isEmpty(); ++slot) {
            }
            FoodCapability.applyTrait(outputStack, FoodTraits.CHARCOAL_GRILLED);
            ((ItemStackHandler)this.inventory).setStackInSlot(startIndex, outputStack);
        }
    }

    private void cascadeFuelSlots() {
        int lowestAvailSlot = 0;
        for (int i = 0; i <= 4; ++i) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
            if (stack.m_41619_()) continue;
            if (i > lowestAvailSlot) {
                ((ItemStackHandler)this.inventory).setStackInSlot(lowestAvailSlot, stack.m_41777_());
                ((ItemStackHandler)this.inventory).setStackInSlot(i, ItemStack.f_41583_);
            }
            ++lowestAvailSlot;
        }
        this.needsSlotUpdate = false;
    }

    private void updateCachedRecipes() {
        assert (this.f_58857_ != null);
        for (int i = 5; i <= 9; ++i) {
            this.cachedRecipes[i - 5] = null;
            ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
            if (inputStack.m_41619_()) continue;
            this.cachedRecipes[i - 5] = HeatingRecipe.getRecipe(new ItemStackInventory(inputStack));
        }
    }
}

