/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.BloomBlock;
import net.dries007.tfc.common.blocks.MoltenBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.recipes.BloomeryRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTransaction;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class BloomeryBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements ICalendarTickable {
    private static final Component NAME = Component.m_237115_((String)"tfc.block_entity.bloomery");
    protected final List<ItemStack> inputStacks;
    private long lastPlayerTick = Integer.MIN_VALUE;
    private long litTick;
    @Nullable
    protected BloomeryRecipe cachedRecipe;

    public static void serverTick(Level level, BlockPos pos, BlockState state, BloomeryBlockEntity bloomery) {
        bloomery.checkForLastTickSync();
        bloomery.checkForCalendarUpdate();
        if (level.m_46467_() % 20L == 0L) {
            boolean lit;
            if (((Boolean)state.m_61143_((Property)BloomeryBlock.LIT)).booleanValue() && bloomery.getRemainingTicks() <= 0L) {
                bloomery.completeRecipe();
                state = (BlockState)state.m_61124_((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(false));
            }
            Direction direction = (Direction)state.m_61143_((Property)BloomeryBlock.FACING);
            int capacity = bloomery.calculateCapacity();
            boolean modified = bloomery.inputStacks.size() > capacity;
            bloomery.popItemsOffOverCapacity(bloomery.inputStacks, capacity);
            if (modified) {
                if (((Boolean)state.m_61143_((Property)BloomeryBlock.LIT)).booleanValue()) {
                    state = (BlockState)state.m_61124_((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(false));
                    level.m_46597_(pos, state);
                }
                if (!BloomeryBlock.canGateStayInPlace((LevelAccessor)level, pos, direction.m_122434_())) {
                    level.m_46961_(pos, true);
                    return;
                }
                bloomery.markForSync();
            }
            if (!(lit = ((Boolean)state.m_61143_((Property)BloomeryBlock.LIT)).booleanValue())) {
                bloomery.addItemsFromWorld(capacity);
            }
            MoltenBlock.manageMoltenBlockTower(level, bloomery.getInternalBlockPos(), lit, (Integer)TFCConfig.SERVER.bloomeryMaxChimneyHeight.get(), bloomery.inputStacks.size(), (Integer)TFCConfig.SERVER.bloomeryCapacity.get());
        }
    }

    public BloomeryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BLOOMERY.get(), pos, state, BloomeryBlockEntity.defaultInventory(0), NAME);
        this.inputStacks = new ArrayList<ItemStack>();
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        Helpers.readItemStacksFromNbt(this.inputStacks, nbt.m_128437_("inputStacks", 10));
        this.litTick = nbt.m_128454_("litTick");
        this.lastPlayerTick = nbt.m_128454_("lastTick");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inputStacks", (Tag)Helpers.writeItemStacksToNbt(this.inputStacks));
        nbt.m_128356_("litTick", this.litTick);
        nbt.m_128356_("lastTick", this.lastPlayerTick);
        super.m_183515_(nbt);
    }

    public long getRemainingTicks() {
        if (this.cachedRecipe == null) {
            this.updateCachedRecipe();
        }
        if (this.cachedRecipe != null) {
            return (long)this.cachedRecipe.getDuration() - this.getTicksSinceLit();
        }
        return 0L;
    }

    public long getTicksSinceLit() {
        assert (this.f_58857_ != null);
        return Calendars.get((LevelReader)this.f_58857_).getTicks() - this.litTick;
    }

    @Nullable
    public BloomeryRecipe getCachedRecipe() {
        return this.cachedRecipe;
    }

    public BlockPos getInternalBlockPos() {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_61138_((Property)BloomeryBlock.FACING)) {
            return this.f_58858_.m_121945_(((Direction)state.m_61143_((Property)BloomeryBlock.FACING)).m_122424_());
        }
        return this.f_58858_;
    }

    public BlockPos getExternalBlock() {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_61138_((Property)BloomeryBlock.FACING)) {
            return this.f_58858_.m_121945_((Direction)state.m_61143_((Property)BloomeryBlock.FACING));
        }
        return this.f_58858_;
    }

    public boolean light(BlockState state) {
        assert (this.f_58857_ != null);
        if (((Boolean)state.m_61143_((Property)BloomeryBlock.LIT)).booleanValue()) {
            return true;
        }
        this.updateCachedRecipe();
        if (this.cachedRecipe != null) {
            this.litTick = Calendars.get((LevelReader)this.f_58857_).getTicks();
            state = (BlockState)((BlockState)state.m_61124_((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BloomeryBlock.OPEN, (Comparable)Boolean.valueOf(false));
            this.f_58857_.m_46597_(this.f_58858_, state);
            return true;
        }
        return false;
    }

    public int getInputCount() {
        return this.inputStacks.size();
    }

    public List<ItemStack> getInputStacks() {
        return this.inputStacks;
    }

    @Override
    public void ejectInventory() {
        this.dumpItems();
        this.destroyMolten();
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        if (this.cachedRecipe == null) {
            this.updateCachedRecipe();
        }
        if (this.f_58857_.f_46443_ || this.cachedRecipe == null || !((Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BloomeryBlock.LIT)).booleanValue()) {
            return;
        }
        long finishTick = (long)this.cachedRecipe.getDuration() + this.litTick;
        if (finishTick <= Calendars.SERVER.getTicks()) {
            long offset = Calendars.SERVER.getTicks() - finishTick;
            try (CalendarTransaction tr = Calendars.SERVER.transaction();){
                tr.add(-offset);
                this.completeRecipe();
            }
        }
    }

    @Override
    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    private void dumpItems() {
        assert (this.f_58857_ != null);
        BlockPos pos = this.getExternalBlock();
        for (ItemStack stack : this.inputStacks) {
            Containers.m_18992_((Level)this.f_58857_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
        this.cachedRecipe = null;
        this.inputStacks.clear();
    }

    private void popItemsOffOverCapacity(List<ItemStack> items, int capacity) {
        assert (this.f_58857_ != null);
        while (items.size() > capacity) {
            Helpers.spawnItem(this.f_58857_, this.f_58858_, items.remove(items.size() - 1));
        }
    }

    private void addItemsFromWorld(int capacity) {
        block12: {
            block14: {
                ArrayList<ItemEntity> foundInputs;
                block13: {
                    assert (this.f_58857_ != null);
                    this.updateCachedRecipe();
                    if (this.cachedRecipe == null && !this.inputStacks.isEmpty()) {
                        this.dumpItems();
                        this.markForSync();
                    }
                    if (this.inputStacks.size() == capacity) {
                        return;
                    }
                    BlockPos internalPos = this.getInternalBlockPos();
                    List itemEntities = this.f_58857_.m_6443_(ItemEntity.class, new AABB(internalPos, internalPos.m_7918_(1, BloomeryBlock.getChimneyLevels(this.f_58857_, internalPos) + 1, 1)), EntitySelector.f_20402_);
                    if (this.cachedRecipe == null) {
                        assert (this.inputStacks.isEmpty());
                        Collection<BloomeryRecipe> recipes = Helpers.getRecipes(this.f_58857_, TFCRecipeTypes.BLOOMERY).values();
                        ItemStackInventory inventory = new ItemStackInventory();
                        block0: for (ItemEntity entity : itemEntities) {
                            inventory.setStack(entity.m_32055_());
                            @Nullable HeatingRecipe heat = HeatingRecipe.getRecipe(inventory);
                            if (heat == null) continue;
                            FluidStack fluid = heat.assembleFluid(inventory);
                            for (BloomeryRecipe recipe : recipes) {
                                if (!recipe.matchesInput(fluid)) continue;
                                this.cachedRecipe = recipe;
                                this.markForSync();
                                break block0;
                            }
                        }
                    }
                    if (this.cachedRecipe == null) break block12;
                    boolean hasSeenCatalyst = false;
                    boolean hasSeenInput = false;
                    foundInputs = new ArrayList<ItemEntity>();
                    for (ItemEntity entity : itemEntities) {
                        ItemStack stack = entity.m_32055_();
                        if (this.cachedRecipe.matchesInput(stack)) {
                            hasSeenInput = true;
                            foundInputs.add(entity);
                            continue;
                        }
                        if (!this.cachedRecipe.matchesCatalyst(stack)) continue;
                        hasSeenCatalyst = true;
                        foundInputs.add(entity);
                    }
                    if (hasSeenCatalyst && hasSeenInput) break block13;
                    if (this.inputStacks.isEmpty()) break block14;
                    if (hasSeenCatalyst) break block13;
                    if (!hasSeenInput) break block14;
                }
                Helpers.consumeItemsFromEntitiesIndividually(foundInputs, capacity - this.inputStacks.size(), this.inputStacks::add);
            }
            this.markForSync();
        }
    }

    private void destroyMolten() {
        assert (this.f_58857_ != null);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            MoltenBlock.removeMoltenBlockTower(this.f_58857_, this.f_58858_.m_121945_(direction), (Integer)TFCConfig.SERVER.bloomeryMaxChimneyHeight.get());
        }
    }

    private int calculateCapacity() {
        Direction direction;
        assert (this.f_58857_ != null);
        BlockPos pos = this.getInternalBlockPos();
        if (BloomeryBlock.isFormed(this.f_58857_, pos, direction = (Direction)this.m_58900_().m_61143_((Property)BloomeryBlock.FACING))) {
            return BloomeryBlock.getChimneyLevels(this.f_58857_, pos) * (Integer)TFCConfig.SERVER.bloomeryCapacity.get();
        }
        return 0;
    }

    private void completeRecipe() {
        assert (this.f_58857_ != null);
        if (this.cachedRecipe != null) {
            int fluidAmount = 0;
            int catalystAmount = 0;
            for (ItemStack stack : this.inputStacks) {
                @Nullable FluidStack primaryInput = this.cachedRecipe.consumeInput(stack);
                if (primaryInput != null) {
                    fluidAmount += primaryInput.getAmount();
                    continue;
                }
                ++catalystAmount;
            }
            int producedAmount = Math.min(fluidAmount / this.cachedRecipe.getInputFluid().amount(), catalystAmount / this.cachedRecipe.getCatalyst().count());
            if (producedAmount > 0) {
                ItemStack outputStack = this.cachedRecipe.assembleOutput();
                @Nullable HeatingRecipe recipe = HeatingRecipe.getRecipe(outputStack);
                if (recipe != null) {
                    HeatCapability.setTemperature(outputStack, recipe.getTemperature() - 1.0f);
                }
                BlockPos pos = this.getInternalBlockPos();
                this.f_58857_.m_46597_(pos, (BlockState)((Block)TFCBlocks.BLOOM.get()).m_49966_().m_61124_((Property)BloomBlock.LAYERS, (Comparable)Integer.valueOf(8)));
                this.f_58857_.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BLOOM.get()).ifPresent(bloom -> bloom.setBloom(outputStack, producedAmount));
            }
        }
        this.inputStacks.clear();
        this.cachedRecipe = null;
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(false)));
        this.destroyMolten();
    }

    private void updateCachedRecipe() {
        assert (this.f_58857_ != null);
        this.cachedRecipe = null;
        Collection<BloomeryRecipe> recipes = Helpers.getRecipes(this.f_58857_, TFCRecipeTypes.BLOOMERY).values();
        ItemStackInventory inventory = new ItemStackInventory();
        for (ItemStack stack : this.inputStacks) {
            inventory.setStack(stack);
            @Nullable HeatingRecipe heat = HeatingRecipe.getRecipe(inventory);
            if (heat == null) continue;
            FluidStack fluid = heat.assembleFluid(inventory);
            for (BloomeryRecipe recipe : recipes) {
                if (!recipe.matchesInput(fluid)) continue;
                this.cachedRecipe = recipe;
                return;
            }
        }
    }
}

