/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.BloomBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BloomBlockEntity
extends TFCBlockEntity {
    public static final int TOTAL_LAYERS = 8;
    private ItemStack item = ItemStack.f_41583_;
    private int count = 0;
    private int maxCount;

    public BloomBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BLOOM.get(), pos, state);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("item", (Tag)this.item.m_41739_(new CompoundTag()));
        tag.m_128405_("count", this.count);
        tag.m_128405_("maxCount", this.maxCount);
    }

    @Override
    protected void loadAdditional(CompoundTag tag) {
        super.loadAdditional(tag);
        this.item = ItemStack.m_41712_((CompoundTag)tag.m_128469_("item"));
        this.count = tag.m_128451_("count");
        this.maxCount = tag.m_128451_("maxCount");
    }

    public void setBloom(ItemStack item, int count) {
        if (count > 0) {
            assert (this.f_58857_ != null);
            this.item = item;
            this.count = count;
            this.maxCount = count;
            this.f_58857_.m_46597_(this.f_58858_, this.getState());
        }
    }

    public boolean dropBloom() {
        assert (this.f_58857_ != null);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        BlockPos dropPos = this.f_58858_;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            cursor.m_122159_((Vec3i)this.f_58858_, direction);
            if (!Helpers.isBlock(this.f_58857_.m_8055_((BlockPos)cursor), (Block)TFCBlocks.BLOOMERY.get())) continue;
            dropPos = cursor.m_7949_();
            break;
        }
        --this.count;
        ItemStack item = this.item.m_41777_();
        item.m_41764_(1);
        Helpers.spawnItem(this.f_58857_, dropPos, item);
        return this.f_58857_.m_7731_(this.f_58858_, this.getState(), this.f_58857_.f_46443_ ? 11 : 3);
    }

    public BlockState getState() {
        assert (this.f_58857_ != null);
        if (this.count <= 0) {
            return Blocks.f_50016_.m_49966_();
        }
        int layers = this.maxCount <= 8 ? this.count : Mth.m_14045_((int)(8 * this.count / this.maxCount), (int)1, (int)8);
        return (BlockState)this.m_58900_().m_61124_((Property)BloomBlock.LAYERS, (Comparable)Integer.valueOf(layers));
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }
}

