/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.common.blocks.DecorationBlockRegistryObject;
import net.dries007.tfc.common.blocks.Gem;
import net.dries007.tfc.common.blocks.OreDeposit;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.plant.Plant;
import net.dries007.tfc.common.blocks.plant.coral.Coral;
import net.dries007.tfc.common.blocks.plant.fruit.FruitBlocks;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.HideItemType;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.SelfTests;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public final class TFCCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"tfc");
    public static final CreativeTabHolder EARTH = TFCCreativeTabs.register("earth", () -> new ItemStack((ItemLike)TFCBlocks.ROCK_BLOCKS.get(Rock.QUARTZITE).get((Object)Rock.BlockType.RAW).get()), TFCCreativeTabs::fillEarthTab);
    public static final CreativeTabHolder ORES = TFCCreativeTabs.register("ores", () -> new ItemStack((ItemLike)TFCItems.GRADED_ORES.get((Object)Ore.NATIVE_COPPER).get((Object)Ore.Grade.NORMAL).get()), TFCCreativeTabs::fillOresTab);
    public static final CreativeTabHolder ROCKS = TFCCreativeTabs.register("rock", () -> new ItemStack((ItemLike)TFCBlocks.ROCK_BLOCKS.get(Rock.ANDESITE).get((Object)Rock.BlockType.RAW).get()), TFCCreativeTabs::fillRocksTab);
    public static final CreativeTabHolder METAL = TFCCreativeTabs.register("metals", () -> new ItemStack((ItemLike)TFCItems.METAL_ITEMS.get(Metal.Default.WROUGHT_IRON).get((Object)Metal.ItemType.INGOT).get()), TFCCreativeTabs::fillMetalTab);
    public static final CreativeTabHolder WOOD = TFCCreativeTabs.register("wood", () -> new ItemStack((ItemLike)TFCBlocks.WOODS.get(Wood.DOUGLAS_FIR).get((Object)Wood.BlockType.LOG).get()), TFCCreativeTabs::fillWoodTab);
    public static final CreativeTabHolder FOOD = TFCCreativeTabs.register("food", () -> new ItemStack((ItemLike)TFCItems.FOOD.get((Object)Food.RED_APPLE).get()), TFCCreativeTabs::fillFoodTab);
    public static final CreativeTabHolder FLORA = TFCCreativeTabs.register("flora", () -> new ItemStack((ItemLike)TFCBlocks.PLANTS.get(Plant.GOLDENROD).get()), TFCCreativeTabs::fillPlantsTab);
    public static final CreativeTabHolder DECORATIONS = TFCCreativeTabs.register("decorations", () -> new ItemStack((ItemLike)TFCBlocks.ALABASTER_BRICKS.get(DyeColor.CYAN).get()), TFCCreativeTabs::fillDecorationsTab);
    public static final CreativeTabHolder MISC = TFCCreativeTabs.register("misc", () -> new ItemStack((ItemLike)TFCItems.FIRESTARTER.get()), TFCCreativeTabs::fillMiscTab);

    public static Stream<CreativeModeTab.DisplayItemsGenerator> generators() {
        return Stream.of(EARTH, ORES, ROCKS, METAL, WOOD, FOOD, FLORA, DECORATIONS, MISC).map(holder -> holder.generator);
    }

    private static void fillEarthTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (SoilBlockType.Variant variant : SoilBlockType.Variant.values()) {
            for (SoilBlockType type2 : SoilBlockType.VALUES) {
                TFCCreativeTabs.accept(out, TFCBlocks.SOIL, type2, variant);
                if (type2 != SoilBlockType.MUD_BRICKS) continue;
                TFCCreativeTabs.accept(out, TFCBlocks.MUD_BRICK_DECORATIONS.get(variant));
            }
        }
        TFCCreativeTabs.accept(out, TFCBlocks.SMOOTH_MUD_BRICKS);
        TFCCreativeTabs.accept(out, TFCBlocks.TREE_ROOTS);
        TFCCreativeTabs.accept(out, TFCBlocks.PEAT);
        TFCCreativeTabs.accept(out, TFCBlocks.PEAT_GRASS);
        TFCCreativeTabs.accept(out, TFCBlocks.WHITE_KAOLIN_CLAY);
        TFCCreativeTabs.accept(out, TFCBlocks.PINK_KAOLIN_CLAY);
        TFCCreativeTabs.accept(out, TFCBlocks.RED_KAOLIN_CLAY);
        TFCCreativeTabs.accept(out, TFCBlocks.KAOLIN_CLAY_GRASS);
        TFCBlocks.GROUNDCOVER.forEach((type, reg) -> {
            if (type.getVanillaItem() == null) {
                TFCCreativeTabs.accept(out, reg);
            } else {
                TFCCreativeTabs.accept(out, type.getVanillaItem());
            }
        });
        TFCBlocks.SMALL_ORES.values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        for (Enum enum_ : SandBlockType.values()) {
            TFCCreativeTabs.accept(out, TFCBlocks.SAND, enum_);
            TFCBlocks.SANDSTONE.get(enum_).values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
            TFCBlocks.SANDSTONE_DECORATIONS.get(enum_).values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        }
        out.m_246326_((ItemLike)Blocks.f_50126_);
        TFCCreativeTabs.accept(out, TFCBlocks.SEA_ICE);
        out.m_246326_((ItemLike)Blocks.f_50354_);
        out.m_246326_((ItemLike)Blocks.f_50568_);
        TFCBlocks.MAGMA_BLOCKS.values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        for (Enum enum_ : Crop.values()) {
            TFCCreativeTabs.accept(out, TFCBlocks.WILD_CROPS, enum_);
            if (enum_ == Crop.PUMPKIN) {
                TFCCreativeTabs.accept(out, TFCBlocks.PUMPKIN);
            } else if (enum_ == Crop.MELON) {
                TFCCreativeTabs.accept(out, TFCBlocks.MELON);
            }
            TFCCreativeTabs.accept(out, TFCItems.CROP_SEEDS, enum_);
        }
        TFCBlocks.SPREADING_BUSHES.values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        TFCBlocks.STATIONARY_BUSHES.values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        TFCCreativeTabs.accept(out, TFCBlocks.CRANBERRY_BUSH);
        for (Enum enum_ : FruitBlocks.Tree.values()) {
            TFCCreativeTabs.accept(out, TFCBlocks.FRUIT_TREE_SAPLINGS, enum_);
            TFCCreativeTabs.accept(out, TFCBlocks.FRUIT_TREE_LEAVES, enum_);
        }
        TFCCreativeTabs.accept(out, TFCBlocks.BANANA_SAPLING);
        TFCCreativeTabs.accept(out, TFCBlocks.CALCITE);
        TFCCreativeTabs.accept(out, TFCBlocks.ICICLE);
        for (Enum enum_ : Coral.values()) {
            TFCBlocks.CORAL.get(enum_).values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
            TFCCreativeTabs.accept(out, TFCItems.CORAL_FANS, enum_);
            TFCCreativeTabs.accept(out, TFCItems.DEAD_CORAL_FANS, enum_);
        }
    }

    private static void fillMetalTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (Metal.Default metal : Metal.Default.values()) {
            for (Metal.BlockType blockType : new Metal.BlockType[]{Metal.BlockType.ANVIL, Metal.BlockType.BLOCK, Metal.BlockType.BLOCK_SLAB, Metal.BlockType.BLOCK_STAIRS, Metal.BlockType.BARS, Metal.BlockType.CHAIN, Metal.BlockType.TRAPDOOR, Metal.BlockType.LAMP}) {
                TFCCreativeTabs.accept(out, TFCBlocks.METALS, metal, blockType);
            }
            TFCCreativeTabs.accept(out, TFCItems.METAL_ITEMS, metal, Metal.ItemType.UNFINISHED_LAMP);
            if (metal == Metal.Default.BRONZE) {
                TFCCreativeTabs.accept(out, TFCBlocks.BRONZE_BELL);
            } else if (metal == Metal.Default.BRASS) {
                TFCCreativeTabs.accept(out, TFCBlocks.BRASS_BELL);
                TFCCreativeTabs.accept(out, TFCItems.BRASS_MECHANISMS);
                TFCCreativeTabs.accept(out, TFCItems.JACKS);
            } else if (metal == Metal.Default.GOLD) {
                out.m_246326_((ItemLike)Blocks.f_50680_);
            } else if (metal == Metal.Default.RED_STEEL) {
                TFCCreativeTabs.accept(out, TFCItems.RED_STEEL_BUCKET);
            } else if (metal == Metal.Default.BLUE_STEEL) {
                TFCCreativeTabs.accept(out, TFCItems.BLUE_STEEL_BUCKET);
            } else if (metal == Metal.Default.WROUGHT_IRON) {
                TFCCreativeTabs.accept(out, TFCItems.WROUGHT_IRON_GRILL);
            } else if (metal == Metal.Default.STEEL) {
                TFCCreativeTabs.accept(out, TFCBlocks.STEEL_PIPE);
                TFCCreativeTabs.accept(out, TFCBlocks.STEEL_PUMP);
            }
            for (Enum enum_ : new Metal.ItemType[]{Metal.ItemType.INGOT, Metal.ItemType.DOUBLE_INGOT, Metal.ItemType.SHEET, Metal.ItemType.DOUBLE_SHEET, Metal.ItemType.ROD, Metal.ItemType.TUYERE, Metal.ItemType.PICKAXE, Metal.ItemType.PROPICK, Metal.ItemType.AXE, Metal.ItemType.SHOVEL, Metal.ItemType.HOE, Metal.ItemType.CHISEL, Metal.ItemType.HAMMER, Metal.ItemType.SAW, Metal.ItemType.KNIFE, Metal.ItemType.SCYTHE, Metal.ItemType.JAVELIN, Metal.ItemType.SWORD, Metal.ItemType.MACE, Metal.ItemType.FISHING_ROD, Metal.ItemType.SHEARS, Metal.ItemType.HELMET, Metal.ItemType.CHESTPLATE, Metal.ItemType.GREAVES, Metal.ItemType.BOOTS, Metal.ItemType.SHIELD, Metal.ItemType.HORSE_ARMOR, Metal.ItemType.PICKAXE_HEAD, Metal.ItemType.PROPICK_HEAD, Metal.ItemType.AXE_HEAD, Metal.ItemType.SHOVEL_HEAD, Metal.ItemType.HOE_HEAD, Metal.ItemType.CHISEL_HEAD, Metal.ItemType.HAMMER_HEAD, Metal.ItemType.SAW_BLADE, Metal.ItemType.KNIFE_BLADE, Metal.ItemType.SCYTHE_BLADE, Metal.ItemType.JAVELIN_HEAD, Metal.ItemType.SWORD_BLADE, Metal.ItemType.MACE_HEAD, Metal.ItemType.FISH_HOOK, Metal.ItemType.UNFINISHED_HELMET, Metal.ItemType.UNFINISHED_CHESTPLATE, Metal.ItemType.UNFINISHED_GREAVES, Metal.ItemType.UNFINISHED_BOOTS}) {
                TFCCreativeTabs.accept(out, TFCItems.METAL_ITEMS, metal, enum_);
            }
        }
    }

    private static void fillOresTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        TFCCreativeTabs.accept(out, TFCItems.RAW_IRON_BLOOM);
        TFCCreativeTabs.accept(out, TFCItems.REFINED_IRON_BLOOM);
        for (Ore ore : Ore.values()) {
            if (!ore.isGraded()) continue;
            TFCCreativeTabs.accept(out, TFCItems.GRADED_ORES, ore, Ore.Grade.POOR);
            TFCCreativeTabs.accept(out, TFCBlocks.SMALL_ORES, ore);
            TFCCreativeTabs.accept(out, TFCItems.GRADED_ORES, ore, Ore.Grade.NORMAL);
            TFCCreativeTabs.accept(out, TFCItems.GRADED_ORES, ore, Ore.Grade.RICH);
        }
        for (Ore ore : Ore.values()) {
            if (ore.isGraded()) continue;
            TFCCreativeTabs.accept(out, TFCItems.ORES, ore);
        }
        for (Enum enum_ : Gem.values()) {
            TFCCreativeTabs.accept(out, TFCItems.GEMS, enum_);
            TFCCreativeTabs.accept(out, TFCItems.GEM_DUST, enum_);
        }
        for (Enum enum_ : OreDeposit.values()) {
            TFCBlocks.ORE_DEPOSITS.values().forEach(arg_0 -> TFCCreativeTabs.lambda$fillOresTab$18(out, (OreDeposit)enum_, arg_0));
        }
        for (Enum enum_ : Ore.values()) {
            if (((Ore)enum_).isGraded()) {
                TFCBlocks.GRADED_ORES.values().forEach(arg_0 -> TFCCreativeTabs.lambda$fillOresTab$20((Ore)enum_, out, arg_0));
                continue;
            }
            TFCBlocks.ORES.values().forEach(arg_0 -> TFCCreativeTabs.lambda$fillOresTab$21(out, (Ore)enum_, arg_0));
        }
    }

    private static void fillRocksTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (Rock rock : Rock.VALUES) {
            for (Enum enum_ : new Rock.BlockType[]{Rock.BlockType.HARDENED, Rock.BlockType.RAW, Rock.BlockType.PRESSURE_PLATE, Rock.BlockType.BUTTON, Rock.BlockType.SPIKE, Rock.BlockType.COBBLE, Rock.BlockType.MOSSY_COBBLE, Rock.BlockType.BRICKS, Rock.BlockType.CRACKED_BRICKS, Rock.BlockType.MOSSY_BRICKS, Rock.BlockType.SMOOTH, Rock.BlockType.CHISELED, Rock.BlockType.AQUEDUCT, Rock.BlockType.GRAVEL, Rock.BlockType.LOOSE, Rock.BlockType.MOSSY_LOOSE}) {
                TFCCreativeTabs.accept(out, TFCBlocks.ROCK_BLOCKS, rock, enum_);
                if (!((Rock.BlockType)enum_).hasVariants()) continue;
                TFCCreativeTabs.accept(out, TFCBlocks.ROCK_DECORATIONS.get(rock).get(enum_));
            }
            TFCCreativeTabs.accept(out, TFCItems.BRICKS, rock);
        }
        for (Enum enum_ : RockCategory.ItemType.values()) {
            for (RockCategory rockCategory : RockCategory.values()) {
                TFCCreativeTabs.accept(out, TFCItems.ROCK_TOOLS, rockCategory, enum_);
            }
        }
    }

    private static void fillFoodTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        TFCItems.FOOD.values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        TFCItems.SOUPS.values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        TFCItems.SALADS.values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        TFCCreativeTabs.accept(out, TFCItems.EMPTY_JAR);
        TFCCreativeTabs.accept(out, TFCItems.EMPTY_JAR_WITH_LID);
        for (Food food : Food.values()) {
            TFCCreativeTabs.accept(out, TFCItems.FRUIT_PRESERVES, food);
            TFCCreativeTabs.accept(out, TFCItems.UNSEALED_FRUIT_PRESERVES, food);
        }
    }

    private static void fillMiscTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        if (!FMLEnvironment.production) {
            out.m_246342_(PatchouliIntegration.getFieldGuide(false));
            out.m_246342_(PatchouliIntegration.getFieldGuide(true));
        }
        TFCCreativeTabs.accept(out, TFCItems.FIRESTARTER);
        out.m_246326_((ItemLike)Items.f_42409_);
        TFCCreativeTabs.accept(out, TFCItems.SOOT);
        TFCCreativeTabs.accept(out, TFCItems.SANDPAPER);
        TFCCreativeTabs.accept(out, TFCItems.BONE_NEEDLE);
        TFCCreativeTabs.accept(out, TFCItems.BLANK_DISC);
        TFCCreativeTabs.accept(out, TFCItems.BRASS_MECHANISMS);
        TFCCreativeTabs.accept(out, TFCItems.BURLAP_CLOTH);
        TFCCreativeTabs.accept(out, TFCItems.SILK_CLOTH);
        TFCCreativeTabs.accept(out, TFCItems.WOOL_CLOTH);
        TFCCreativeTabs.accept(out, TFCItems.WOOL);
        TFCCreativeTabs.accept(out, TFCItems.WOOL_YARN);
        TFCCreativeTabs.accept(out, TFCItems.SPINDLE);
        TFCCreativeTabs.accept(out, TFCItems.COMPOST);
        TFCCreativeTabs.accept(out, TFCItems.ROTTEN_COMPOST);
        TFCCreativeTabs.accept(out, TFCItems.PURE_NITROGEN);
        TFCCreativeTabs.accept(out, TFCItems.PURE_POTASSIUM);
        TFCCreativeTabs.accept(out, TFCItems.PURE_PHOSPHORUS);
        TFCCreativeTabs.accept(out, TFCItems.DAUB);
        TFCCreativeTabs.accept(out, TFCItems.DIRTY_JUTE_NET);
        TFCCreativeTabs.accept(out, TFCItems.FIRE_CLAY);
        TFCCreativeTabs.accept(out, TFCItems.KAOLIN_CLAY);
        TFCCreativeTabs.accept(out, TFCItems.GLUE);
        TFCCreativeTabs.accept(out, TFCItems.GOAT_HORN);
        TFCCreativeTabs.accept(out, TFCItems.JUTE);
        TFCCreativeTabs.accept(out, TFCItems.JUTE_FIBER);
        TFCCreativeTabs.accept(out, TFCItems.OLIVE_PASTE);
        TFCCreativeTabs.accept(out, TFCItems.JUTE_NET);
        TFCCreativeTabs.accept(out, TFCItems.HANDSTONE);
        TFCCreativeTabs.accept(out, TFCItems.MORTAR);
        TFCCreativeTabs.accept(out, TFCItems.PAPYRUS);
        TFCCreativeTabs.accept(out, TFCItems.PAPYRUS_STRIP);
        TFCCreativeTabs.accept(out, TFCItems.SOAKED_PAPYRUS_STRIP);
        TFCCreativeTabs.accept(out, TFCItems.UNREFINED_PAPER);
        TFCCreativeTabs.accept(out, TFCItems.STICK_BUNCH);
        TFCCreativeTabs.accept(out, TFCItems.STICK_BUNDLE);
        out.m_246326_((ItemLike)Items.f_42399_);
        TFCCreativeTabs.accept(out, TFCItems.STRAW);
        TFCCreativeTabs.accept(out, TFCItems.WROUGHT_IRON_GRILL);
        TFCCreativeTabs.accept(out, TFCItems.LOAM_MUD_BRICK);
        TFCCreativeTabs.accept(out, TFCItems.SANDY_LOAM_MUD_BRICK);
        TFCCreativeTabs.accept(out, TFCItems.SILTY_LOAM_MUD_BRICK);
        TFCCreativeTabs.accept(out, TFCItems.SILT_MUD_BRICK);
        TFCItems.POWDERS.values().forEach(p -> TFCCreativeTabs.accept(out, p));
        TFCItems.ORE_POWDERS.values().forEach(p -> TFCCreativeTabs.accept(out, p));
        for (Gem gem : Gem.values()) {
            TFCCreativeTabs.accept(out, TFCItems.GEMS, gem);
            TFCCreativeTabs.accept(out, TFCItems.GEM_DUST, gem);
        }
        TFCCreativeTabs.accept(out, TFCItems.BLUBBER);
        for (Enum enum_ : HideItemType.values()) {
            TFCItems.HIDES.get(enum_).values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        }
        TFCCreativeTabs.accept(out, TFCItems.TREATED_HIDE);
        out.m_246326_((ItemLike)Items.f_42532_);
        out.m_246326_((ItemLike)Items.f_151056_);
        TFCCreativeTabs.accept(out, TFCItems.GLOW_ARROW);
        TFCCreativeTabs.accept(out, TFCItems.ALABASTER_BRICK);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_BRICK);
        out.m_246326_((ItemLike)Items.f_42460_);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_FIRE_BRICK);
        TFCCreativeTabs.accept(out, TFCItems.FIRE_BRICK);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_CRUCIBLE);
        TFCCreativeTabs.accept(out, TFCBlocks.CRUCIBLE);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_FLOWER_POT);
        out.m_246326_((ItemLike)Items.f_42618_);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_BOWL);
        TFCCreativeTabs.accept(out, TFCBlocks.CERAMIC_BOWL);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_PAN);
        TFCCreativeTabs.accept(out, TFCItems.EMPTY_PAN);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_SPINDLE_HEAD);
        TFCCreativeTabs.accept(out, TFCItems.SPINDLE_HEAD);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_POT);
        TFCCreativeTabs.accept(out, TFCItems.POT);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_VESSEL);
        TFCCreativeTabs.accept(out, TFCItems.VESSEL);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_LARGE_VESSEL);
        TFCCreativeTabs.accept(out, TFCBlocks.LARGE_VESSEL);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_JUG);
        for (Enum enum_ : DyeColor.values()) {
            TFCCreativeTabs.accept(out, TFCItems.UNFIRED_GLAZED_VESSELS, enum_);
            TFCCreativeTabs.accept(out, TFCItems.GLAZED_VESSELS, enum_);
            TFCCreativeTabs.accept(out, TFCItems.UNFIRED_GLAZED_LARGE_VESSELS, enum_);
            TFCCreativeTabs.accept(out, TFCBlocks.GLAZED_LARGE_VESSELS, enum_);
        }
        for (Enum enum_ : Metal.ItemType.values()) {
            TFCCreativeTabs.accept(out, TFCItems.UNFIRED_MOLDS, enum_);
            TFCCreativeTabs.accept(out, TFCItems.MOLDS, enum_);
            if (enum_ != Metal.ItemType.INGOT) continue;
            TFCCreativeTabs.accept(out, TFCItems.UNFIRED_FIRE_INGOT_MOLD);
            TFCCreativeTabs.accept(out, TFCItems.FIRE_INGOT_MOLD);
        }
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_BELL_MOLD);
        TFCCreativeTabs.accept(out, TFCItems.BELL_MOLD);
        TFCCreativeTabs.accept(out, TFCItems.WOODEN_BUCKET);
        TFCCreativeTabs.accept(out, TFCItems.JUG);
        TFCCreativeTabs.accept(out, TFCItems.UNFIRED_BLOWPIPE);
        TFCCreativeTabs.accept(out, TFCItems.CERAMIC_BLOWPIPE);
        TFCCreativeTabs.accept(out, TFCItems.CERAMIC_BLOWPIPE_WITH_GLASS);
        TFCCreativeTabs.accept(out, TFCItems.BLOWPIPE);
        TFCCreativeTabs.accept(out, TFCItems.BLOWPIPE_WITH_GLASS);
        TFCCreativeTabs.accept(out, TFCItems.GEM_SAW);
        TFCCreativeTabs.accept(out, TFCItems.JACKS);
        TFCCreativeTabs.accept(out, TFCItems.PADDLE);
        TFCCreativeTabs.accept(out, TFCItems.SILICA_GLASS_BATCH);
        TFCCreativeTabs.accept(out, TFCItems.HEMATITIC_GLASS_BATCH);
        TFCCreativeTabs.accept(out, TFCItems.OLIVINE_GLASS_BATCH);
        TFCCreativeTabs.accept(out, TFCItems.VOLCANIC_GLASS_BATCH);
        TFCCreativeTabs.accept(out, TFCItems.LAMP_GLASS);
        TFCCreativeTabs.accept(out, TFCItems.LENS);
        TFCCreativeTabs.accept(out, TFCItems.SILICA_GLASS_BOTTLE);
        TFCCreativeTabs.accept(out, TFCItems.HEMATITIC_GLASS_BOTTLE);
        TFCCreativeTabs.accept(out, TFCItems.OLIVINE_GLASS_BOTTLE);
        TFCCreativeTabs.accept(out, TFCItems.VOLCANIC_GLASS_BOTTLE);
        TFCCreativeTabs.accept(out, TFCBlocks.HAND_WHEEL_BASE);
        TFCCreativeTabs.accept(out, TFCItems.HAND_WHEEL);
        TFCCreativeTabs.accept(out, TFCItems.EMPTY_JAR);
        TFCCreativeTabs.accept(out, TFCItems.EMPTY_JAR_WITH_LID);
        TFCCreativeTabs.accept(out, TFCItems.JAR_LID);
        TFCCreativeTabs.accept(out, TFCItems.WINDMILL_BLADE);
        TFCItems.COLORED_WINDMILL_BLADES.values().forEach(blade -> TFCCreativeTabs.accept(out, blade));
        TFCCreativeTabs.accept(out, TFCItems.RUSTIC_WINDMILL_BLADE);
        TFCCreativeTabs.accept(out, TFCItems.LATTICE_WINDMILL_BLADE);
        TFCCreativeTabs.consumeOurs(BuiltInRegistries.f_257020_, fluid -> out.m_246326_((ItemLike)fluid.m_6859_()));
        TFCItems.FRESHWATER_FISH_BUCKETS.values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        TFCCreativeTabs.accept(out, TFCItems.COD_BUCKET);
        TFCCreativeTabs.accept(out, TFCItems.JELLYFISH_BUCKET);
        TFCCreativeTabs.accept(out, TFCItems.TROPICAL_FISH_BUCKET);
        TFCCreativeTabs.accept(out, TFCItems.PUFFERFISH_BUCKET);
        TFCCreativeTabs.consumeOurs(BuiltInRegistries.f_256780_, entity -> {
            SpawnEggItem item = ForgeSpawnEggItem.fromEntityType((EntityType)entity);
            if (item != null) {
                out.m_246326_((ItemLike)item);
            }
        });
    }

    private static void fillDecorationsTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        TFCCreativeTabs.accept(out, TFCBlocks.WATTLE);
        TFCCreativeTabs.accept(out, TFCBlocks.UNSTAINED_WATTLE);
        TFCBlocks.STAINED_WATTLE.values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        TFCCreativeTabs.accept(out, TFCBlocks.THATCH);
        TFCCreativeTabs.accept(out, TFCBlocks.THATCH_BED);
        TFCCreativeTabs.accept(out, TFCBlocks.FIREPIT);
        TFCCreativeTabs.accept(out, TFCBlocks.GRILL);
        TFCCreativeTabs.accept(out, TFCBlocks.POT);
        TFCCreativeTabs.accept(out, TFCBlocks.BELLOWS);
        TFCCreativeTabs.accept(out, TFCBlocks.POWDERKEG);
        TFCCreativeTabs.accept(out, TFCBlocks.BARREL_RACK);
        TFCCreativeTabs.accept(out, TFCBlocks.CERAMIC_BOWL);
        TFCCreativeTabs.accept(out, TFCBlocks.QUERN);
        TFCCreativeTabs.accept(out, TFCItems.HANDSTONE);
        TFCCreativeTabs.accept(out, TFCBlocks.CRANKSHAFT);
        TFCCreativeTabs.accept(out, TFCBlocks.TRIP_HAMMER);
        TFCCreativeTabs.accept(out, TFCBlocks.CRUCIBLE);
        TFCCreativeTabs.accept(out, TFCBlocks.COMPOSTER);
        TFCCreativeTabs.accept(out, TFCBlocks.BLOOMERY);
        TFCCreativeTabs.accept(out, TFCBlocks.BLAST_FURNACE);
        TFCCreativeTabs.accept(out, TFCBlocks.NEST_BOX);
        TFCCreativeTabs.accept(out, TFCBlocks.MELON);
        TFCCreativeTabs.accept(out, TFCBlocks.PUMPKIN);
        out.m_246326_((ItemLike)Blocks.f_50143_);
        TFCCreativeTabs.accept(out, TFCBlocks.JACK_O_LANTERN);
        TFCCreativeTabs.accept(out, TFCItems.TORCH);
        TFCCreativeTabs.accept(out, TFCItems.DEAD_TORCH);
        TFCCreativeTabs.accept(out, TFCBlocks.BARREL_RACK);
        TFCCreativeTabs.accept(out, TFCBlocks.FIRE_BRICKS);
        TFCCreativeTabs.accept(out, TFCBlocks.FIRE_CLAY_BLOCK);
        TFCCreativeTabs.accept(out, TFCBlocks.AGGREGATE);
        TFCCreativeTabs.accept(out, TFCBlocks.PLAIN_ALABASTER);
        TFCCreativeTabs.accept(out, TFCBlocks.PLAIN_ALABASTER_BRICKS);
        TFCCreativeTabs.accept(out, TFCBlocks.PLAIN_POLISHED_ALABASTER);
        for (DyeColor color : DyeColor.values()) {
            TFCCreativeTabs.accept(out, TFCBlocks.RAW_ALABASTER, color);
            TFCCreativeTabs.accept(out, TFCBlocks.ALABASTER_BRICKS, color);
            TFCCreativeTabs.accept(out, TFCBlocks.ALABASTER_BRICK_DECORATIONS.get(color));
            TFCCreativeTabs.accept(out, TFCBlocks.POLISHED_ALABASTER, color);
            TFCCreativeTabs.accept(out, TFCBlocks.ALABASTER_POLISHED_DECORATIONS.get(color));
        }
        TFCCreativeTabs.accept(out, TFCBlocks.LARGE_VESSEL);
        TFCBlocks.GLAZED_LARGE_VESSELS.values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
        TFCCreativeTabs.accept(out, TFCBlocks.CANDLE);
        TFCCreativeTabs.accept(out, TFCBlocks.CAKE);
        for (DyeColor color : DyeColor.values()) {
            TFCCreativeTabs.accept(out, TFCBlocks.DYED_CANDLE, color);
        }
    }

    private static void fillWoodTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        for (Wood wood : Wood.VALUES) {
            TFCBlocks.WOODS.get(wood).forEach((type, reg) -> {
                if (type.needsItem()) {
                    TFCCreativeTabs.accept(out, reg);
                }
                if (type == Wood.BlockType.SAPLING) {
                    switch (wood) {
                        case PINE: {
                            TFCCreativeTabs.accept(out, TFCBlocks.PINE_KRUMMHOLZ);
                            break;
                        }
                        case SPRUCE: {
                            TFCCreativeTabs.accept(out, TFCBlocks.SPRUCE_KRUMMHOLZ);
                            break;
                        }
                        case WHITE_CEDAR: {
                            TFCCreativeTabs.accept(out, TFCBlocks.WHITE_CEDAR_KRUMMHOLZ);
                            break;
                        }
                        case DOUGLAS_FIR: {
                            TFCCreativeTabs.accept(out, TFCBlocks.DOUGLAS_FIR_KRUMMHOLZ);
                            break;
                        }
                        case ASPEN: {
                            TFCCreativeTabs.accept(out, TFCBlocks.ASPEN_KRUMMHOLZ);
                        }
                    }
                }
            });
            if (wood == Wood.PALM) {
                TFCCreativeTabs.accept(out, TFCBlocks.PALM_MOSAIC);
                TFCCreativeTabs.accept(out, TFCBlocks.PALM_MOSAIC_STAIRS);
                TFCCreativeTabs.accept(out, TFCBlocks.PALM_MOSAIC_SLAB);
            }
            TFCCreativeTabs.accept(out, TFCItems.LUMBER, wood);
            TFCCreativeTabs.accept(out, TFCItems.BOATS, wood);
            TFCCreativeTabs.accept(out, TFCItems.SUPPORTS, wood);
            TFCCreativeTabs.accept(out, TFCItems.CHEST_MINECARTS, wood);
            TFCCreativeTabs.accept(out, TFCItems.SIGNS, wood);
            for (Metal.Default metal : Metal.Default.values()) {
                TFCCreativeTabs.accept(out, TFCItems.HANGING_SIGNS.get(wood), metal);
            }
        }
    }

    private static void fillPlantsTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        TFCBlocks.PLANTS.forEach((plant, reg) -> {
            if (plant.needsItem()) {
                TFCCreativeTabs.accept(out, reg);
            }
        });
        TFCCreativeTabs.accept(out, TFCBlocks.SEA_PICKLE);
    }

    private static CreativeTabHolder register(String name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator displayItems) {
        RegistryObject reg = CREATIVE_TABS.register(name, () -> CreativeModeTab.builder().m_257737_(icon).m_257941_((Component)Component.m_237115_((String)("tfc.creative_tab." + name))).m_257501_(displayItems).m_257652_());
        return new CreativeTabHolder((RegistryObject<CreativeModeTab>)reg, displayItems);
    }

    private static <T extends ItemLike, R extends Supplier<T>, K1, K2> void accept(CreativeModeTab.Output out, Map<K1, Map<K2, R>> map, K1 key1, K2 key2) {
        if (map.containsKey(key1) && map.get(key1).containsKey(key2)) {
            out.m_246326_((ItemLike)((Supplier)map.get(key1).get(key2)).get());
        }
    }

    private static <T extends ItemLike, R extends Supplier<T>, K> void accept(CreativeModeTab.Output out, Map<K, R> map, K key) {
        if (map.containsKey(key)) {
            out.m_246326_((ItemLike)((Supplier)map.get(key)).get());
        }
    }

    private static <T extends ItemLike, R extends Supplier<T>> void accept(CreativeModeTab.Output out, R reg) {
        if (((ItemLike)reg.get()).m_5456_() == Items.f_41852_) {
            TerraFirmaCraft.LOGGER.error("BlockItem with no Item added to creative tab: " + reg);
            SelfTests.reportExternalError();
            return;
        }
        out.m_246326_((ItemLike)reg.get());
    }

    private static void accept(CreativeModeTab.Output out, DecorationBlockRegistryObject decoration) {
        out.m_246326_((ItemLike)decoration.stair().get());
        out.m_246326_((ItemLike)decoration.slab().get());
        out.m_246326_((ItemLike)decoration.wall().get());
    }

    private static <T> void consumeOurs(Registry<T> registry, Consumer<T> consumer) {
        for (Object value : registry) {
            if (!Objects.requireNonNull(registry.m_7981_(value)).m_135827_().equals("tfc")) continue;
            consumer.accept(value);
        }
    }

    private static /* synthetic */ void lambda$fillOresTab$21(CreativeModeTab.Output out, Ore ore, Map map) {
        TFCCreativeTabs.accept(out, map, ore);
    }

    private static /* synthetic */ void lambda$fillOresTab$20(Ore ore, CreativeModeTab.Output out, Map map) {
        ((Map)map.get((Object)ore)).values().forEach(reg -> TFCCreativeTabs.accept(out, reg));
    }

    private static /* synthetic */ void lambda$fillOresTab$18(CreativeModeTab.Output out, OreDeposit deposit, Map map) {
        TFCCreativeTabs.accept(out, map, deposit);
    }

    public record CreativeTabHolder(RegistryObject<CreativeModeTab> tab, CreativeModeTab.DisplayItemsGenerator generator) {
    }
}

