/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.screen.TFCContainerScreen;
import net.dries007.tfc.client.screen.button.PlayerInventoryTabButton;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.capabilities.food.NutritionData;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.container.Container;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.network.PacketHandler;
import net.dries007.tfc.network.SwitchInventoryTabPacket;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.network.PacketDistributor;

public class NutritionScreen
extends TFCContainerScreen<Container> {
    public static final ResourceLocation TEXTURE = Helpers.identifier("textures/gui/player_nutrition.png");

    public NutritionScreen(Container container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, TEXTURE);
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new PlayerInventoryTabButton(this.f_97735_, this.f_97736_, 176, 4, 20, 22, 128, 0, 1, 3, 0, 0, button -> {
            this.playerInventory.f_35978_.f_36096_ = this.playerInventory.f_35978_.f_36095_;
            Minecraft.m_91087_().m_91152_((Screen)new InventoryScreen(this.playerInventory.f_35978_));
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new SwitchInventoryTabPacket(SwitchInventoryTabPacket.Type.INVENTORY));
        }));
        this.m_142416_((GuiEventListener)new PlayerInventoryTabButton(this.f_97735_, this.f_97736_, 176, 27, 20, 22, 128, 0, 1, 3, 32, 0, SwitchInventoryTabPacket.Type.CALENDAR));
        this.m_142416_((GuiEventListener)new PlayerInventoryTabButton(this.f_97735_, this.f_97736_, 173, 50, 23, 22, 148, 0, 1, 3, 64, 0, SwitchInventoryTabPacket.Type.NUTRITION));
        this.m_142416_((GuiEventListener)new PlayerInventoryTabButton(this.f_97735_, this.f_97736_, 176, 73, 20, 22, 128, 0, 1, 3, 96, 0, SwitchInventoryTabPacket.Type.CLIMATE));
        PatchouliIntegration.ifEnabled(() -> this.m_142416_((GuiEventListener)new PlayerInventoryTabButton(this.f_97735_, this.f_97736_, 176, 96, 20, 22, 128, 0, 1, 3, 0, 32, SwitchInventoryTabPacket.Type.BOOK)));
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        FoodData foodData;
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        Player player = ClientHelpers.getPlayer();
        if (player != null && (foodData = player.m_36324_()) instanceof TFCFoodData) {
            TFCFoodData data = (TFCFoodData)foodData;
            NutritionData nutrition = data.getNutrition();
            for (Nutrient nutrient : Nutrient.VALUES) {
                int width = (int)(nutrition.getNutrient(nutrient) * 50.0f);
                graphics.m_280218_(this.texture, this.f_97735_ + 118, this.f_97736_ + 21 + 13 * nutrient.ordinal(), 176, 0, width, 5);
            }
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        for (Nutrient nutrient : Nutrient.VALUES) {
            MutableComponent text = Helpers.translateEnum(nutrient).m_130940_(nutrient.getColor());
            graphics.m_280614_(this.f_96547_, (Component)text, 112 - this.f_96547_.m_92852_((FormattedText)text), 19 + 13 * nutrient.ordinal(), 0x404040, false);
        }
    }
}

