/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.dries007.tfc.world.settings.Settings;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class CreateTFCWorldScreen
extends Screen {
    private final CreateWorldScreen parent;
    private final WorldCreationContext context;
    private OptionsList options;
    private OptionInstance<Boolean> flatBedrock;
    private OptionInstance<Integer> spawnDistance;
    private OptionInstance<Integer> spawnCenterX;
    private OptionInstance<Integer> spawnCenterZ;
    private OptionInstance<Integer> temperatureScale;
    private OptionInstance<Integer> rainfallScale;
    private OptionInstance<Double> temperatureConstant;
    private OptionInstance<Double> rainfallConstant;
    private OptionInstance<Double> continentalness;
    private OptionInstance<Double> grassDensity;

    private static OptionInstance<Double> constOption(String caption, double defaultValue) {
        return new OptionInstance(caption, OptionInstance.m_231498_(), (text, value) -> value > 0.49 && value < 0.51 ? Options.m_231921_((Component)text, (Component)CommonComponents.f_130654_) : Component.m_237110_((String)"options.percent_value", (Object[])new Object[]{text, (int)((value - 0.5) * 200.0)}), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)((1.0 + defaultValue) * 0.5), value -> {});
    }

    private static OptionInstance<Double> pctOption(String caption, double defaultValue) {
        return new OptionInstance(caption, OptionInstance.m_231498_(), (text, value) -> Component.m_237110_((String)"options.percent_value", (Object[])new Object[]{text, (int)((value - 0.5) * 200.0)}), (OptionInstance.ValueSet)OptionInstance.UnitDouble.INSTANCE, (Object)defaultValue, value -> {});
    }

    private static OptionInstance<Integer> kmOption(String caption, int min, int max, int defaultValue) {
        return new OptionInstance(caption, OptionInstance.m_231535_((Component)Component.m_237115_((String)(caption + ".tooltip"))), (text, value) -> Options.m_231921_((Component)text, (Component)Component.m_237110_((String)"tfc.settings.km", (Object[])new Object[]{String.format("%.1f", (double)value.intValue() / 1000.0)})), (OptionInstance.ValueSet)new OptionInstance.IntRange(min, max), (Object)defaultValue, value -> {});
    }

    public CreateTFCWorldScreen(CreateWorldScreen parent, WorldCreationContext context) {
        super((Component)Component.m_237115_((String)"tfc.tooltip.create_world.title"));
        this.parent = parent;
        this.context = context;
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.options.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    protected void m_7856_() {
        assert (this.f_96541_ != null);
        ChunkGenerator generator = this.context.f_243796_().m_246737_();
        Settings settings = ((ChunkGeneratorExtension)generator).settings();
        this.options = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.flatBedrock = OptionInstance.m_231528_((String)"tfc.create_world.flat_bedrock", (boolean)settings.flatBedrock(), value -> {});
        this.spawnDistance = CreateTFCWorldScreen.kmOption("tfc.create_world.spawn_distance", 100, 20000, settings.spawnDistance());
        this.options.m_232530_(this.flatBedrock, this.spawnDistance);
        this.spawnCenterX = CreateTFCWorldScreen.kmOption("tfc.create_world.spawn_center_x", -20000, 20000, settings.spawnCenterX());
        this.spawnCenterZ = CreateTFCWorldScreen.kmOption("tfc.create_world.spawn_center_z", -20000, 20000, settings.spawnCenterZ());
        this.options.m_232530_(this.spawnCenterX, this.spawnCenterZ);
        this.temperatureScale = CreateTFCWorldScreen.kmOption("tfc.create_world.temperature_scale", 0, 40000, settings.temperatureScale());
        this.rainfallScale = CreateTFCWorldScreen.kmOption("tfc.create_world.rainfall_scale", 0, 40000, settings.rainfallScale());
        this.options.m_232530_(this.temperatureScale, this.rainfallScale);
        this.temperatureConstant = CreateTFCWorldScreen.constOption("tfc.create_world.temperature_constant", settings.temperatureConstant());
        this.rainfallConstant = CreateTFCWorldScreen.constOption("tfc.create_world.rainfall_constant", settings.rainfallConstant());
        this.options.m_232530_(this.temperatureConstant, this.rainfallConstant);
        this.continentalness = CreateTFCWorldScreen.pctOption("tfc.create_world.continentalness", settings.continentalness());
        this.grassDensity = CreateTFCWorldScreen.pctOption("tfc.create_world.grass_density", settings.continentalness());
        this.options.m_232530_(this.continentalness, this.grassDensity);
        this.m_7787_((GuiEventListener)this.options);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.applySettings();
            this.f_96541_.m_91152_((Screen)this.parent);
        }).m_252987_(this.f_96543_ / 2 - 155, this.f_96544_ - 28, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.f_96541_.m_91152_((Screen)this.parent)).m_252987_(this.f_96543_ / 2 + 5, this.f_96544_ - 28, 150, 20).m_253136_());
    }

    private void applySettings() {
        ChunkGenerator generator = this.context.f_243796_().m_246737_();
        if (generator instanceof ChunkGeneratorExtension) {
            ChunkGeneratorExtension extension = (ChunkGeneratorExtension)generator;
            extension.applySettings(old -> new Settings((Boolean)this.flatBedrock.m_231551_(), (Integer)this.spawnDistance.m_231551_(), (Integer)this.spawnCenterX.m_231551_(), (Integer)this.spawnCenterZ.m_231551_(), 0.49 < (Double)this.temperatureConstant.m_231551_() && (Double)this.temperatureConstant.m_231551_() < 0.51 ? (Integer)this.temperatureScale.m_231551_() : 0, (float)((Double)this.temperatureConstant.m_231551_() * 2.0 - 1.0), 0.49 < (Double)this.rainfallConstant.m_231551_() && (Double)this.rainfallConstant.m_231551_() < 0.51 ? (Integer)this.rainfallScale.m_231551_() : 0, (float)((Double)this.rainfallConstant.m_231551_() * 2.0 - 1.0), old.rockLayerSettings(), ((Double)this.continentalness.m_231551_()).floatValue(), ((Double)this.grassDensity.m_231551_()).floatValue()));
        }
    }
}

