/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.QuernBlockEntity;
import net.dries007.tfc.common.blocks.rotation.ConnectedAxleBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class QuernBlockEntityRenderer
implements BlockEntityRenderer<QuernBlockEntity> {
    public void render(QuernBlockEntity quern, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Block degrees2;
        Level level = quern.m_58904_();
        IItemHandler inventory = Helpers.getCapability((ICapabilityProvider)quern, Capabilities.ITEM);
        if (inventory == null || level == null) {
            return;
        }
        ItemStack input = inventory.getStackInSlot(1);
        ItemStack output = inventory.getStackInSlot(2);
        ItemStack handstone = inventory.getStackInSlot(0);
        if (!output.m_41619_()) {
            for (int i = 0; i < output.m_41613_(); ++i) {
                double yPos = 0.625;
                stack.m_85836_();
                switch (Math.floorDiv(i, 16)) {
                    case 0: {
                        stack.m_85837_(0.125, yPos, 0.125 + 0.046875 * (double)i);
                        stack.m_252781_(Axis.f_252529_.m_252977_(75.0f));
                        break;
                    }
                    case 1: {
                        stack.m_85837_(0.125 + 0.046875 * (double)(i - 16), yPos, 0.875);
                        stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                        stack.m_252781_(Axis.f_252529_.m_252977_(75.0f));
                        break;
                    }
                    case 2: {
                        stack.m_85837_(0.875, yPos, 0.875 - 0.046875 * (double)(i - 32));
                        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                        stack.m_252781_(Axis.f_252529_.m_252977_(75.0f));
                        break;
                    }
                    case 3: {
                        stack.m_85837_(0.875 - 0.046875 * (double)(i - 48), yPos, 0.125);
                        stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                        stack.m_252781_(Axis.f_252529_.m_252977_(75.0f));
                        break;
                    }
                    default: {
                        stack.m_85837_(0.5, 1.0, 0.5);
                        float degrees2 = ((float)level.m_46467_() + partialTicks) * 4.0f;
                        stack.m_252781_(Axis.f_252436_.m_252977_(degrees2));
                    }
                }
                stack.m_85841_(0.125f, 0.125f, 0.125f);
                Minecraft.m_91087_().m_91291_().m_269128_(output, ItemDisplayContext.FIXED, packedLight, packedOverlay, stack, bufferSource, quern.m_58904_(), 0);
                stack.m_85849_();
            }
        }
        boolean isConnectedToNetwork = quern.isConnectedToNetwork();
        float rotationAngle = quern.getRotationAngle(partialTicks);
        if (isConnectedToNetwork && (degrees2 = level.m_8055_(quern.m_58899_().m_7494_()).m_60734_()) instanceof ConnectedAxleBlock) {
            ConnectedAxleBlock axleBlock = (ConnectedAxleBlock)degrees2;
            VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
            TextureAtlasSprite sprite = RenderHelpers.blockTexture(axleBlock.getAxleTextureLocation());
            stack.m_85836_();
            stack.m_252880_(0.5f, 0.5f, 0.5f);
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            stack.m_252781_(Axis.f_252393_.m_252961_(rotationAngle));
            stack.m_252880_(-0.5f, -0.5f, -0.5f);
            RenderHelpers.renderTexturedCuboid(stack, buffer, sprite, packedLight, packedOverlay, 0.375f, 0.375f, 0.0f, 0.625f, 0.625f, 0.5f, false);
            stack.m_85849_();
        }
        if (!handstone.m_41619_()) {
            float center = !isConnectedToNetwork ? 0.498f + level.f_46441_.m_188501_() * 0.004f : 0.5f;
            stack.m_85836_();
            stack.m_85837_((double)center, 0.705, (double)center);
            stack.m_252781_(Axis.f_252436_.m_252961_(rotationAngle));
            stack.m_252880_(0.5f - center, 0.0f, 0.5f - center);
            stack.m_85841_(1.25f, 1.25f, 1.25f);
            Minecraft.m_91087_().m_91291_().m_269128_(handstone, ItemDisplayContext.FIXED, packedLight, packedOverlay, stack, bufferSource, quern.m_58904_(), 0);
            stack.m_85849_();
        }
        if (!input.m_41619_()) {
            float height = handstone.m_41619_() ? 0.75f : 0.875f;
            stack.m_85836_();
            stack.m_252880_(0.5f, height, 0.5f);
            if (quern.isConnectedToNetwork()) {
                stack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                stack.m_85841_(0.8f, 0.8f, 0.8f);
            } else {
                stack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
                stack.m_85841_(0.5f, 0.5f, 0.5f);
            }
            Minecraft.m_91087_().m_91291_().m_269128_(input, ItemDisplayContext.FIXED, packedLight, packedOverlay, stack, bufferSource, quern.m_58904_(), 0);
            stack.m_85849_();
        }
    }
}

