/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BarrelBlockEntityRenderer
implements BlockEntityRenderer<BarrelBlockEntity> {
    public void render(BarrelBlockEntity barrel, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState state = barrel.m_58900_();
        if (((Boolean)state.m_61143_((Property)BarrelBlock.SEALED)).booleanValue() || state.m_61143_(BarrelBlock.FACING) != Direction.UP) {
            return;
        }
        barrel.getCapability(Capabilities.FLUID).map(handler -> handler.getFluidInTank(0)).filter(fluid -> !fluid.isEmpty()).ifPresent(fluidStack -> {
            float fillPercent = (float)fluidStack.getAmount() / (float)((Integer)TFCConfig.SERVER.barrelCapacity.get()).intValue();
            float subtract = (double)fillPercent > 0.03 ? 0.0f : (0.03f - fillPercent) * 7.0f;
            RenderHelpers.renderFluidFace(poseStack, fluidStack, buffer, 0.1875f + subtract, 0.1875f + subtract, 0.8125f - subtract, 0.8125f - subtract, 0.140625f + 0.734375f * fillPercent, combinedOverlay, combinedLight);
        });
        barrel.getCapability(Capabilities.ITEM).map(inv -> inv.getStackInSlot(2)).filter(item -> !item.m_41619_()).ifPresent(itemStack -> {
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 0.15625f, 0.5f);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, barrel.m_58904_(), 0);
            poseStack.m_85849_();
        });
    }
}

