/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.dries007.tfc.common.entities.livestock.horse.TFCChestedHorse;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class HorseChestLayer<T extends TFCChestedHorse, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final Map<Item, ResourceLocation> MAP = new HashMap<Item, ResourceLocation>();
    private static final ResourceLocation DEFAULT_CHEST_TEXTURE = Helpers.identifier("textures/entity/chest/horse/oak.png");
    private final M model;

    public static void registerChest(Item item, ResourceLocation location) {
        MAP.put(item, location);
    }

    public HorseChestLayer(RenderLayerParent<T, M> parent, M model) {
        super(parent);
        this.model = model;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float yaw, float pitch) {
        if (!((TFCChestedHorse)entity).getChestItem().m_41619_()) {
            this.m_117386_().m_102624_(this.model);
            this.model.m_6839_(entity, limbSwing, limbSwingAmount, partialTick);
            this.model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, yaw, pitch);
            VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTexture(entity)));
            this.model.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private ResourceLocation getTexture(T entity) {
        Item item = ((TFCChestedHorse)entity).getChestItem().m_41720_();
        if (MAP.containsKey(item)) {
            return MAP.get(item);
        }
        return DEFAULT_CHEST_TEXTURE;
    }
}

