/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.SimpleStaticBlockEntityModel;
import net.dries007.tfc.common.blockentities.SheetPileBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.devices.SheetPileBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public enum SheetPileBlockModel implements SimpleStaticBlockEntityModel<SheetPileBlockModel, SheetPileBlockEntity>
{
    INSTANCE;


    @Override
    public TextureAtlasSprite render(SheetPileBlockEntity pile, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        BlockState state = pile.m_58900_();
        TextureAtlasSprite sprite = null;
        Function textureAtlas = Minecraft.m_91087_().m_91258_(RenderHelpers.BLOCKS_ATLAS);
        for (Direction direction : Helpers.DIRECTIONS) {
            if (!((Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty(direction))).booleanValue()) continue;
            Metal metal = pile.getOrCacheMetal(direction);
            sprite = (TextureAtlasSprite)textureAtlas.apply(metal.getTextureId());
            this.renderSheet(poseStack, sprite, buffer, direction, packedLight, packedOverlay);
        }
        if (sprite == null) {
            sprite = RenderHelpers.missingTexture();
        }
        return sprite;
    }

    @Override
    public BlockEntityType<SheetPileBlockEntity> type() {
        return (BlockEntityType)TFCBlockEntities.SHEET_PILE.get();
    }

    @Override
    public int faces(SheetPileBlockEntity blockEntity) {
        return 36;
    }

    private void renderSheet(PoseStack poseStack, TextureAtlasSprite sprite, VertexConsumer buffer, Direction direction, int packedLight, int packedOverlay) {
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, SheetPileBlock.getShapeForSingleFace(direction).m_83215_());
    }
}

