/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCArmorMaterials;
import net.dries007.tfc.common.entities.aquatic.Fish;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.common.util.ForgeSoundType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public final class TFCSounds {
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((ResourceKey)Registries.f_256840_, (String)"tfc");
    public static final RegistryObject<SoundEvent> KNAP_STONE = TFCSounds.create("item.knapping.stone");
    public static final RegistryObject<SoundEvent> KNAP_CLAY = TFCSounds.create("item.knapping.clay");
    public static final RegistryObject<SoundEvent> KNAP_LEATHER = TFCSounds.create("item.knapping.leather");
    public static final RegistryObject<SoundEvent> FIRESTARTER = TFCSounds.create("item.firestarter.use");
    public static final RegistryObject<SoundEvent> CERAMIC_BREAK = TFCSounds.create("item.ceramic.break");
    public static final RegistryObject<SoundEvent> JUG_BLOW = TFCSounds.create("item.jug.blow");
    public static final RegistryObject<SoundEvent> PANNING = TFCSounds.create("item.pan.use");
    public static final RegistryObject<SoundEvent> FERTILIZER_USE = TFCSounds.create("item.fertilizer.use");
    public static final RegistryObject<SoundEvent> JAVELIN_HIT = TFCSounds.create("item.javelin.hit");
    public static final RegistryObject<SoundEvent> JAVELIN_HIT_GROUND = TFCSounds.create("item.javelin.hit_ground");
    public static final RegistryObject<SoundEvent> JAVELIN_THROWN = TFCSounds.create("item.javelin.throw");
    public static final RegistryObject<SoundEvent> ITEM_COOL = TFCSounds.create("item.cool");
    public static final RegistryObject<SoundEvent> QUERN_DRAG = TFCSounds.create("block.quern.drag");
    public static final RegistryObject<SoundEvent> LOOM_WEAVE = TFCSounds.create("block.loom.weave");
    public static final RegistryObject<SoundEvent> TOOL_RACK_PLACE = TFCSounds.create("block.tool_rack.place");
    public static final RegistryObject<SoundEvent> BELLOWS_BLOW = TFCSounds.create("block.bellows.blow");
    public static final RegistryObject<SoundEvent> SCRIBING_TABLE = TFCSounds.create("block.scribing_table.use");
    public static final RegistryObject<SoundEvent> OPEN_BARREL = TFCSounds.create("block.barrel.open");
    public static final RegistryObject<SoundEvent> CLOSE_BARREL = TFCSounds.create("block.barrel.close");
    public static final RegistryObject<SoundEvent> OPEN_VESSEL = TFCSounds.create("block.large_vessel.open");
    public static final RegistryObject<SoundEvent> CLOSE_VESSEL = TFCSounds.create("block.large_vessel.close");
    public static final RegistryObject<SoundEvent> WATTLE_DYED = TFCSounds.create("block.wattle.dyed");
    public static final RegistryObject<SoundEvent> WATTLE_DAUBED = TFCSounds.create("block.wattle.daubed");
    public static final RegistryObject<SoundEvent> WATTLE_WOVEN = TFCSounds.create("block.wattle.woven");
    public static final RegistryObject<SoundEvent> ANVIL_HIT = TFCSounds.create("block.anvil.hit");
    public static final RegistryObject<SoundEvent> CROP_STICK_ADD = TFCSounds.create("block.crop.stick_add");
    public static final RegistryObject<SoundEvent> BLOOMERY_CRACKLE = TFCSounds.create("block.bloomery.crackle");
    public static final RegistryObject<SoundEvent> BARREL_DRIP = TFCSounds.create("block.barrel.drip");
    public static final Map<TFCArmorMaterials, RegistryObject<SoundEvent>> ARMOR_EQUIP = Helpers.mapOfKeys(TFCArmorMaterials.class, mat -> TFCSounds.create("item.armor.equip_" + mat.getId().m_135815_()));
    public static final ForgeSoundType CHARCOAL = TFCSounds.createBlock("charcoal");
    public static final ForgeSoundType THATCH = TFCSounds.createBlock("thatch");
    public static final ForgeSoundType PEAT = TFCSounds.createBlock("peat");
    public static final ForgeSoundType THIN = TFCSounds.createBlock("thin");
    public static final EntitySound PIG = new EntitySound(() -> SoundEvents.f_12233_, () -> SoundEvents.f_12234_, () -> SoundEvents.f_12235_, () -> SoundEvents.f_12237_);
    public static final EntitySound COW = new EntitySound(() -> SoundEvents.f_11830_, () -> SoundEvents.f_11831_, () -> SoundEvents.f_11832_, () -> SoundEvents.f_11834_);
    public static final EntitySound CHICKEN = new EntitySound(() -> SoundEvents.f_11750_, () -> SoundEvents.f_11751_, () -> SoundEvents.f_11753_, () -> SoundEvents.f_11754_);
    public static final EntitySound GOAT = new EntitySound(() -> SoundEvents.f_144163_, () -> SoundEvents.f_144164_, () -> SoundEvents.f_144166_, () -> SoundEvents.f_144151_);
    public static final EntitySound SHEEP = new EntitySound(() -> SoundEvents.f_12341_, () -> SoundEvents.f_12342_, () -> SoundEvents.f_12343_, () -> SoundEvents.f_12345_);
    public static final EntitySound DONKEY = new EntitySound(() -> SoundEvents.f_11809_, () -> SoundEvents.f_11812_, () -> SoundEvents.f_11814_, () -> SoundEvents.f_12035_);
    public static final EntitySound MULE = new EntitySound(() -> SoundEvents.f_12076_, () -> SoundEvents.f_12079_, () -> SoundEvents.f_12081_, () -> SoundEvents.f_12035_);
    public static final EntitySound HORSE = new EntitySound(() -> SoundEvents.f_11971_, () -> SoundEvents.f_11975_, () -> SoundEvents.f_11978_, () -> SoundEvents.f_12035_);
    public static final EntitySound CAT = new EntitySound(() -> SoundEvents.f_11785_, () -> SoundEvents.f_11787_, () -> SoundEvents.f_11791_, () -> SoundEvents.f_11754_, Optional.of(() -> SoundEvents.f_11789_), Optional.of(() -> SoundEvents.f_11792_));
    public static final EntitySound TURTLE = new EntitySound(() -> SoundEvents.f_12530_, () -> SoundEvents.f_12531_, () -> SoundEvents.f_12536_, () -> SoundEvents.f_12487_);
    public static final EntitySound DOG = TFCSounds.createEntity("dog", true, true);
    public static final EntitySound TFC_WOLF = TFCSounds.createEntity("tfc_wolf", true, true);
    public static final EntitySound HYENA = TFCSounds.createEntity("hyena", true, true);
    public static final EntitySound ALPACA = TFCSounds.createEntity("alpaca", false, false);
    public static final EntitySound YAK = TFCSounds.createEntity("yak", false, false);
    public static final EntitySound MUSK_OX = TFCSounds.createEntity("musk_ox", false, false);
    public static final EntitySound DUCK = TFCSounds.createEntity("duck", false, false);
    public static final EntitySound PENGUIN = TFCSounds.createEntity("penguin", false, false);
    public static final EntitySound QUAIL = TFCSounds.createEntity("quail", false, false);
    public static final EntitySound LION = TFCSounds.createEntity("lion", true, true);
    public static final EntitySound COUGAR = TFCSounds.createEntity("cougar", true, true);
    public static final EntitySound SABERTOOTH = TFCSounds.createEntity("sabertooth", true, true);
    public static final EntitySound TIGER = TFCSounds.createEntity("tiger", true, true);
    public static final EntitySound CROCODILE = TFCSounds.createEntity("crocodile", true, true);
    public static final EntitySound BEAR = TFCSounds.createEntity("bear", true, true);
    public static final EntitySound DEER = TFCSounds.createEntity("deer", false, false);
    public static final EntitySound BOAR = TFCSounds.createEntity("boar", true, false);
    public static final EntitySound WILDEBEEST = TFCSounds.createEntity("wildebeest", true, false);
    public static final EntitySound MOOSE = TFCSounds.createEntity("moose", true, false);
    public static final EntitySound GROUSE = TFCSounds.createEntity("grouse", false, false);
    public static final EntitySound PHEASANT = TFCSounds.createEntity("pheasant", false, false);
    public static final EntitySound TURKEY = TFCSounds.createEntity("turkey", false, false);
    public static final EntitySound PEAFOWL = TFCSounds.createEntity("peafowl", false, false);
    public static final EntitySound RAT = TFCSounds.createEntity("rat", false, false);
    public static final EntitySound BONGO = TFCSounds.createEntity("bongo", false, false);
    public static final EntitySound CARIBOU = TFCSounds.createEntity("caribou", false, false);
    public static final EntitySound GAZELLE = TFCSounds.createEntity("gazelle", false, false);
    public static final FishSound MANATEE = TFCSounds.createFish("manatee");
    public static final FishSound JELLYFISH = TFCSounds.createFish("jellyfish");
    public static final Map<Fish, FishSound> FRESHWATER_FISHES = Helpers.mapOfKeys(Fish.class, Fish::makeSound);
    public static final RegistryObject<SoundEvent> ROOSTER_CRY = TFCSounds.create("entity.rooster.cry");
    public static final RegistryObject<SoundEvent> RAMMING_IMPACT = TFCSounds.create("entity.ramming.impact");
    public static final RegistryObject<SoundEvent> ROCK_SLIDE_LONG = TFCSounds.create("random.rock_slide_long");
    public static final RegistryObject<SoundEvent> ROCK_SLIDE_LONG_FAKE = TFCSounds.create("random.rock_slide_long_fake");
    public static final RegistryObject<SoundEvent> ROCK_SLIDE_SHORT = TFCSounds.create("random.rock_slide_short");
    public static final RegistryObject<SoundEvent> DIRT_SLIDE_SHORT = TFCSounds.create("random.dirt_slide_short");
    public static final RegistryObject<SoundEvent> ROCK_SMASH = TFCSounds.create("random.rock_smash");

    private static RegistryObject<SoundEvent> create(String name) {
        return SOUNDS.register(name, () -> SoundEvent.m_262824_((ResourceLocation)Helpers.identifier(name)));
    }

    private static Optional<Supplier<SoundEvent>> createOptional(String name, boolean present) {
        return Optional.ofNullable(present ? TFCSounds.create(name) : null);
    }

    private static ForgeSoundType createBlock(String name) {
        return new ForgeSoundType(1.0f, 1.0f, TFCSounds.create("block.%s.break".formatted(name)), TFCSounds.create("block.%s.step".formatted(name)), TFCSounds.create("block.%s.place".formatted(name)), TFCSounds.create("block.%s.hit".formatted(name)), TFCSounds.create("block.%s.fall".formatted(name)));
    }

    private static EntitySound createEntity(String name, boolean attack, boolean sleep) {
        return new EntitySound((Supplier<SoundEvent>)TFCSounds.create("entity.%s.ambient".formatted(name)), (Supplier<SoundEvent>)TFCSounds.create("entity.%s.death".formatted(name)), (Supplier<SoundEvent>)TFCSounds.create("entity.%s.hurt".formatted(name)), (Supplier<SoundEvent>)TFCSounds.create("entity.%s.step".formatted(name)), TFCSounds.createOptional("entity.%s.attack".formatted(name), attack), TFCSounds.createOptional("entity.%s.sleep".formatted(name), sleep));
    }

    public static FishSound createFish(String name) {
        return new FishSound((Supplier<SoundEvent>)TFCSounds.create("entity.%s.ambient".formatted(name)), (Supplier<SoundEvent>)TFCSounds.create("entity.%s.death".formatted(name)), (Supplier<SoundEvent>)TFCSounds.create("entity.%s.hurt".formatted(name)), (Supplier<SoundEvent>)TFCSounds.create("entity.%s.flop".formatted(name)));
    }

    public record EntitySound(Supplier<SoundEvent> ambient, Supplier<SoundEvent> death, Supplier<SoundEvent> hurt, Supplier<SoundEvent> step, Optional<Supplier<SoundEvent>> attack, Optional<Supplier<SoundEvent>> sleep) {
        public EntitySound(Supplier<SoundEvent> ambient, Supplier<SoundEvent> death, Supplier<SoundEvent> hurt, Supplier<SoundEvent> step) {
            this(ambient, death, hurt, step, Optional.empty(), Optional.empty());
        }
    }

    public record FishSound(Supplier<SoundEvent> ambient, Supplier<SoundEvent> death, Supplier<SoundEvent> hurt, Supplier<SoundEvent> flop) {
    }
}

