/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public final class RenderHelpers {
    public static final ResourceLocation BLOCKS_ATLAS = TextureAtlas.f_118259_;
    public static final Button.CreateNarration NARRATION = Supplier::get;

    public static TextureAtlasSprite missingTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(BLOCKS_ATLAS).apply(MissingTextureAtlasSprite.m_118071_());
    }

    public static TextureAtlasSprite blockTexture(ResourceLocation textureLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(BLOCKS_ATLAS).apply(textureLocation);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, AABB bounds) {
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, (float)bounds.f_82288_, (float)bounds.f_82289_, (float)bounds.f_82290_, (float)bounds.f_82291_, (float)bounds.f_82292_, (float)bounds.f_82293_);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, minX, minY, minZ, maxX, maxY, maxZ, 16.0f * (maxX - minX), 16.0f * (maxY - minY), 16.0f * (maxZ - minZ), true);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, boolean doShade) {
        RenderHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, minX, minY, minZ, maxX, maxY, maxZ, 16.0f * (maxX - minX), 16.0f * (maxY - minY), 16.0f * (maxZ - minZ), doShade);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float xPixels, float yPixels, float zPixels, boolean doShade) {
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getXVertices(minX, minY, minZ, maxX, maxY, maxZ), zPixels, yPixels, 1.0f, 0.0f, 0.0f, doShade);
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getYVertices(minX, minY, minZ, maxX, maxY, maxZ), zPixels, xPixels, 0.0f, 1.0f, 0.0f, doShade);
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getZVertices(minX, minY, minZ, maxX, maxY, maxZ), xPixels, yPixels, 0.0f, 0.0f, 1.0f, doShade);
    }

    public static void renderTexturedTrapezoidalCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float pMinX, float pMaxX, float pMinZ, float pMaxZ, float qMinX, float qMaxX, float qMinZ, float qMaxZ, float minY, float maxY, float xPixels, float yPixels, float zPixels, boolean invertNormal) {
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getTrapezoidalCuboidXVertices(pMinX, pMaxX, pMinZ, pMaxZ, qMinX, qMaxX, qMinZ, qMaxZ, minY, maxY), zPixels, yPixels, invertNormal ? 0.0f : 1.0f, 0.0f, invertNormal ? 1.0f : 0.0f, true);
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getTrapezoidalCuboidYVertices(pMinX, pMaxX, pMinZ, pMaxZ, qMinX, qMaxX, qMinZ, qMaxZ, minY, maxY), zPixels, xPixels, 0.0f, 1.0f, 0.0f, true);
        RenderHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getTrapezoidalCuboidZVertices(pMinX, pMaxX, pMinZ, pMaxZ, qMinX, qMaxX, qMinZ, qMaxZ, minY, maxY), xPixels, yPixels, invertNormal ? 1.0f : 0.0f, 0.0f, invertNormal ? 0.0f : 1.0f, true);
    }

    public static void renderTexturedQuads(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float[][] vertices, float uSize, float vSize, float normalX, float normalY, float normalZ, boolean doShade) {
        for (float[] v : vertices) {
            RenderHelpers.renderTexturedVertex(poseStack, buffer, packedLight, packedOverlay, v[0], v[1], v[2], sprite.m_118367_((double)(v[3] * uSize)), sprite.m_118393_((double)(v[4] * vSize)), v[5] * normalX, v[5] * normalY, v[5] * normalZ, doShade);
        }
    }

    public static void renderTexturedVertex(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ) {
        RenderHelpers.renderTexturedVertex(poseStack, buffer, packedLight, packedOverlay, x, y, z, u, v, normalX, normalY, normalZ, true);
    }

    public static void renderTexturedVertex(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ, boolean doShade) {
        float shade = doShade ? RenderHelpers.getShade(normalX, normalY, normalZ) : 1.0f;
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z).m_85950_(shade, shade, shade, 1.0f).m_7421_(u, v).m_85969_(packedLight).m_86008_(packedOverlay).m_252939_(poseStack.m_85850_().m_252943_(), normalX, normalY, normalZ).m_5752_();
    }

    public static float getShade(float normalX, float normalY, float normalZ) {
        return RenderHelpers.getShadeForStep(Math.round(normalX), Math.round(normalY), Math.round(normalZ));
    }

    public static float getShadeForStep(int normalX, int normalY, int normalZ) {
        if (normalY == 1) {
            return 1.0f;
        }
        if (normalY == -1) {
            return 0.5f;
        }
        if (normalZ != 0) {
            return 0.8f;
        }
        if (normalX != 0) {
            return 0.6f;
        }
        return 1.0f;
    }

    public static float[][] getXVertices(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return new float[][]{{minX, minY, minZ, 0.0f, 1.0f, 1.0f}, {minX, minY, maxZ, 1.0f, 1.0f, 1.0f}, {minX, maxY, maxZ, 1.0f, 0.0f, 1.0f}, {minX, maxY, minZ, 0.0f, 0.0f, 1.0f}, {maxX, minY, maxZ, 1.0f, 0.0f, -1.0f}, {maxX, minY, minZ, 0.0f, 0.0f, -1.0f}, {maxX, maxY, minZ, 0.0f, 1.0f, -1.0f}, {maxX, maxY, maxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static float[][] getYVertices(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return new float[][]{{minX, maxY, minZ, 0.0f, 1.0f, 1.0f}, {minX, maxY, maxZ, 1.0f, 1.0f, 1.0f}, {maxX, maxY, maxZ, 1.0f, 0.0f, 1.0f}, {maxX, maxY, minZ, 0.0f, 0.0f, 1.0f}, {minX, minY, maxZ, 1.0f, 0.0f, -1.0f}, {minX, minY, minZ, 0.0f, 0.0f, -1.0f}, {maxX, minY, minZ, 0.0f, 1.0f, -1.0f}, {maxX, minY, maxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static float[][] getZVertices(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        return new float[][]{{maxX, minY, minZ, 0.0f, 1.0f, 1.0f}, {minX, minY, minZ, 1.0f, 1.0f, 1.0f}, {minX, maxY, minZ, 1.0f, 0.0f, 1.0f}, {maxX, maxY, minZ, 0.0f, 0.0f, 1.0f}, {minX, minY, maxZ, 1.0f, 0.0f, -1.0f}, {maxX, minY, maxZ, 0.0f, 0.0f, -1.0f}, {maxX, maxY, maxZ, 0.0f, 1.0f, -1.0f}, {minX, maxY, maxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static float[][] getDiagonalPlaneVertices(float x1, float y1, float z1, float x2, float y2, float z2, float u1, float v1, float u2, float v2) {
        return new float[][]{{x1, y1, z1, u1, v1}, {x2, y1, z1, u2, v1}, {x2, y2, z2, u2, v2}, {x1, y2, z2, u1, v2}, {x2, y1, z1, u2, v1}, {x1, y1, z1, u1, v1}, {x1, y2, z2, u1, v2}, {x2, y2, z2, u2, v2}};
    }

    public static float[][] getTrapezoidalCuboidXVertices(float pMinX, float pMaxX, float pMinZ, float pMaxZ, float qMinX, float qMaxX, float qMinZ, float qMaxZ, float minY, float maxY) {
        return new float[][]{{pMinX, minY, pMinZ, 0.0f, 1.0f, 1.0f}, {pMinX, minY, pMaxZ, 1.0f, 1.0f, 1.0f}, {qMinX, maxY, qMaxZ, 1.0f, 0.0f, 1.0f}, {qMinX, maxY, qMinZ, 0.0f, 0.0f, 1.0f}, {pMaxX, minY, pMaxZ, 1.0f, 0.0f, -1.0f}, {pMaxX, minY, pMinZ, 0.0f, 0.0f, -1.0f}, {qMaxX, maxY, qMinZ, 0.0f, 1.0f, -1.0f}, {qMaxX, maxY, qMaxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static float[][] getTrapezoidalCuboidYVertices(float pMinX, float pMaxX, float pMinZ, float pMaxZ, float qMinX, float qMaxX, float qMinZ, float qMaxZ, float minY, float maxY) {
        return new float[][]{{qMinX, maxY, qMinZ, 0.0f, 1.0f, 1.0f}, {qMinX, maxY, qMaxZ, 1.0f, 1.0f, 1.0f}, {qMaxX, maxY, qMaxZ, 1.0f, 0.0f, 1.0f}, {qMaxX, maxY, qMinZ, 0.0f, 0.0f, 1.0f}, {pMinX, minY, pMaxZ, 1.0f, 0.0f, -1.0f}, {pMinX, minY, pMinZ, 0.0f, 0.0f, -1.0f}, {pMaxX, minY, pMinZ, 0.0f, 1.0f, -1.0f}, {pMaxX, minY, pMaxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static float[][] getTrapezoidalCuboidZVertices(float pMinX, float pMaxX, float pMinZ, float pMaxZ, float qMinX, float qMaxX, float qMinZ, float qMaxZ, float minY, float maxY) {
        return new float[][]{{pMaxX, minY, pMinZ, 0.0f, 1.0f, 1.0f}, {pMinX, minY, pMinZ, 1.0f, 1.0f, 1.0f}, {qMinX, maxY, qMinZ, 1.0f, 0.0f, 1.0f}, {qMaxX, maxY, qMinZ, 0.0f, 0.0f, 1.0f}, {pMinX, minY, pMaxZ, 1.0f, 0.0f, -1.0f}, {pMaxX, minY, pMaxZ, 0.0f, 0.0f, -1.0f}, {qMaxX, maxY, qMaxZ, 0.0f, 1.0f, -1.0f}, {qMinX, maxY, qMaxZ, 1.0f, 1.0f, -1.0f}};
    }

    public static void setShaderColor(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void setShaderColor(GuiGraphics graphics, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        graphics.m_280246_(r, g, b, a);
    }

    public static void renderTwoHandedItem(PoseStack poseStack, MultiBufferSource source, int combinedLight, float pitch, float equipProgress, float swingProgress, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        float swingSqrt = Mth.m_14116_((float)swingProgress);
        float y = -0.2f * Mth.m_14031_((float)(swingProgress * (float)Math.PI));
        float z = -0.4f * Mth.m_14031_((float)(swingSqrt * (float)Math.PI));
        poseStack.m_85837_(0.0, (double)(-y / 2.0f), (double)z);
        float tilt = RenderHelpers.calculateTilt(pitch);
        poseStack.m_85837_(0.0, (double)(0.04f + equipProgress * -1.2f + tilt * -0.5f), (double)-0.72f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14036_((float)tilt, (float)0.3f, (float)0.51f) * 85.0f));
        if (!mc.f_91074_.m_20145_()) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            RenderHelpers.renderMapHand(mc, poseStack, source, combinedLight, HumanoidArm.RIGHT);
            RenderHelpers.renderMapHand(mc, poseStack, source, combinedLight, HumanoidArm.LEFT);
            poseStack.m_85849_();
        }
        RenderHelpers.addSiftingMovement(mc.f_91074_, poseStack);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)(swingSqrt * (float)Math.PI)) * 20.0f));
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        boolean right = mc.f_91074_.m_5737_() == HumanoidArm.RIGHT;
        mc.m_91290_().m_234586_().m_269530_((LivingEntity)mc.f_91074_, stack, right ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, !right, poseStack, source, combinedLight);
    }

    public static void renderArmWithBlowpipe(PlayerItemInHandLayer<?, ?> layer, ItemInHandRenderer handRenderer, LivingEntity entity, ItemStack stack, HumanoidArm arm, PoseStack poseStack, MultiBufferSource buffers, int light) {
        poseStack.m_85836_();
        ModelPart modelpart = ((HeadedModel)layer.m_117386_()).m_5585_();
        float f = modelpart.f_104203_;
        modelpart.f_104203_ = Mth.m_14036_((float)modelpart.f_104203_, (float)-0.5235988f, (float)1.5707964f);
        modelpart.m_104299_(poseStack);
        modelpart.f_104203_ = f;
        CustomHeadLayer.m_174483_((PoseStack)poseStack, (boolean)false);
        boolean lefty = arm == HumanoidArm.LEFT;
        poseStack.m_252880_((lefty ? -2.3f : 2.3f) / 16.0f, -0.1625f, 0.0f);
        handRenderer.m_269530_(entity, stack, ItemDisplayContext.HEAD, false, poseStack, buffers, light);
        poseStack.m_85849_();
    }

    public static ModelLayerLocation modelIdentifier(String name, String part) {
        return new ModelLayerLocation(Helpers.identifier(name), part);
    }

    public static ModelLayerLocation modelIdentifier(String name) {
        return RenderHelpers.modelIdentifier(name, "main");
    }

    public static ModelPart bakeSimple(EntityRendererProvider.Context ctx, String layerName) {
        return ctx.m_174023_(RenderHelpers.modelIdentifier(layerName));
    }

    public static float itemTimeRotation() {
        return (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
    }

    public static int getHeatedBrightness(ItemStack stack, int combinedLight) {
        float heat = Math.min(HeatCapability.getTemperature(stack) / 400.0f, 1.0f);
        return Math.max(combinedLight, (int)(heat * 1.572888E7f));
    }

    public static float getRotationSpeed(int ticks, float partialTicks) {
        return ((float)ticks + partialTicks) * 4.0f;
    }

    public static int getFluidColor(FluidStack fluid) {
        return RenderHelpers.getFluidColor(fluid.getFluid());
    }

    public static int getFluidColor(Fluid fluid) {
        return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
    }

    public static void renderFluidFace(PoseStack poseStack, FluidStack fluidStack, MultiBufferSource buffer, float minX, float minZ, float maxX, float maxZ, float y, int combinedOverlay, int combinedLight) {
        RenderHelpers.renderFluidFace(poseStack, fluidStack, buffer, RenderHelpers.getFluidColor(fluidStack), minX, minZ, maxX, maxZ, y, combinedOverlay, combinedLight);
    }

    public static void renderFluidFace(PoseStack poseStack, FluidStack fluidStack, MultiBufferSource buffer, int color, float minX, float minZ, float maxX, float maxZ, float y, int combinedOverlay, int combinedLight) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions extension = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation texture = extension.getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(BLOCKS_ATLAS).apply(texture);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110470_((ResourceLocation)BLOCKS_ATLAS));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        builder.m_252986_(matrix4f, minX, y, minZ).m_193479_(color).m_7421_(sprite.m_118367_((double)(minX * 16.0f)), sprite.m_118393_((double)(minZ * 16.0f))).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, minX, y, maxZ).m_193479_(color).m_7421_(sprite.m_118367_((double)(minX * 16.0f)), sprite.m_118393_((double)(maxZ * 16.0f))).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, maxX, y, maxZ).m_193479_(color).m_7421_(sprite.m_118367_((double)(maxX * 16.0f)), sprite.m_118393_((double)(maxZ * 16.0f))).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, maxX, y, minZ).m_193479_(color).m_7421_(sprite.m_118367_((double)(maxX * 16.0f)), sprite.m_118393_((double)(minX * 16.0f))).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderTexturedFace(PoseStack poseStack, MultiBufferSource buffer, int color, float minX, float minZ, float maxX, float maxZ, float y, int combinedOverlay, int combinedLight, ResourceLocation texture, boolean transparent) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(BLOCKS_ATLAS).apply(texture);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f norm = poseStack.m_85850_().m_252943_();
        builder.m_252986_(matrix4f, minX, y, minZ).m_193479_(color).m_7421_(sprite.m_118367_((double)(minX * 16.0f)), sprite.m_118393_((double)(minZ * 16.0f))).m_86008_(combinedOverlay).m_85969_(combinedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, minX, y, maxZ).m_193479_(color).m_7421_(sprite.m_118367_((double)(minX * 16.0f)), sprite.m_118393_((double)(maxZ * 16.0f))).m_86008_(combinedOverlay).m_85969_(combinedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, maxX, y, maxZ).m_193479_(color).m_7421_(sprite.m_118367_((double)(maxX * 16.0f)), sprite.m_118393_((double)(maxZ * 16.0f))).m_86008_(combinedOverlay).m_85969_(combinedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(matrix4f, maxX, y, minZ).m_193479_(color).m_7421_(sprite.m_118367_((double)(maxX * 16.0f)), sprite.m_118393_((double)(minX * 16.0f))).m_86008_(combinedOverlay).m_85969_(combinedLight).m_252939_(norm, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static boolean renderGhostBlock(Level level, BlockState state, BlockPos lookPos, PoseStack stack, MultiBufferSource buffer, boolean shouldGrowSlightly, int alpha) {
        Minecraft mc = Minecraft.m_91087_();
        BlockModelShaper shaper = mc.m_91289_().m_110907_();
        BakedModel model = shaper.m_110893_(state);
        if (model == shaper.m_110881_().m_119409_()) {
            return false;
        }
        RandomSource random = RandomSource.m_216327_();
        RenderType rt = Sheets.m_110792_();
        IGhostBlockHandler.ForcedAlphaVertexConsumer builder = new IGhostBlockHandler.ForcedAlphaVertexConsumer(buffer.m_6299_(rt), alpha);
        stack.m_85836_();
        Vec3 camera = mc.f_91063_.m_109153_().m_90583_();
        Vec3 offset = Vec3.m_82528_((Vec3i)lookPos).m_82546_(camera);
        stack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        if (shouldGrowSlightly) {
            stack.m_252880_(-0.005f, -0.005f, -0.005f);
            stack.m_85841_(1.01f, 1.01f, 1.01f);
        }
        BlockRenderDispatcher br = Minecraft.m_91087_().m_91289_();
        for (RenderType type : model.getRenderTypes(state, random, ModelData.EMPTY)) {
            br.renderBatched(state, lookPos, (BlockAndTintGetter)level, stack, (VertexConsumer)builder, false, random, ModelData.EMPTY, type);
        }
        RenderSystem.enableCull();
        ((MultiBufferSource.BufferSource)buffer).m_109912_(rt);
        stack.m_85849_();
        return true;
    }

    public static ResourceLocation getTextureForAge(TFCAnimal animal, ResourceLocation young, ResourceLocation old) {
        return animal.getAgeType() == TFCAnimalProperties.Age.OLD ? old : young;
    }

    public static TextureAtlasSprite getAndBindFluidSprite(FluidStack fluid) {
        RenderHelpers.setShaderColor(RenderHelpers.getFluidColor(fluid));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid));
    }

    public static void fillAreaWithSprite(GuiGraphics stack, TextureAtlasSprite sprite, int x, int y, int regionWidth, int regionHeight, int spriteWidth, int spriteHeight) {
        int tileWidth = Helpers.ceilDiv(regionWidth, spriteWidth);
        int tileHeight = Helpers.ceilDiv(regionHeight, spriteHeight);
        for (int tileX = 0; tileX < tileWidth; ++tileX) {
            for (int tileY = 0; tileY < tileHeight; ++tileY) {
                int offsetX = tileX * spriteWidth;
                int offsetY = tileY * spriteHeight;
                int actualWidth = Math.min(spriteWidth, regionWidth - offsetX);
                int actualHeight = Math.min(spriteHeight, regionHeight - offsetY);
                float widthRatio = (float)actualWidth / (float)spriteWidth;
                float heightRatio = (float)actualHeight / (float)spriteHeight;
                RenderHelpers.blit(stack, x + offsetX, y + offsetY, actualWidth, actualHeight, sprite.m_118409_(), sprite.m_118367_((double)(16.0f * widthRatio)), sprite.m_118411_(), sprite.m_118393_((double)(16.0f * heightRatio)));
            }
        }
    }

    public static void blit(GuiGraphics stack, int x, int y, int width, int height, float minU, float maxU, float minV, float maxV) {
        RenderHelpers.blit(stack.m_280168_().m_85850_().m_252922_(), x, x + width, y, y + height, 0, minU, maxU, minV, maxV);
    }

    public static void blit(Matrix4f pose, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_252986_(pose, (float)x1, (float)y2, (float)blitOffset).m_7421_(minU, maxV).m_5752_();
        builder.m_252986_(pose, (float)x2, (float)y2, (float)blitOffset).m_7421_(maxU, maxV).m_5752_();
        builder.m_252986_(pose, (float)x2, (float)y1, (float)blitOffset).m_7421_(maxU, minV).m_5752_();
        builder.m_252986_(pose, (float)x1, (float)y1, (float)blitOffset).m_7421_(minU, minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public static boolean isInside(int mouseX, int mouseY, int leftX, int topY, int width, int height) {
        return mouseX >= leftX && mouseX <= leftX + width && mouseY >= topY && mouseY <= topY + height;
    }

    private static float calculateTilt(float pitch) {
        float deg = Mth.m_14036_((float)(1.0f - pitch / 45.0f + 0.1f), (float)0.0f, (float)1.0f) * (float)Math.PI;
        return -Mth.m_14089_((float)deg) * 0.5f + 0.5f;
    }

    private static void renderMapHand(Minecraft mc, PoseStack poseStack, MultiBufferSource source, int combinedLight, HumanoidArm arm) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)mc.f_91074_.m_108560_());
        PlayerRenderer playerrenderer = (PlayerRenderer)mc.m_91290_().m_114382_((Entity)mc.f_91074_);
        poseStack.m_85836_();
        float side = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(92.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(45.0f));
        float degrees = side * -41.0f + RenderHelpers.calculateArmMovement(mc.f_91074_);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(degrees));
        poseStack.m_85837_((double)side * 0.3, -1.1, 0.45);
        if (arm == HumanoidArm.RIGHT) {
            playerrenderer.m_117770_(poseStack, source, combinedLight, (AbstractClientPlayer)mc.f_91074_);
        } else {
            playerrenderer.m_117813_(poseStack, source, combinedLight, (AbstractClientPlayer)mc.f_91074_);
        }
        poseStack.m_85849_();
    }

    private static void addSiftingMovement(LocalPlayer player, PoseStack stack) {
        float degrees = (float)player.m_21212_() * (float)Math.PI / 10.0f;
        if (degrees > 0.0f) {
            float scale = 0.1f;
            stack.m_252880_(0.1f * Mth.m_14089_((float)degrees), 0.0f, 0.1f * Mth.m_14031_((float)degrees));
        }
    }

    private static float calculateArmMovement(LocalPlayer player) {
        float degrees = (float)player.m_21212_() * (float)Math.PI / 10.0f;
        if (degrees > 0.0f) {
            return 10.0f * Mth.m_14089_((float)degrees);
        }
        return 0.0f;
    }
}

