/*
 * Decompiled with CFR 0.152.
 */
package tfchotornot.common.items;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.SelfTests;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tfchotornot.common.items.HNItems;

public class HNItemGroup {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"tfchotornot");
    public static final CreativeTabHolder HOT_OR_NOT = HNItemGroup.register("tfchotornot", () -> new ItemStack((ItemLike)HNItems.METAL_TONGS.get(Metal.Default.ROSE_GOLD).get()), HNItemGroup::fillItemsTab);

    public static Stream<CreativeModeTab.DisplayItemsGenerator> generators() {
        return Stream.of(HOT_OR_NOT).map(holder -> holder.generator);
    }

    public static void fillItemsTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        HNItemGroup.accept(out, HNItems.MITTENS);
        HNItemGroup.accept(out, HNItems.BURLAP_POTHOLDER);
        HNItemGroup.accept(out, HNItems.SILK_POTHOLDER);
        HNItemGroup.accept(out, HNItems.WOOL_POTHOLDER);
        HNItemGroup.accept(out, HNItems.WOODEN_TONGS);
        for (Metal.Default metal : Metal.Default.values()) {
            if (!metal.hasParts()) continue;
            HNItemGroup.accept(out, HNItems.METAL_TONGS.get(metal));
            HNItemGroup.accept(out, HNItems.METAL_TONG_PARTS.get(metal));
        }
    }

    public static CreativeTabHolder register(String name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator displayItems) {
        RegistryObject reg = CREATIVE_TABS.register(name, () -> CreativeModeTab.builder().m_257737_(icon).m_257941_((Component)Component.m_237115_((String)("tfchotornot.creative_tab." + name))).m_257501_(displayItems).m_257652_());
        return new CreativeTabHolder((RegistryObject<CreativeModeTab>)reg, displayItems);
    }

    public static <T extends ItemLike, R extends Supplier<T>> void accept(CreativeModeTab.Output out, R reg) {
        if (((ItemLike)reg.get()).m_5456_() == Items.f_41852_) {
            SelfTests.reportExternalError();
            return;
        }
        out.m_246326_((ItemLike)reg.get());
    }

    public static <T> void consumeOurs(IForgeRegistry<T> registry, Consumer<T> consumer) {
        for (Object value : registry) {
            if (!Objects.requireNonNull(registry.getKey(value)).m_135827_().equals("tfchotornot")) continue;
            consumer.accept(value);
        }
    }

    public record CreativeTabHolder(RegistryObject<CreativeModeTab> tab, CreativeModeTab.DisplayItemsGenerator generator) {
    }
}

