/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.util;

import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import tfccaelum.Config;
import tfccaelum.Helpers;

public enum Planets {
    MERCURY(true, (double)((Double)Config.COMMON.mercuryDiameter.get()), (double)((Double)Config.COMMON.mercuryOrbitalPeriod.get()), (double)((Double)Config.COMMON.mercurySemiMajorAxis.get()), (double)((Double)Config.COMMON.mercurySynodicPeriod.get()), (Double)Config.COMMON.mercuryEclipticPlane.get(), 0.1, false),
    VENUS(true, (double)((Double)Config.COMMON.venusDiameter.get()), (double)((Double)Config.COMMON.venusOrbitalPeriod.get()), (double)((Double)Config.COMMON.venusSemiMajorAxis.get()), (double)((Double)Config.COMMON.venusSynodicPeriod.get()), (Double)Config.COMMON.venusEclipticPlane.get(), 0.1, false),
    MARS((Double)Config.COMMON.marsDiameter.get(), (double)((Double)Config.COMMON.marsOrbitalPeriod.get()), (double)((Double)Config.COMMON.marsSemiMajorAxis.get()), (double)((Double)Config.COMMON.marsSynodicPeriod.get()), (double)((Double)Config.COMMON.marsEclipticPlane.get()), 0.4, false),
    JUPITER((Double)Config.COMMON.jupiterDiameter.get(), (double)((Double)Config.COMMON.jupiterOrbitalPeriod.get()), (double)((Double)Config.COMMON.jupiterSemiMajorAxis.get()), (double)((Double)Config.COMMON.jupiterSynodicPeriod.get()), (double)((Double)Config.COMMON.jupiterEclipticPlane.get()), 0.125, false),
    SATURN((Double)Config.COMMON.saturnDiameter.get(), (double)((Double)Config.COMMON.saturnOrbitalPeriod.get()), (double)((Double)Config.COMMON.saturnSemiMajorAxis.get()), (double)((Double)Config.COMMON.saturnSynodicPeriod.get()), (double)((Double)Config.COMMON.saturnEclipticPlane.get()), 0.15, false),
    URANUS((Double)Config.COMMON.uranusDiameter.get(), (double)((Double)Config.COMMON.uranusOrbitalPeriod.get()), (double)((Double)Config.COMMON.uranusSemiMajorAxis.get()), (double)((Double)Config.COMMON.uranusSynodicPeriod.get()), (double)((Double)Config.COMMON.uranusEclipticPlane.get()), 0.4, false),
    NEPTUNE((Double)Config.COMMON.neptuneDiameter.get(), (double)((Double)Config.COMMON.neptuneOrbitalPeriod.get()), (double)((Double)Config.COMMON.neptuneSemiMajorAxis.get()), (double)((Double)Config.COMMON.neptuneSynodicPeriod.get()), (double)((Double)Config.COMMON.neptuneEclipticPlane.get()), 0.4, false),
    PLUTO((Double)Config.COMMON.plutoDiameter.get(), (double)((Double)Config.COMMON.plutoOrbitalPeriod.get()), (double)((Double)Config.COMMON.plutoSemiMajorAxis.get()), (double)((Double)Config.COMMON.plutoSynodicPeriod.get()), (double)((Double)Config.COMMON.plutoEclipticPlane.get()), 5.0, false),
    PERSEPHONE((Double)Config.COMMON.earthDiameter.get() * 4.0, 15000.0 * (Double)Config.COMMON.earthOrbitalPeriod.get(), 73302.956643, (double)((Double)Config.COMMON.earthOrbitalPeriod.get()), 16.0, 5.0, false),
    NEMESIS(571936.0, 11100.0 * (Double)Config.COMMON.earthOrbitalPeriod.get(), 1.41907926E7, (double)((Double)Config.COMMON.earthOrbitalPeriod.get()), 10.0, 20.0, false),
    GANYMEDE(5268.2, 7.15455296, 1.0704, (double)((Double)Config.COMMON.jupiterSynodicPeriod.get()), 0.2, true, false, JUPITER),
    CALLISTO(4820.6, 16.6890184, 1.8827, (double)((Double)Config.COMMON.jupiterSynodicPeriod.get()), 0.192, true, false, JUPITER),
    IO(3643.2, 1.769137786, 0.4217, (double)((Double)Config.COMMON.jupiterSynodicPeriod.get()), 0.05, true, false, JUPITER),
    EUROPA(3121.6, 3.551181, 0.669151, (double)((Double)Config.COMMON.jupiterSynodicPeriod.get()), 0.47, true, false, JUPITER),
    TITAN(5149.46, 15.945, 1.22187, (double)((Double)Config.COMMON.saturnSynodicPeriod.get()), 0.348, true, true, SATURN),
    TRITON(2706.8, 5.876854, 1.22187, (double)((Double)Config.COMMON.neptuneSynodicPeriod.get()), 156.885, true, false, NEPTUNE),
    CHARON(1212.5, 6.3872304, 0.709518, (double)((Double)Config.COMMON.plutoSynodicPeriod.get()), 0.08, 12.0, true, false, PLUTO);

    public final String serializedName = this.name().toLowerCase(Locale.ROOT);
    public final ResourceLocation texture;
    public final boolean isInferior;
    public final double diameter;
    public final double orbitalPeriod;
    public final double semiMajorAxis;
    public final double synodicPeriod;
    public final double eclipticPlaneAngle;
    public final double scaleFactor;
    public final boolean isMoon;
    public final boolean isRetrograde;
    public final Planets parentBody;

    private Planets(double diameter, double orbitalPeriod, double semiMajorAxis, double synodicPeriod, double eclipticPlaneAngle, boolean isRetrograde) {
        this(false, diameter, orbitalPeriod, semiMajorAxis, synodicPeriod, eclipticPlaneAngle, 1.0, false, isRetrograde, null);
    }

    private Planets(double diameter, double orbitalPeriod, double semiMajorAxis, double synodicPeriod, double eclipticPlaneAngle, double scaleFactor, boolean isRetrograde) {
        this(false, diameter, orbitalPeriod, semiMajorAxis, synodicPeriod, eclipticPlaneAngle, scaleFactor, false, isRetrograde, null);
    }

    private Planets(double diameter, double orbitalPeriod, double semiMajorAxis, double synodicPeriod, double eclipticPlaneAngle, boolean isMoon, boolean isRetrograde, Planets parentBody) {
        this(false, diameter, orbitalPeriod, semiMajorAxis, synodicPeriod, eclipticPlaneAngle, 1.0, isMoon, isRetrograde, parentBody);
    }

    private Planets(double diameter, double orbitalPeriod, double semiMajorAxis, double synodicPeriod, double eclipticPlaneAngle, double scaleFactor, boolean isMoon, boolean isRetrograde, Planets parentBody) {
        this(false, diameter, orbitalPeriod, semiMajorAxis, synodicPeriod, eclipticPlaneAngle, scaleFactor, isMoon, isRetrograde, parentBody);
    }

    private Planets(boolean isInferior, double diameter, double orbitalPeriod, double semiMajorAxis, double synodicPeriod, double eclipticPlaneAngle, boolean isRetrograde) {
        this(isInferior, diameter, orbitalPeriod, semiMajorAxis, synodicPeriod, eclipticPlaneAngle, 1.0, false, isRetrograde, null);
    }

    private Planets(boolean isInferior, double diameter, double orbitalPeriod, double semiMajorAxis, double synodicPeriod, double eclipticPlaneAngle, boolean isMoon, boolean isRetrograde, Planets parentBody) {
        this(isInferior, diameter, orbitalPeriod, semiMajorAxis, synodicPeriod, eclipticPlaneAngle, 1.0, isMoon, isRetrograde, parentBody);
    }

    private Planets(boolean isInferior, double diameter, double orbitalPeriod, double semiMajorAxis, double synodicPeriod, double eclipticPlaneAngle, double scaleFactor, boolean isRetrograde) {
        this(isInferior, diameter, orbitalPeriod, semiMajorAxis, synodicPeriod, eclipticPlaneAngle, scaleFactor, false, isRetrograde, null);
    }

    private Planets(boolean isInferior, double diameter, double orbitalPeriod, double semiMajorAxis, double synodicPeriod, double eclipticPlaneAngle, double scaleFactor, boolean isMoon, boolean isRetrograde, Planets parentBody) {
        this.isInferior = isInferior;
        this.diameter = diameter;
        this.orbitalPeriod = orbitalPeriod;
        this.semiMajorAxis = semiMajorAxis;
        this.synodicPeriod = synodicPeriod;
        this.eclipticPlaneAngle = eclipticPlaneAngle;
        this.scaleFactor = scaleFactor;
        this.isMoon = isMoon;
        this.isRetrograde = isRetrograde;
        this.parentBody = parentBody;
        this.texture = Helpers.identifier("sky/planets/" + this.serializedName + ".png");
    }

    public boolean isInferior() {
        return this.isInferior;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public double getDiameter() {
        return this.diameter;
    }

    public double getOrbitalPeriod() {
        return this.orbitalPeriod;
    }

    public double getSemiMajorAxis() {
        return !this.getIsMoon() ? this.semiMajorAxis * (double)((Double)Config.COMMON.planetDistance.get()).floatValue() : this.semiMajorAxis * (Double)Config.COMMON.planetScale.get();
    }

    public double getSemiMajorAxisMega() {
        double distance = this.getSemiMajorAxis() * Math.pow(10.0, 6.0);
        return !this.getIsMoon() ? distance : distance * 50.0;
    }

    public double getSynodicPeriod() {
        return this.synodicPeriod;
    }

    public double getInclination() {
        return this.getIsMoon() ? this.getParentBody().eclipticPlaneAngle : this.eclipticPlaneAngle;
    }

    public double getMoonInclination() {
        return this.eclipticPlaneAngle;
    }

    public double getApparentDiameterArcSec(double distance) {
        return 206265.0 * (this.getDiameter() / distance);
    }

    public double getScale(Level level, float partialTicks) {
        return this.getApparentDiameterArcSec(Math.abs(new Vector2f(0.0f, 0.0f).distance((Vector2fc)this.getVector(level, partialTicks)))) * this.getScaleFactor();
    }

    public double getScaleFactor() {
        return this.scaleFactor * (Double)Config.COMMON.planetScale.get();
    }

    public boolean getIsMoon() {
        return this.isMoon;
    }

    public boolean getIsRetrograde() {
        return this.isRetrograde;
    }

    public Planets getParentBody() {
        return this.parentBody;
    }

    public double getAngleToParent(Level level, float partialTicks) {
        return Math.toDegrees(this.getParentVector(level, partialTicks).angle((Vector2fc)this.getVector(level, partialTicks)));
    }

    public double getAngleToSun(Level level, float partialTicks) {
        return Math.toDegrees(Planets.getSunVector(level, partialTicks).angle((Vector2fc)this.getVector(level, partialTicks)));
    }

    public static Vector2f getSunVector(Level level, float partialTicks) {
        return new Vector2f(Mth.m_14031_((float)0.0f), Mth.m_14089_((float)0.0f)).mul((float)((double)((Double)Config.COMMON.earthSemiMajorAxis.get()).floatValue() * Math.pow(10.0, 6.0)));
    }

    public Vector2f getParentVector(Level level, float partialTicks) {
        return !this.isMoon ? Planets.getSunVector(level, partialTicks) : this.getParentBody().getVector(level, partialTicks);
    }

    public Vector2f getVector(Level level, float partialTicks) {
        return new Vector2f((Vector2fc)Helpers.orbitalSpirographicPosition((LevelAccessor)level, this.getParentVector(level, partialTicks), (float)this.getSemiMajorAxisMega(), (Double)Config.COMMON.earthOrbitalPeriod.get(), this.getOrbitalPeriod(), partialTicks, this.getIsRetrograde()));
    }
}

