/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.util;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tfccaelum.util.AuroraHandler;
import tfccaelum.util.HandlerBase;
import tfccaelum.util.ObjectArray;
import tfccaelum.util.TickCounter;

@Mod.EventBusSubscriber(modid="tfccaelum", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Manager {
    public static final Manager manager = new Manager();
    public static boolean isConnected = false;
    public final ObjectArray<HandlerBase> effectHandlers = new ObjectArray();

    public static Manager instance() {
        return manager;
    }

    public Manager() {
        this.init();
    }

    public void register(@Nonnull HandlerBase handler) {
        this.effectHandlers.add(handler);
    }

    public void init() {
        this.register(new AuroraHandler());
    }

    public void onConnect() {
        for (HandlerBase h : this.effectHandlers) {
            h.connect0();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onDisconnect() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        for (HandlerBase h : this.effectHandlers) {
            h.disconnect0();
        }
    }

    public static void connect() {
        if (isConnected) {
            Manager.disconnect();
        }
        manager.onConnect();
        isConnected = true;
    }

    public static void disconnect() {
        if (isConnected) {
            manager.onDisconnect();
            isConnected = false;
        }
    }

    protected static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    protected boolean checkReady(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END || Minecraft.m_91087_().m_91104_()) {
            return false;
        }
        return Minecraft.m_91087_().f_91073_ != null && Manager.getPlayer() != null;
    }

    public void onTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (!this.checkReady(event)) {
            return;
        }
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("TFCCaelum Client Tick");
        long tick = TickCounter.getTickCount();
        for (HandlerBase handler : this.effectHandlers) {
            profiler.m_6180_(handler.getHandlerName());
            if (handler.doTick(tick)) {
                handler.process(Manager.getPlayer());
            }
            profiler.m_7238_();
        }
        profiler.m_7238_();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void clientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (isConnected) {
            manager.onTick(event);
        }
    }
}

