/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.util;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tfccaelum.Config;
import tfccaelum.TFCCaelum;
import tfccaelum.shaders.aurora.AuroraFactory;
import tfccaelum.shaders.aurora.AuroraUtils;
import tfccaelum.shaders.aurora.IAurora;
import tfccaelum.util.HandlerBase;

@OnlyIn(value=Dist.CLIENT)
public final class AuroraHandler
extends HandlerBase {
    public static AuroraHandler handler;
    public IAurora current;
    public ResourceKey<Level> dimensionId;

    public AuroraHandler() {
        super("Aurora");
    }

    @Override
    public void onConnect() {
        handler = this;
        this.current = null;
    }

    @Override
    public void onDisconnect() {
        this.current = null;
        handler = null;
    }

    public boolean isAuroraTimeOfDay(@Nonnull Player player) {
        return true;
    }

    public boolean canSpawnAurora(@Nonnull Player player) {
        return this.current == null && this.canAuroraStay(player);
    }

    public boolean canAuroraStay(@Nonnull Player player) {
        return (Boolean)Config.COMMON.enableAurora.get() != false;
    }

    @Override
    public void process(@Nonnull Player player) {
        TFCCaelum.LOGGER.info("Aurora check");
        if (this.current != null) {
            if (this.current.isComplete() || !((Boolean)Config.COMMON.enableAurora.get()).booleanValue()) {
                this.current = null;
            } else {
                this.current.update();
                boolean isDying = this.current.isDying();
                boolean canStay = this.canAuroraStay(player);
                if (isDying && canStay) {
                    if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
                        TFCCaelum.LOGGER.debug("Unfading aurora...");
                    }
                    this.current.setFading(false);
                } else if (!isDying && !canStay) {
                    if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
                        TFCCaelum.LOGGER.debug("Aurora fade...");
                    }
                    this.current.setFading(true);
                }
            }
        }
        if (this.canSpawnAurora(player)) {
            this.current = AuroraFactory.produce(AuroraUtils.getSeed());
            if (((Boolean)Config.COMMON.enableDebug.get()).booleanValue()) {
                TFCCaelum.LOGGER.debug("New aurora [%s]", (Object)this.current.toString());
            }
        }
        this.dimensionId = player.m_9236_().m_46472_();
    }

    public void doRender(LevelAccessor level, @Nonnull PoseStack matrixStack, float partialTick) {
        if (this.current != null) {
            this.current.render(level, matrixStack, partialTick);
        }
    }

    public static void renderHook(LevelAccessor level, @Nonnull PoseStack matrixStack, float partialTick) {
        if (handler != null) {
            ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
            profiler.m_6180_("Aurora Render");
            handler.doRender(level, matrixStack, partialTick);
            profiler.m_7238_();
        }
    }
}

