/*
 * Decompiled with CFR 0.152.
 */
package tfccaelum.shaders.aurora;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tfccaelum.gui.Color;
import tfccaelum.gui.ColorPalette;

@OnlyIn(value=Dist.CLIENT)
public final class AuroraColor {
    public static final List<AuroraColor> COLOR_SETS = new ArrayList<AuroraColor>();
    public static final float WARMER = 0.3f;
    public static final float COOLER = -0.3f;
    public final Color baseColor;
    public final Color fadeColor;
    public final Color middleColor;

    public AuroraColor(@Nonnull Color base, @Nonnull Color fade) {
        this(base, fade, base);
    }

    public AuroraColor(@Nonnull Color base, @Nonnull Color fade, @Nonnull Color mid) {
        this.baseColor = base;
        this.fadeColor = fade;
        this.middleColor = mid;
    }

    @Nonnull
    public static AuroraColor get(@Nonnull Random random) {
        int idx = random.nextInt(COLOR_SETS.size());
        return COLOR_SETS.get(idx);
    }

    static {
        COLOR_SETS.add(new AuroraColor(new Color(0, 255, 153), new Color(51, 255, 0)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.BLUE, ColorPalette.GREEN));
        COLOR_SETS.add(new AuroraColor(ColorPalette.MAGENTA, ColorPalette.GREEN));
        COLOR_SETS.add(new AuroraColor(ColorPalette.INDIGO, ColorPalette.GREEN));
        COLOR_SETS.add(new AuroraColor(ColorPalette.TURQOISE, ColorPalette.LGREEN));
        COLOR_SETS.add(new AuroraColor(ColorPalette.YELLOW, ColorPalette.RED));
        COLOR_SETS.add(new AuroraColor(ColorPalette.GREEN, ColorPalette.RED));
        COLOR_SETS.add(new AuroraColor(ColorPalette.GREEN, ColorPalette.YELLOW));
        COLOR_SETS.add(new AuroraColor(ColorPalette.RED, ColorPalette.YELLOW));
        COLOR_SETS.add(new AuroraColor(ColorPalette.NAVY, ColorPalette.INDIGO));
        COLOR_SETS.add(new AuroraColor(ColorPalette.CYAN, ColorPalette.MAGENTA));
        COLOR_SETS.add(new AuroraColor(ColorPalette.AURORA_GREEN, ColorPalette.AURORA_RED, ColorPalette.AURORA_BLUE));
        COLOR_SETS.add(new AuroraColor(ColorPalette.YELLOW.luminance(0.3f), ColorPalette.RED.luminance(0.3f)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.GREEN.luminance(0.3f), ColorPalette.RED.luminance(0.3f)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.GREEN.luminance(0.3f), ColorPalette.YELLOW.luminance(0.3f)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.BLUE.luminance(0.3f), ColorPalette.GREEN.luminance(0.3f)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.INDIGO.luminance(0.3f), ColorPalette.GREEN.luminance(0.3f)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.AURORA_GREEN.luminance(0.3f), ColorPalette.AURORA_RED.luminance(0.3f), ColorPalette.AURORA_BLUE.luminance(0.3f)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.YELLOW.luminance(-0.3f), ColorPalette.RED.luminance(-0.3f)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.GREEN.luminance(-0.3f), ColorPalette.RED.luminance(-0.3f)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.GREEN.luminance(-0.3f), ColorPalette.YELLOW.luminance(-0.3f)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.BLUE.luminance(-0.3f), ColorPalette.GREEN.luminance(-0.3f)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.INDIGO.luminance(-0.3f), ColorPalette.GREEN.luminance(-0.3f)));
        COLOR_SETS.add(new AuroraColor(ColorPalette.AURORA_GREEN.luminance(-0.3f), ColorPalette.AURORA_RED.luminance(-0.3f), ColorPalette.AURORA_BLUE.luminance(-0.3f)));
    }
}

